/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerInput;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.jscomp.ScopeCreator;
import com.google.gwt.thirdparty.javascript.rhino.InputId;
import com.google.gwt.thirdparty.javascript.rhino.Node;

class SyntacticScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private Scope scope;
    private InputId inputId;
    private final RedeclarationHandler redeclarationHandler;
    private static final String ARGUMENTS = "arguments";

    SyntacticScopeCreator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.redeclarationHandler = new DefaultRedeclarationHandler();
    }

    SyntacticScopeCreator(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler) {
        this.compiler = compiler;
        this.redeclarationHandler = redeclarationHandler;
    }

    @Override
    public Scope createScope(Node n, Scope parent) {
        this.inputId = null;
        this.scope = parent == null ? Scope.createGlobalScope(n) : new Scope(parent, n);
        this.scanRoot(n);
        this.inputId = null;
        Scope returnedScope = this.scope;
        this.scope = null;
        return returnedScope;
    }

    private void scanRoot(Node n) {
        if (n.isFunction()) {
            if (this.inputId == null) {
                this.inputId = NodeUtil.getInputId(n);
            }
            Node fnNameNode = n.getFirstChild();
            Node args = fnNameNode.getNext();
            Node body = args.getNext();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && NodeUtil.isFunctionExpression(n)) {
                this.declareVar(fnNameNode);
            }
            Preconditions.checkState((boolean)args.isParamList());
            Node a = args.getFirstChild();
            while (a != null) {
                Preconditions.checkState((boolean)a.isName());
                this.declareVar(a);
                a = a.getNext();
            }
            this.scanVars(body);
        } else {
            Preconditions.checkState((this.scope.getParent() == null ? 1 : 0) != 0);
            this.scanVars(n);
        }
    }

    private void scanVars(Node n) {
        switch (n.getType()) {
            case 118: {
                Node child = n.getFirstChild();
                while (child != null) {
                    Node next = child.getNext();
                    this.declareVar(child);
                    child = next;
                }
                return;
            }
            case 105: {
                if (NodeUtil.isFunctionExpression(n)) {
                    return;
                }
                String fnName = n.getFirstChild().getString();
                if (fnName.isEmpty()) {
                    return;
                }
                this.declareVar(n.getFirstChild());
                return;
            }
            case 120: {
                Preconditions.checkState((n.getChildCount() == 2 ? 1 : 0) != 0);
                Preconditions.checkState((boolean)n.getFirstChild().isName());
                Node var = n.getFirstChild();
                Node block = var.getNext();
                this.declareVar(var);
                this.scanVars(block);
                return;
            }
            case 132: {
                this.inputId = n.getInputId();
                Preconditions.checkNotNull((Object)this.inputId);
            }
        }
        if (NodeUtil.isControlStructure(n) || NodeUtil.isStatementBlock(n)) {
            Node child = n.getFirstChild();
            while (child != null) {
                Node next = child.getNext();
                this.scanVars(child);
                child = next;
            }
        }
    }

    private void declareVar(Node n) {
        Preconditions.checkState((boolean)n.isName());
        CompilerInput input = this.compiler.getInput(this.inputId);
        String name = n.getString();
        if (this.scope.isDeclared(name, false) || this.scope.isLocal() && name.equals(ARGUMENTS)) {
            this.redeclarationHandler.onRedeclaration(this.scope, name, n, input);
        } else {
            this.scope.declare(name, n, null, input);
        }
    }

    static Scope generateUntypedTopScope(AbstractCompiler compiler) {
        return new SyntacticScopeCreator(compiler).createScope(compiler.getRoot(), null);
    }

    private class DefaultRedeclarationHandler
    implements RedeclarationHandler {
        private DefaultRedeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
        }
    }

    static interface RedeclarationHandler {
        public void onRedeclaration(Scope var1, String var2, Node var3, CompilerInput var4);
    }
}

