/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Charsets;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Map;

public class VariableMap {
    private final ImmutableMap<String, String> map;
    private ImmutableMap<String, String> reverseMap = null;
    private static final char SEPARATOR = ':';
    private static final Splitter LINE_SPLITTER = Splitter.onPattern((String)"\\r?\\n").omitEmptyStrings();

    VariableMap(Map<String, String> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    public String lookupNewName(String sourceName) {
        return (String)this.map.get((Object)sourceName);
    }

    public String lookupSourceName(String newName) {
        this.initReverseMap();
        return (String)this.reverseMap.get((Object)newName);
    }

    private synchronized void initReverseMap() {
        if (this.reverseMap == null) {
            ImmutableMap.Builder rm = ImmutableMap.builder();
            for (Map.Entry entry : this.map.entrySet()) {
                rm.put((Object)((String)entry.getValue()), (Object)((String)entry.getKey()));
            }
            this.reverseMap = rm.build();
        }
    }

    public Map<String, String> getOriginalNameToNewNameMap() {
        return this.map;
    }

    public Map<String, String> getNewNameToOriginalNameMap() {
        this.initReverseMap();
        return this.reverseMap;
    }

    public void save(String filename) throws IOException {
        Files.write((byte[])this.toBytes(), (File)new File(filename));
    }

    public static VariableMap load(String filename) throws IOException {
        try {
            return VariableMap.fromBytes(Files.toByteArray((File)new File(filename)));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, Charsets.UTF_8);
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                writer.write(VariableMap.escape((String)entry.getKey()));
                ((Writer)writer).write(58);
                writer.write(VariableMap.escape((String)entry.getValue()));
                ((Writer)writer).write(10);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public static VariableMap fromBytes(byte[] bytes) throws ParseException {
        Iterable lines = LINE_SPLITTER.split((CharSequence)new String(bytes, Charsets.UTF_8));
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (String line : lines) {
            int pos = VariableMap.findIndexOfChar(line, ':');
            if (pos <= 0 || pos == line.length() - 1) {
                throw new ParseException("Bad line: " + line, 0);
            }
            map.put((Object)VariableMap.unescape(line.substring(0, pos)), (Object)VariableMap.unescape(line.substring(pos + 1)));
        }
        return new VariableMap((Map<String, String>)map.build());
    }

    private static String escape(String value) {
        return value.replace("\\", "\\\\").replace(":", "\\:").replace("\n", "\\n");
    }

    private static int findIndexOfChar(String value, char stopChar) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\\' && ++i < len) {
                c = value.charAt(i);
            } else if (c == stopChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String unescape(CharSequence value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\\' && ++i < len) {
                c = value.charAt(i);
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static VariableMap fromMap(Map<String, String> map) {
        return new VariableMap(map);
    }

    @VisibleForTesting
    Map<String, String> toMap() {
        return this.map;
    }
}

