/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.deps;

import com.google.gwt.thirdparty.guava.common.base.CharMatcher;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;

public final class PathUtil {
    private static final CharMatcher SLASH_MATCHER = CharMatcher.is((char)'/');
    private static final CharMatcher NON_SLASH_MATCHER = CharMatcher.isNot((char)'/');

    private PathUtil() {
    }

    public static String collapseDots(String path) {
        if (!(path = PathUtil.removeExtraneousSlashes(path)).contains(".")) {
            return path;
        }
        String[] srcFragments = path.split("/");
        ArrayList dstFragments = Lists.newArrayList();
        String[] stringArray = srcFragments;
        int n = srcFragments.length;
        int n2 = 0;
        while (n2 < n) {
            String fragment = stringArray[n2];
            if (fragment.equals("..")) {
                if (!dstFragments.isEmpty()) {
                    dstFragments.remove(dstFragments.size() - 1);
                }
            } else if (!fragment.equals(".")) {
                dstFragments.add(fragment);
            }
            ++n2;
        }
        if (dstFragments.size() == 1 && ((String)dstFragments.get(0)).isEmpty()) {
            return "/";
        }
        return Joiner.on((String)"/").join((Iterable)dstFragments);
    }

    static boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    static String removeExtraneousSlashes(String s) {
        int lastNonSlash = NON_SLASH_MATCHER.lastIndexIn((CharSequence)s);
        if (lastNonSlash != -1) {
            s = s.substring(0, lastNonSlash + 1);
        }
        return SLASH_MATCHER.collapseFrom((CharSequence)s, '/');
    }

    public static String makeAbsolute(String path) {
        return PathUtil.makeAbsolute(path, System.getProperty("user.dir"));
    }

    public static String makeAbsolute(String path, String rootPath) {
        if (!PathUtil.isAbsolute(path)) {
            path = String.valueOf(rootPath) + "/" + path;
        }
        return PathUtil.collapseDots(path);
    }

    public static String makeRelative(String basePath, String targetPath) {
        if (PathUtil.isAbsolute(basePath) != PathUtil.isAbsolute(targetPath)) {
            throw new IllegalArgumentException("Paths must both be relative or both absolute.\n  basePath: " + basePath + "\n" + "  targetPath: " + targetPath);
        }
        basePath = PathUtil.collapseDots(basePath);
        targetPath = PathUtil.collapseDots(targetPath);
        String[] baseFragments = basePath.split("/");
        String[] targetFragments = targetPath.split("/");
        int i = -1;
        do {
            if (++i == baseFragments.length && i == targetFragments.length) {
                return ".";
            }
            if (i == baseFragments.length) {
                return Joiner.on((String)"/").join((Iterable)Lists.newArrayList(Arrays.asList(targetFragments).listIterator(i)));
            }
            if (i != targetFragments.length) continue;
            return String.valueOf(Strings.repeat((String)"../", (int)(baseFragments.length - i - 1))) + "..";
        } while (baseFragments[i].equals(targetFragments[i]));
        return String.valueOf(Strings.repeat((String)"../", (int)(baseFragments.length - i))) + Joiner.on((String)"/").join((Iterable)Lists.newArrayList(Arrays.asList(targetFragments).listIterator(i)));
    }
}

