/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.base.CaseFormat;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.AssignableExprFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Dispatcher;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Type;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Set;

public class BinaryExprFuzzer
extends Dispatcher {
    BinaryExprFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected void initCandidates() {
        Operator[] operators = Operator.values();
        this.candidates = new BinaryExprGenerator[operators.length];
        int i = 0;
        while (i < operators.length) {
            this.candidates[i] = new BinaryExprGenerator(this.context, operators[i]);
            ++i;
        }
    }

    @Override
    protected String getConfigName() {
        return "binaryExpr";
    }

    private class BinaryExprGenerator
    extends AbstractFuzzer {
        private Operator operator;
        private AbstractFuzzer left;
        private AbstractFuzzer right;
        private String configName;

        BinaryExprGenerator(FuzzingContext context, Operator operator) {
            super(context);
            this.configName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, operator.name());
            this.operator = operator;
        }

        @Override
        protected Node generate(int budget, Set<Type> types) {
            Node[] operands = this.distribute(budget - 1, new AbstractFuzzer[]{this.getLeft(), this.getRight()});
            return new Node(this.operator.nodeType, operands);
        }

        @Override
        protected Node fuzz(AbstractFuzzer fuzzer, int budget) {
            if (this.context.strict && fuzzer == this.getRight()) {
                return fuzzer.generate(budget, this.operator.rightTypes);
            }
            return fuzzer.generate(budget);
        }

        private AbstractFuzzer getLeft() {
            if (this.left == null) {
                this.left = this.operator.hasSideEffect() ? new AssignableExprFuzzer(this.context) : new ExpressionFuzzer(this.context);
            }
            return this.left;
        }

        private AbstractFuzzer getRight() {
            if (this.right == null) {
                this.right = new ExpressionFuzzer(this.context);
            }
            return this.right;
        }

        @Override
        protected boolean isEnough(int budget) {
            if (budget < 1) {
                return false;
            }
            return this.getLeft().isEnough(budget - 2) && this.getRight().isEnough(budget - 2);
        }

        @Override
        protected String getConfigName() {
            return this.configName;
        }
    }

    private static enum Operator {
        MUL(23),
        DIV(24),
        MOD(25),
        ADD(21),
        SUB(22),
        LSH(18),
        RSH(19),
        URSH(20),
        LT(14),
        GT(16),
        LE(15),
        GE(17),
        INSTANCEOF(52, Sets.newHashSet((Object[])new Type[]{Type.FUNCTION})),
        IN(51, Sets.newHashSet((Object[])new Type[]{Type.OBJECT})),
        EQ(12),
        NE(13),
        SHEQ(45),
        SHNE(46),
        BIT_AND(11),
        BIT_XOR(10),
        BIT_OR(9),
        AND(101),
        OR(100),
        ASSIGN(86),
        ASSIGN_MUL(95),
        ASSIGN_DIV(96),
        ASSIGN_MOD(97),
        ASSIGN_ADD(93),
        ASSIGN_SUB(94),
        ASSIGN_LSH(90),
        ASSIGN_RSH(91),
        ASSIGN_URSH(92),
        ASSIGN_BIT_AND(89),
        ASSIGN_BIT_XOR(88),
        ASSIGN_BIT_OR(87);

        int nodeType;
        Set<Type> rightTypes;

        private Operator(int nodeType) {
            this.nodeType = nodeType;
            this.rightTypes = Sets.newHashSet((Object[])Type.values());
        }

        private Operator(int nodeType, Set<Type> rightTypes) {
            this.nodeType = nodeType;
            this.rightTypes = rightTypes;
        }

        boolean hasSideEffect() {
            return this.name().startsWith("ASSIGN");
        }
    }
}

