/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.DiscreteDistribution;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Type;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

abstract class Dispatcher
extends AbstractFuzzer {
    private Set<Type> supportedTypes;
    protected AbstractFuzzer[] candidates;

    Dispatcher(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        if (budget < 1) {
            return false;
        }
        Preconditions.checkNotNull((Object)this.getCandidates(), (Object)"Candidate fuzzers need to be initialized before being used.");
        AbstractFuzzer[] abstractFuzzerArray = this.getCandidates();
        int n = abstractFuzzerArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFuzzer fuzzer = abstractFuzzerArray[n2];
            if (fuzzer.isEnough(budget)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        AbstractFuzzer fuzzer = this.selectFuzzer(budget, types);
        return fuzzer.generate(budget, types);
    }

    @Override
    protected Set<Type> supportedTypes() {
        if (this.supportedTypes == null) {
            this.supportedTypes = Sets.newHashSet();
            AbstractFuzzer[] abstractFuzzerArray = this.getCandidates();
            int n = abstractFuzzerArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractFuzzer fuzzer = abstractFuzzerArray[n2];
                this.supportedTypes.addAll(fuzzer.supportedTypes());
                ++n2;
            }
        }
        return this.supportedTypes;
    }

    protected AbstractFuzzer selectFuzzer(int budget, Set<Type> types) {
        Preconditions.checkNotNull((Object)this.getCandidates(), (Object)"Candidate fuzzers need to be initialized before being used.");
        ArrayList typeCorrectCandidates = Lists.newArrayList();
        AbstractFuzzer[] abstractFuzzerArray = this.getCandidates();
        int n = abstractFuzzerArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFuzzer fuzzer = abstractFuzzerArray[n2];
            if (!Sets.intersection(fuzzer.supportedTypes(), types).isEmpty()) {
                typeCorrectCandidates.add(fuzzer);
            }
            ++n2;
        }
        JSONObject weightConfig = this.getOwnConfig().optJSONObject("weights");
        ArrayList validFuzzers = Lists.newArrayList();
        ArrayList weights = Lists.newArrayList();
        int stepSize = 2;
        budget -= stepSize;
        do {
            budget += stepSize;
            for (AbstractFuzzer fuzzer : typeCorrectCandidates) {
                if (!fuzzer.isEnough(budget)) continue;
                validFuzzers.add(fuzzer);
                try {
                    weights.add(weightConfig.getDouble(fuzzer.getConfigName()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } while (validFuzzers.size() == 0);
        DiscreteDistribution dd = new DiscreteDistribution(this.context.random, validFuzzers, weights);
        return (AbstractFuzzer)dd.nextItem();
    }

    protected abstract void initCandidates();

    private AbstractFuzzer[] getCandidates() {
        if (this.candidates == null) {
            this.initCandidates();
        }
        return this.candidates;
    }
}

