/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.javascript.jscomp.CommandLineRunner;
import com.google.gwt.thirdparty.javascript.jscomp.CompilationLevel;
import com.google.gwt.thirdparty.javascript.jscomp.Compiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerInput;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerOptions;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.Result;
import com.google.gwt.thirdparty.javascript.jscomp.SourceFile;
import com.google.gwt.thirdparty.javascript.jscomp.SyntheticAst;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Fuzzer;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Driver {
    @Option(name="--number_of_runs", usage="The number of runs of the fuzzer. Default: 1")
    private int numberOfRuns = 1;
    @Option(name="--max_ast_size", usage="The max number of nodes in the generated ASTs. Default: 100")
    private int maxASTSize = 100;
    @Option(name="--compilation_level", usage="Specifies the compilation level to use. Default: SIMPLE_OPTIMIZATIONS")
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    @Option(name="--seed", usage="Specifies the seed for the fuzzer. If not given, System.currentTimeMillis() will be used")
    private long seed = -1L;
    @Option(name="--logging_level", usage="Specifies the logging level for the driver. Default: INFO")
    private LoggingLevel level = LoggingLevel.INFO;

    public Result compile(String code) throws IOException {
        Compiler compiler = new Compiler();
        return compiler.compile(CommandLineRunner.getDefaultExterns(), Arrays.asList(SourceFile.fromCode("[fuzzedCode]", code)), this.getOptions());
    }

    public Result compile(Node script) throws IOException {
        CompilerInput input = new CompilerInput(new SyntheticAst(script));
        JSModule jsModule = new JSModule("fuzzedModule");
        jsModule.add(input);
        Compiler compiler = new Compiler();
        compiler.setTimeout(30);
        return compiler.compileModules(CommandLineRunner.getDefaultExterns(), Arrays.asList(jsModule), this.getOptions());
    }

    private CompilerOptions getOptions() {
        CompilerOptions options = new CompilerOptions();
        this.compilationLevel.setOptionsForCompilationLevel(options);
        return options;
    }

    public static void main(String[] args) {
        Driver driver = new Driver();
        CmdLineParser parser2 = new CmdLineParser((Object)driver);
        try {
            parser2.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser2.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        Logger logger = Logger.getLogger(Driver.class.getName());
        logger.setLevel(driver.level.getLevel());
        if (driver.seed != -1L) {
            driver.numberOfRuns = 1;
        }
        int i = 0;
        while (i < driver.numberOfRuns) {
            StringBuffer sb;
            logger.info("Running fuzzer [" + i + " of " + driver.numberOfRuns + "]");
            long seed = driver.seed == -1L ? System.currentTimeMillis() : driver.seed;
            Random random = new Random(seed);
            Fuzzer fuzzer = new Fuzzer(random);
            Node[] nodes = null;
            try {
                nodes = fuzzer.generateProgram(driver.maxASTSize);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Fuzzer error!\nSeed: " + seed, e);
            }
            Node script = Fuzzer.buildScript(nodes);
            String code = Fuzzer.getPrettyCode(script);
            try {
                Result result = driver.compile(script);
                if (result.success && result.warnings.length == 0) {
                    logger.info("Compilation Succeeded!\n");
                    sb = new StringBuffer("Seed: ");
                    sb.append(seed);
                    sb.append("\nJavaScript: ");
                    sb.append(code);
                    logger.fine(sb.toString());
                } else {
                    sb = new StringBuffer("Compilation Failed!\nSeed: ");
                    sb.append(seed);
                    sb.append("\nJavaScript: ");
                    sb.append(code);
                    logger.warning(sb.toString());
                }
            }
            catch (Exception e) {
                sb = new StringBuffer("Compiler error!\nSeed: ");
                sb.append(seed);
                sb.append("\nJavaScript: ");
                sb.append(code);
                logger.log(Level.SEVERE, sb.toString(), e);
            }
            ++i;
        }
        System.out.println("Done!");
        System.exit(0);
    }

    static enum LoggingLevel {
        OFF(Level.OFF),
        SEVERE(Level.SEVERE),
        WARNING(Level.WARNING),
        INFO(Level.INFO),
        CONFIG(Level.CONFIG),
        FINE(Level.FINE),
        FINER(Level.FINER),
        FINEST(Level.FINEST),
        ALL(Level.ALL);

        private Level level;

        private LoggingLevel(Level l) {
            this.level = l;
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

