/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Dispatcher;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.ExistingIdentifierFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FunctionFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.GetElemFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.GetPropFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Type;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Set;

class FunctionCallFuzzer
extends Dispatcher {
    FunctionCallFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected void initCandidates() {
        CallFuzzer constructorFuzzer = new CallFuzzer(this.context, true);
        CallFuzzer normalCallFuzzer = new CallFuzzer(this.context, false);
        this.candidates = new AbstractFuzzer[]{constructorFuzzer, normalCallFuzzer};
    }

    @Override
    protected String getConfigName() {
        return "functionCall";
    }

    private class CallFuzzer
    extends AbstractFuzzer {
        private int nodeType;
        private CallableExprFuzzer callableExprFuzzer;
        private String configName;

        CallFuzzer(FuzzingContext context, boolean isConstructor) {
            super(context);
            if (isConstructor) {
                this.nodeType = 30;
                this.configName = "constructorCall";
            } else {
                this.nodeType = 37;
                this.configName = "normalCall";
            }
        }

        @Override
        protected boolean isEnough(int budget) {
            if (budget < 1) {
                return false;
            }
            return this.getCallableExprFuzzer().isEnough(budget - 1);
        }

        @Override
        protected Node generate(int budget, Set<Type> types) {
            int maxParamBudget = budget - 2;
            if (maxParamBudget < 0) {
                maxParamBudget = 0;
            }
            double argLength = this.getOwnConfig().optDouble("argLength");
            int numArgs = this.context.random.nextInt((int)((double)maxParamBudget * argLength) + 1);
            AbstractFuzzer[] fuzzers = new AbstractFuzzer[numArgs + 1];
            fuzzers[0] = this.getCallableExprFuzzer();
            ExpressionFuzzer exprFuzzer = new ExpressionFuzzer(this.context);
            int i = 1;
            while (i <= numArgs) {
                fuzzers[i] = exprFuzzer;
                ++i;
            }
            Node[] components = this.distribute(maxParamBudget, fuzzers);
            Node node = new Node(this.nodeType, components);
            return node;
        }

        private CallableExprFuzzer getCallableExprFuzzer() {
            if (this.callableExprFuzzer == null) {
                this.callableExprFuzzer = new CallableExprFuzzer(this.context);
            }
            return this.callableExprFuzzer;
        }

        @Override
        protected String getConfigName() {
            return this.configName;
        }

        private class CallableExprFuzzer
        extends Dispatcher {
            CallableExprFuzzer(FuzzingContext context) {
                super(context);
            }

            @Override
            protected void initCandidates() {
                ExistingIdentifierFuzzer idFuzzer = this.context.strict ? new ExistingIdentifierFuzzer(this.context, Type.FUNCTION, false) : new ExistingIdentifierFuzzer(this.context);
                this.candidates = new AbstractFuzzer[]{idFuzzer, new GetPropFuzzer(this.context), new GetElemFuzzer(this.context), new FunctionFuzzer(this.context, true)};
            }

            @Override
            protected String getConfigName() {
                return "callableExpr";
            }
        }
    }
}

