/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.IdentifierFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.ScopeManager;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.SourceElementFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Type;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class FunctionFuzzer
extends AbstractFuzzer {
    private boolean isExpression;
    private IdentifierFuzzer idFuzzer;

    public FunctionFuzzer(FuzzingContext context, boolean isExpression) {
        super(context);
        this.isExpression = isExpression;
    }

    @Override
    protected boolean isEnough(int budget) {
        if (this.isExpression) {
            return budget >= 3;
        }
        return budget >= 4;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int paramBodyBudget;
        Node name;
        ScopeManager scopeManager = this.context.scopeManager;
        if (this.isExpression) {
            Preconditions.checkArgument((budget >= 3 ? 1 : 0) != 0);
            scopeManager.addScope();
            if (budget >= 4 && this.context.random.nextInt(2) == 0) {
                name = this.getIdFuzzer().generate(1);
                paramBodyBudget = budget - 3;
            } else {
                name = Node.newString(38, "");
                paramBodyBudget = budget - 2;
            }
        } else {
            Preconditions.checkArgument((budget >= 4 ? 1 : 0) != 0);
            name = this.getIdFuzzer().generate(1);
            paramBodyBudget = budget - 3;
            scopeManager.addScope();
        }
        int numParams = this.context.random.nextInt(this.getOwnConfig().optInt("maxParams") + 1);
        int bodyBudget = paramBodyBudget - numParams - 1;
        Node params = new ParamListFuzzer(this.context).generate(numParams);
        int numStmts = this.generateLength(bodyBudget);
        if (numStmts < 1) {
            numStmts = 1;
        }
        Object[] fuzzers = new AbstractFuzzer[numStmts];
        Arrays.fill(fuzzers, new SourceElementFuzzer(this.context));
        Node[] components = this.distribute(paramBodyBudget, (AbstractFuzzer[])fuzzers);
        Node body = new Node(125);
        int i = 0;
        while (i < numStmts) {
            body.addChildToBack(components[i]);
            ++i;
        }
        scopeManager.removeScope();
        return new Node(105, name, params, body);
    }

    private IdentifierFuzzer getIdFuzzer() {
        if (this.idFuzzer == null) {
            this.idFuzzer = new IdentifierFuzzer(this.context);
        }
        return this.idFuzzer;
    }

    @Override
    protected String getConfigName() {
        return "function";
    }

    private class ParamListFuzzer
    extends AbstractFuzzer {
        ParamListFuzzer(FuzzingContext context) {
            super(context);
        }

        @Override
        protected boolean isEnough(int budget) {
            return budget >= 1;
        }

        @Override
        protected Node generate(int budget, Set<Type> types) {
            Node node = new Node(83);
            int i = 0;
            while (i < budget - 1) {
                node.addChildToBack(FunctionFuzzer.this.getIdFuzzer().generate(1));
                ++i;
            }
            return node;
        }

        @Override
        protected String getConfigName() {
            return null;
        }
    }
}

