/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.BlockFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.IdentifierFuzzer;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Type;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class TryFuzzer
extends AbstractFuzzer {
    TryFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 3;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        AbstractFuzzer[] fuzzers = new AbstractFuzzer[]{new BlockFuzzer(this.context), new CatchFuzzer(this.context), new FinallyFuzzer(this.context)};
        Node[] components = this.distribute(budget - 1, fuzzers);
        if (components[2] == null) {
            if (!components[1].hasChildren()) {
                components[2] = new Node(125);
            } else {
                components = Arrays.copyOf(components, 2);
            }
        }
        return new Node(77, components);
    }

    @Override
    protected String getConfigName() {
        return "try";
    }

    private class CatchFuzzer
    extends AbstractFuzzer {
        CatchFuzzer(FuzzingContext context) {
            super(context);
        }

        @Override
        protected boolean isEnough(int budget) {
            return budget >= 3;
        }

        @Override
        protected Node generate(int budget, Set<Type> types) {
            Node catchBlock = new Node(125);
            if (this.isEnough(budget)) {
                Node param = new IdentifierFuzzer(this.context).generate(1);
                catchBlock.addChildToBack(new Node(120, param, new BlockFuzzer(this.context).generate(budget - 1)));
                this.context.scopeManager.removeSymbol(param.getQualifiedName());
            }
            return catchBlock;
        }

        @Override
        protected String getConfigName() {
            return null;
        }
    }

    private class FinallyFuzzer
    extends BlockFuzzer {
        FinallyFuzzer(FuzzingContext context) {
            super(context);
        }

        @Override
        protected Node generate(int budget) {
            if (this.isEnough(budget)) {
                return super.generate(budget);
            }
            return null;
        }
    }
}

