/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagAttr;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class JsonML {
    private final TagType type;
    private Map<TagAttr, Object> attributes = new EnumMap<TagAttr, Object>(TagAttr.class);
    private List<JsonML> children = new ArrayList<JsonML>();

    public JsonML(TagType type) {
        this.type = type;
    }

    public JsonML(TagType type, JsonML ... children) {
        this(type, Arrays.asList(children));
    }

    public JsonML(TagType type, List<? extends JsonML> children) {
        this(type, Collections.emptyMap(), children);
    }

    public JsonML(TagType type, Map<? extends TagAttr, ?> attributes) {
        this(type, attributes, Collections.emptyList());
    }

    public JsonML(TagType type, Map<? extends TagAttr, ?> attributes, List<? extends JsonML> children) {
        this.type = type;
        this.attributes.putAll(attributes);
        this.appendChildren(children);
    }

    public void addChild(int index, JsonML element) {
        this.children.add(index, element);
    }

    public void appendChild(JsonML element) {
        this.children.add(element);
    }

    public void appendChildren(Collection<? extends JsonML> elements) {
        this.children.addAll(elements);
    }

    public int childrenSize() {
        return this.children.size();
    }

    public void clearChildren() {
        this.setChildren(new JsonML[0]);
    }

    public Object getAttribute(TagAttr name) {
        return this.attributes.get((Object)name);
    }

    public Map<TagAttr, Object> getAttributes() {
        return this.attributes;
    }

    public JsonML getChild(int index) {
        return this.children.get(index);
    }

    public List<JsonML> getChildren() {
        return this.children;
    }

    public List<JsonML> getChildren(int fromIndex, int toIndex) {
        return this.children.subList(fromIndex, toIndex);
    }

    public TagType getType() {
        return this.type;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setAttribute(TagAttr name, Object value) {
        this.attributes.put(name, value);
    }

    public void setAttributes(Map<TagAttr, Object> attributes) {
        this.attributes = attributes;
    }

    public void setChild(int index, JsonML element) {
        this.children.set(index, element);
    }

    public void setChildren(JsonML ... children) {
        this.children.clear();
        this.children.addAll(Arrays.asList(children));
    }

    public void setChildren(List<JsonML> children) {
        this.children = children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, true, true);
        return sb.toString();
    }

    private void toString(StringBuilder sb, boolean printAttributes, boolean printChildren) {
        sb.append("[\"");
        JsonML.escapeStringOnto(this.type.name(), sb);
        sb.append('\"');
        if (printAttributes) {
            sb.append(", {");
            boolean first = true;
            for (Map.Entry<TagAttr, Object> entry : this.attributes.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\"');
                JsonML.escapeStringOnto(entry.getKey().toString(), sb);
                sb.append("\": ");
                Object value = entry.getValue();
                if (value == null) {
                    sb.append("null");
                    continue;
                }
                if (value instanceof String) {
                    sb.append('\"');
                    JsonML.escapeStringOnto((String)value, sb);
                    sb.append('\"');
                    continue;
                }
                sb.append(value);
            }
            sb.append("}");
        }
        if (printChildren) {
            for (JsonML child : this.children) {
                sb.append(", ");
                sb.append(child.toString());
            }
        }
        sb.append(']');
    }

    private static void escapeStringOnto(String s, StringBuilder sb) {
        int pos = 0;
        int n = s.length();
        int i = 0;
        while (i < n) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': 
                case '\u2028': 
                case '\u2029': {
                    String hex = Integer.toString(ch, 16);
                    sb.append(s, pos, i).append("\\u").append("0000", hex.length(), 4).append(hex);
                    pos = i + 1;
                }
            }
            ++i;
        }
        sb.append(s, pos, n);
    }

    public String toStringTree() {
        try {
            StringBuilder s = new StringBuilder();
            JsonML.toStringTreeHelper(this, 0, s);
            return s.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen\n" + e);
        }
    }

    private static void toStringTreeHelper(JsonML element, int level, StringBuilder sb) throws IOException {
        int i = 0;
        while (i < level) {
            sb.append("    ");
            ++i;
        }
        element.toString(sb, true, false);
        sb.append("\n");
        for (JsonML child : element.getChildren()) {
            JsonML.toStringTreeHelper(child, level + 1, sb);
        }
    }
}

