/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.AstValidator;
import com.google.gwt.thirdparty.javascript.jscomp.SourceAst;
import com.google.gwt.thirdparty.javascript.jscomp.SourceFile;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonML;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonMLException;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.Reader;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagAttr;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.Writer;
import com.google.gwt.thirdparty.javascript.rhino.InputId;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.ArrayDeque;

public class JsonMLAst
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SOURCE_NAME = "[[jsonmlsource]]";
    private JsonML jsonml;
    private Node root;
    private final SourceFile sourceFile;
    private final InputId inputId;

    public JsonMLAst(JsonML jsonml) {
        this.jsonml = jsonml;
        this.inputId = new InputId(this.getSourceName());
        this.sourceFile = new SourceFile(this.getSourceName());
    }

    @Override
    public void clearAst() {
        this.root = null;
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        if (this.root == null) {
            this.createAst(compiler);
        }
        return this.root;
    }

    @Override
    public SourceFile getSourceFile() {
        return null;
    }

    @Override
    public void setSourceFile(SourceFile file) {
        throw new UnsupportedOperationException("JsonMLAst cannot be associated with a SourceFile instance.");
    }

    public String getSourceName() {
        Object obj = this.jsonml.getAttribute(TagAttr.SOURCE);
        if (obj instanceof String) {
            return (String)obj;
        }
        return DEFAULT_SOURCE_NAME;
    }

    private void createAst(AbstractCompiler compiler) {
        Reader translator = new Reader();
        translator.setRootElement(this.jsonml);
        try {
            this.root = translator.parse(compiler);
            this.root.setInputId(this.inputId);
            this.root.setStaticSourceFile(this.sourceFile);
            new AstValidator().validateScript(this.root);
        }
        catch (JsonMLException jsonMLException) {
            // empty catch block
        }
    }

    public JsonML convertToJsonML() {
        if (this.root != null) {
            Writer converter = new Writer();
            return converter.processAst(this.root);
        }
        return null;
    }

    public JsonML getElementPreOrder(int n) {
        Preconditions.checkState((this.jsonml != null ? 1 : 0) != 0);
        if (n == 0) {
            return this.jsonml;
        }
        ArrayDeque<WalkHelper> stack = new ArrayDeque<WalkHelper>();
        stack.push(new WalkHelper(this.jsonml, 0));
        int i = 0;
        while (i <= n && !stack.isEmpty()) {
            WalkHelper current = (WalkHelper)stack.pop();
            JsonML element = current.element;
            Integer childno = current.childno;
            if (childno >= element.childrenSize()) continue;
            stack.push(new WalkHelper(element, childno + 1));
            element = element.getChild(childno);
            if (++i == n) {
                return element;
            }
            stack.push(new WalkHelper(element, 0));
        }
        return null;
    }

    @Override
    public InputId getInputId() {
        return this.inputId;
    }

    private static class WalkHelper {
        final JsonML element;
        final int childno;

        WalkHelper(JsonML element, int childno) {
            this.element = element;
            this.childno = childno;
        }
    }
}

