/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.javascript.jscomp.CheckLevel;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.ErrorLevel;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonML;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonMLAst;

public class JsonMLError {
    public final String description;
    public final String sourceName;
    public final JsonML element;
    public final int lineNumber;
    public final ErrorLevel level;

    private JsonMLError(DiagnosticType type, String sourceName, JsonML element, int lineNumber, ErrorLevel level, String ... arguments) {
        this.description = type.format.format(arguments);
        this.sourceName = sourceName;
        this.element = element;
        this.lineNumber = lineNumber;
        this.level = level;
    }

    private JsonMLError(String description, DiagnosticType type, String sourceName, JsonML element, int lineNumber, ErrorLevel level) {
        this.description = description;
        this.sourceName = sourceName;
        this.element = element;
        this.lineNumber = lineNumber;
        this.level = level;
    }

    public static JsonMLError make(DiagnosticType type, String sourceName, JsonML element, int lineNumber, ErrorLevel level, String ... arguments) {
        return new JsonMLError(type, sourceName, element, lineNumber, level, arguments);
    }

    public static JsonMLError make(JSError error, JsonMLAst ast) {
        int n = error.lineNumber;
        JsonML element = ast.getElementPreOrder(n);
        ErrorLevel level = error.getDefaultLevel() == CheckLevel.ERROR ? ErrorLevel.COMPILATION_ERROR : ErrorLevel.COMPILATION_WARNING;
        return new JsonMLError(error.getType(), error.sourceName, element, 0, level, error.description);
    }
}

