/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonML;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagAttr;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagType;
import java.util.Iterator;
import java.util.ListIterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonMLUtil {
    public static boolean isExpression(JsonML element) {
        switch (element.getType()) {
            case ArrayExpr: 
            case AssignExpr: 
            case BinaryExpr: 
            case CallExpr: 
            case ConditionalExpr: 
            case CountExpr: 
            case DeleteExpr: 
            case EvalExpr: 
            case FunctionExpr: 
            case IdExpr: 
            case InvokeExpr: 
            case LiteralExpr: 
            case LogicalAndExpr: 
            case LogicalOrExpr: 
            case MemberExpr: 
            case NewExpr: 
            case ObjectExpr: 
            case RegExpExpr: 
            case ThisExpr: 
            case TypeofExpr: 
            case UnaryExpr: {
                return true;
            }
        }
        return false;
    }

    public static JsonML parseString(String jsonml) throws Exception {
        return JsonMLUtil.parseElement(new JSONArray(jsonml));
    }

    private static JsonML parseElement(JSONArray element) throws Exception {
        JsonML jsonMLElement = new JsonML(TagType.valueOf(element.getString(0)));
        JSONObject attrs = element.getJSONObject(1);
        Iterator it = attrs.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = attrs.get(key);
            TagAttr tag = TagAttr.get(key);
            if (tag == null) continue;
            if (value instanceof Number) {
                value = ((Number)value).doubleValue();
            }
            switch (tag) {
                case BODY: 
                case FLAGS: 
                case IS_PREFIX: 
                case LABEL: 
                case NAME: 
                case OP: 
                case TYPE: {
                    jsonMLElement.setAttribute(tag, value);
                    break;
                }
                case VALUE: {
                    if (value != null && value.equals(null)) {
                        value = null;
                    }
                    if (value instanceof Number) {
                        jsonMLElement.setAttribute(tag, ((Number)value).doubleValue());
                        break;
                    }
                    jsonMLElement.setAttribute(tag, value);
                }
            }
        }
        int i = 2;
        while (i < element.length()) {
            jsonMLElement.appendChild(JsonMLUtil.parseElement(element.getJSONArray(i)));
            ++i;
        }
        return jsonMLElement;
    }

    public static String compare(JsonML tree1, JsonML tree2) {
        return new JsonMLComparator(tree1, tree2).compare();
    }

    static boolean compareSilent(JsonML tree1, JsonML tree2) {
        return new JsonMLComparator(tree1, tree2).compareSilent();
    }

    private static class JsonMLComparator {
        private static final TagAttr[] ATTRS_TO_COMPARE = new TagAttr[]{TagAttr.BODY, TagAttr.FLAGS, TagAttr.IS_PREFIX, TagAttr.LABEL, TagAttr.NAME, TagAttr.OP, TagAttr.TYPE, TagAttr.VALUE};
        private JsonML treeA;
        private JsonML treeB;
        private JsonML mismatchA;
        private JsonML mismatchB;

        JsonMLComparator(JsonML treeA, JsonML treeB) {
            this.treeA = treeA;
            this.treeB = treeB;
            if (this.compareElements(treeA, treeB)) {
                this.mismatchA = null;
                this.mismatchB = null;
            }
        }

        private boolean setMismatch(JsonML a, JsonML b) {
            this.mismatchA = a;
            this.mismatchB = b;
            return false;
        }

        private boolean compareElements(JsonML a, JsonML b) {
            if (a == null || b == null) {
                if (a == null && b == null) {
                    return true;
                }
                return this.setMismatch(a, b);
            }
            if (!this.areEquivalent(a, b)) {
                return this.setMismatch(a, b);
            }
            if (a.childrenSize() != b.childrenSize()) {
                return this.setMismatch(a, b);
            }
            ListIterator<JsonML> itA = a.getChildren().listIterator();
            ListIterator<JsonML> itB = b.getChildren().listIterator();
            while (itA.hasNext()) {
                if (this.compareElements((JsonML)itA.next(), (JsonML)itB.next())) continue;
                return false;
            }
            return true;
        }

        private boolean areEquivalent(JsonML a, JsonML b) {
            if (a.getType() != b.getType()) {
                return false;
            }
            TagAttr[] tagAttrArray = ATTRS_TO_COMPARE;
            int n = ATTRS_TO_COMPARE.length;
            int n2 = 0;
            while (n2 < n) {
                TagAttr attr = tagAttrArray[n2];
                if (!this.compareAttribute(attr, a, b)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private boolean compareAttribute(TagAttr attr, JsonML a, JsonML b) {
            Object valueA = a.getAttributes().get((Object)attr);
            Object valueB = b.getAttributes().get((Object)attr);
            if (valueA == null && valueB == null) {
                return true;
            }
            if (valueA == null || valueB == null) {
                return false;
            }
            if (!valueA.equals(valueB)) {
                Double doubleA = null;
                Double doubleB = null;
                if (valueA instanceof Number) {
                    doubleA = ((Number)valueA).doubleValue();
                } else if (valueA instanceof String) {
                    doubleA = Double.valueOf((String)valueA);
                } else {
                    return false;
                }
                if (valueB instanceof Number) {
                    doubleB = ((Number)valueB).doubleValue();
                } else if (valueB instanceof String) {
                    doubleB = Double.valueOf((String)valueB);
                } else {
                    return false;
                }
                if (!doubleA.equals(doubleB)) {
                    return false;
                }
            }
            return true;
        }

        private boolean compareSilent() {
            return this.mismatchA == null && this.mismatchB == null;
        }

        private String compare() {
            if (this.compareSilent()) {
                return null;
            }
            return "The trees are not equal: \n\nTree1:\n " + this.treeA.toStringTree() + "\n\nTree2:\n " + this.treeB.toStringTree() + "\n\nSubtree1:\n " + this.mismatchA.toStringTree() + "\n\nSubtree2:\n " + this.mismatchB.toStringTree();
        }
    }
}

