/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.jsonml;

import com.google.gwt.thirdparty.javascript.jscomp.jsonml.JsonML;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagAttr;
import com.google.gwt.thirdparty.javascript.jscomp.jsonml.TagType;
import java.util.Arrays;

public class Validator {
    public static final String MISSING_ARGUMENT = "No %s attribute specified for %s.";
    public static final String NOT_ENOUGH_CHILDREN_FMT = "Not enough children for %s. Expected: %d. Found: %d.";
    public static final String TOO_MANY_CHILDREN_FMT = "Too many children for %s. Expected: %d. Found: %d.";
    public static final String WRONG_CHILD_TYPE_FMT = "Wrong type of child number %d for %s. Expected: %s. Found: %s.";
    public static TagType[] exprTypes = new TagType[]{TagType.ArrayExpr, TagType.AssignExpr, TagType.BinaryExpr, TagType.CallExpr, TagType.ConditionalExpr, TagType.CountExpr, TagType.DeleteExpr, TagType.EvalExpr, TagType.IdExpr, TagType.InvokeExpr, TagType.LiteralExpr, TagType.LogicalAndExpr, TagType.LogicalOrExpr, TagType.MemberExpr, TagType.NewExpr, TagType.ObjectExpr, TagType.RegExpExpr, TagType.ThisExpr, TagType.TypeofExpr, TagType.UnaryExpr, TagType.FunctionExpr};
    private final StringBuilder b = new StringBuilder();
    private boolean error = false;

    private Validator() {
    }

    public static String validate(JsonML element) {
        return new Validator().doValidate(element);
    }

    private String doValidate(JsonML element) {
        switch (element.getType()) {
            case AssignExpr: {
                this.validateAssignExpr(element);
                break;
            }
            case BinaryExpr: {
                this.validateBinaryExpr(element);
                break;
            }
            case BreakStmt: 
            case ContinueStmt: {
                this.validateJmpStmt(element);
                break;
            }
            case Case: {
                this.validateCase(element);
                break;
            }
            case CatchClause: {
                this.validateCatchClause(element);
                break;
            }
            case ConditionalExpr: {
                this.validateConditionalExpr(element);
                break;
            }
            case CountExpr: {
                this.validateCountExpr(element);
                break;
            }
            case DataProp: {
                this.validateProp(element);
                break;
            }
            case GetterProp: {
                this.validateProp(element);
                break;
            }
            case SetterProp: {
                this.validateProp(element);
                break;
            }
            case DeleteExpr: {
                this.validateDeleteExpr(element);
                break;
            }
            case DoWhileStmt: {
                this.validateDoWhileStmt(element);
                break;
            }
            case EmptyStmt: {
                this.validateEmptyStmt(element);
                break;
            }
            case ForInStmt: {
                this.validateForInStmt(element);
                break;
            }
            case ForStmt: {
                this.validateForStmt(element);
                break;
            }
            case FunctionDecl: {
                this.validateFunctionDecl(element);
                break;
            }
            case FunctionExpr: {
                this.validateFunctionExpr(element);
                break;
            }
            case IdExpr: {
                this.validateIdExpr(element);
                break;
            }
            case IdPatt: {
                this.validateIdPatt(element);
                break;
            }
            case IfStmt: {
                this.validateIfStmt(element);
                break;
            }
            case InvokeExpr: {
                this.validateInvokeExpr(element);
                break;
            }
            case LabelledStmt: {
                this.validateLabelledStmt(element);
                break;
            }
            case LiteralExpr: {
                this.validateLiteralExpr(element);
                break;
            }
            case LogicalAndExpr: 
            case LogicalOrExpr: {
                this.validateLogicalExpr(element);
                break;
            }
            case MemberExpr: {
                this.validateMemberExpr(element);
                break;
            }
            case NewExpr: {
                this.validateNewExpr(element);
                break;
            }
            case ObjectExpr: {
                this.validateObjectExpr(element);
                break;
            }
            case ParamDecl: {
                this.validateParamDecl(element);
                break;
            }
            case RegExpExpr: {
                this.validateRegExpExpr(element);
                break;
            }
            case ReturnStmt: {
                this.validateReturnStmt(element);
                break;
            }
            case SwitchStmt: {
                this.validateSwitchStmt(element);
                break;
            }
            case ThisExpr: {
                this.validateThisExpr(element);
                break;
            }
            case ThrowStmt: {
                this.validateThrowStmt(element);
                break;
            }
            case TryStmt: {
                this.validateTryStmt(element);
                break;
            }
            case TypeofExpr: {
                this.validateTypeofExpr(element);
                break;
            }
            case UnaryExpr: {
                this.validateUnaryExpr(element);
                break;
            }
            case VarDecl: {
                this.validateVarDecl(element);
                break;
            }
            case WhileStmt: {
                this.validateWhileStmt(element);
                break;
            }
            case WithStmt: {
                this.validateWithStmt(element);
            }
        }
        return this.b.length() != 0 ? this.b.toString() : null;
    }

    private void validateAssignExpr(JsonML element) {
        this.validateChildrenSize(element, 2);
        this.validateArgument(element, TagAttr.OP);
    }

    private void validateBinaryExpr(JsonML element) {
        this.validateChildrenSize(element, 2);
        this.validateArgument(element, TagAttr.OP);
    }

    private void validateCase(JsonML element) {
        this.validateMinChildrenSize(element, 1);
        if (!this.error) {
            this.validateIsChildExpression(element, 0);
        }
    }

    private void validateCatchClause(JsonML element) {
        this.validateChildrenSize(element, 2);
        if (!this.error) {
            this.validateChildType(element, TagType.IdPatt, 0);
            this.validateChildType(element, TagType.BlockStmt, 1);
        }
    }

    private void validateConditionalExpr(JsonML element) {
        this.validateChildrenSize(element, 3);
    }

    private void validateCountExpr(JsonML element) {
        this.validateChildrenSize(element, 1);
        this.validateArgument(element, TagAttr.IS_PREFIX);
        this.validateArgument(element, TagAttr.OP);
    }

    private void validateProp(JsonML element) {
        this.validateChildrenSize(element, 1);
        if (!this.error) {
            this.validateArgument(element, TagAttr.NAME);
        }
    }

    private void validateDeleteExpr(JsonML element) {
        this.validateChildrenSize(element, 1);
    }

    private void validateDoWhileStmt(JsonML element) {
        this.validateChildrenSize(element, 2);
    }

    private void validateEmptyStmt(JsonML element) {
        this.validateChildrenSize(element, 0);
    }

    private void validateForInStmt(JsonML element) {
        this.validateChildrenSize(element, 3);
    }

    private void validateForStmt(JsonML element) {
        this.validateChildrenSize(element, 4);
    }

    private void validateFunctionDecl(JsonML element) {
        this.validateFunction(element, true);
    }

    private void validateFunctionExpr(JsonML element) {
        this.validateFunction(element, false);
    }

    private void validateIdExpr(JsonML element) {
        this.validateChildrenSize(element, 0);
        if (!this.error) {
            this.validateArgument(element, TagAttr.NAME);
        }
    }

    private void validateIdPatt(JsonML element) {
        this.validateChildrenSize(element, 0);
        this.validateArgument(element, TagAttr.NAME);
    }

    private void validateIfStmt(JsonML element) {
        this.validateChildrenSize(element, 3);
    }

    private void validateInvokeExpr(JsonML element) {
        this.validateMinChildrenSize(element, 2);
        this.validateArgument(element, TagAttr.OP);
    }

    private void validateJmpStmt(JsonML element) {
        this.validateChildrenSize(element, 0);
    }

    private void validateLabelledStmt(JsonML element) {
        this.validateChildrenSize(element, 1);
        this.validateArgument(element, TagAttr.LABEL);
    }

    private void validateLiteralExpr(JsonML element) {
        this.validateChildrenSize(element, 0);
        this.validateArgument(element, TagAttr.TYPE);
        this.validateArgument(element, TagAttr.VALUE);
    }

    private void validateLogicalExpr(JsonML element) {
        this.validateChildrenSize(element, 2);
    }

    private void validateMemberExpr(JsonML element) {
        this.validateChildrenSize(element, 2);
        this.validateArgument(element, TagAttr.OP);
    }

    private void validateNewExpr(JsonML element) {
        this.validateMinChildrenSize(element, 1);
    }

    private void validateObjectExpr(JsonML element) {
        TagType[] expected = new TagType[]{TagType.DataProp, TagType.GetterProp, TagType.SetterProp};
        int i = 0;
        while (i < element.childrenSize()) {
            this.validateChildType(element, expected, i);
            ++i;
        }
    }

    private void validateParamDecl(JsonML element) {
        int i = 0;
        while (i < element.childrenSize()) {
            this.validateChildType(element, TagType.IdPatt, i);
            ++i;
        }
    }

    private void validateRegExpExpr(JsonML element) {
        this.validateChildrenSize(element, 0);
        this.validateArgument(element, TagAttr.BODY);
        this.validateArgument(element, TagAttr.FLAGS);
    }

    private void validateReturnStmt(JsonML element) {
        this.validateMaxChildrenSize(element, 1);
    }

    private void validateSwitchStmt(JsonML element) {
        this.validateMinChildrenSize(element, 1);
        boolean defaultStmt = false;
        int i = 1;
        while (i < element.childrenSize()) {
            if (!defaultStmt) {
                this.validateChildType(element, new TagType[]{TagType.Case, TagType.DefaultCase}, i);
            } else {
                this.validateChildType(element, TagType.Case, i);
            }
            if (this.error) break;
            if (element.getChild(i).getType() == TagType.DefaultCase) {
                defaultStmt = true;
            }
            ++i;
        }
    }

    private void validateThisExpr(JsonML element) {
        this.validateChildrenSize(element, 0);
    }

    private void validateThrowStmt(JsonML element) {
        this.validateChildrenSize(element, 1);
    }

    private void validateTryStmt(JsonML element) {
        this.validateChildrenSize(element, 2, 3);
        if (this.error) {
            return;
        }
        this.validateChildType(element, TagType.BlockStmt, 0);
        TagType[] types = new TagType[]{TagType.CatchClause, TagType.Empty};
        this.validateChildType(element, types, 1);
        if (element.childrenSize() > 2) {
            this.validateChildType(element, TagType.BlockStmt, 2);
        }
    }

    private void validateFunction(JsonML element, boolean needsName) {
        this.validateMinChildrenSize(element, 2);
        if (this.error) {
            return;
        }
        if (needsName) {
            this.validateChildType(element, new TagType[]{TagType.IdPatt}, 0);
        } else {
            this.validateChildType(element, new TagType[]{TagType.IdPatt, TagType.Empty}, 0);
        }
        this.validateChildType(element, TagType.ParamDecl, 1);
    }

    private void validateTypeofExpr(JsonML element) {
        this.validateChildrenSize(element, 1);
    }

    private void validateUnaryExpr(JsonML element) {
        this.validateChildrenSize(element, 1);
        if (!this.error) {
            this.validateArgument(element, TagAttr.OP);
        }
    }

    private void validateVarDecl(JsonML element) {
        this.validateMinChildrenSize(element, 1);
        TagType[] types = new TagType[]{TagType.InitPatt, TagType.IdPatt};
        int i = 0;
        while (i < element.childrenSize()) {
            this.validateChildType(element, types, i);
            ++i;
        }
    }

    private void validateWhileStmt(JsonML element) {
        this.validateChildrenSize(element, 2);
    }

    private void validateWithStmt(JsonML element) {
        this.validateChildrenSize(element, 2);
    }

    private void validateArgument(JsonML element, TagAttr attr) {
        Object value = element.getAttribute(attr);
        if (value == null) {
            String type = (String)element.getAttribute(TagAttr.TYPE);
            if (type != null && type.equals("null")) {
                return;
            }
            this.error = true;
            this.appendLine(String.format(MISSING_ARGUMENT, new Object[]{attr, element.getType()}));
        }
    }

    private void validateChildrenSize(JsonML element, int expected) {
        this.validateChildrenSize(element, expected, expected);
    }

    private void validateChildrenSize(JsonML element, int min, int max) {
        this.validateMinChildrenSize(element, min);
        if (!this.error) {
            this.validateMaxChildrenSize(element, max);
        }
    }

    private void validateMinChildrenSize(JsonML element, int min) {
        int size = element.childrenSize();
        if (size < min) {
            this.appendLine(String.format(NOT_ENOUGH_CHILDREN_FMT, new Object[]{element.getType(), min, size}));
            this.error = true;
        }
    }

    private void validateMaxChildrenSize(JsonML element, int max) {
        int size = element.childrenSize();
        if (size > max) {
            this.appendLine(String.format(TOO_MANY_CHILDREN_FMT, element.getType().toString(), max, size));
            this.error = true;
        }
    }

    private void validateIsChildExpression(JsonML element, int index) {
        this.validateChildType(element, exprTypes, index);
    }

    private void validateChildType(JsonML element, TagType expected, int index) {
        TagType[] types = new TagType[]{expected};
        this.validateChildType(element, types, index);
    }

    private void validateChildType(JsonML element, TagType[] expected, int index) {
        TagType type = element.getChild(index).getType();
        if (!Arrays.asList(expected).contains((Object)type)) {
            this.appendLine(String.format(WRONG_CHILD_TYPE_FMT, new Object[]{index, element.getType(), Validator.printList((Object[])expected), type}));
            this.error = true;
        }
    }

    private void appendLine(String line) {
        this.b.append(String.format("%s", line));
    }

    public static String printList(Object[] list) {
        StringBuilder builder = new StringBuilder("");
        if (list.length == 1) {
            builder.append(list[0].toString());
        } else if (list.length > 1) {
            builder.append('[');
            int i = 0;
            while (i < list.length) {
                builder.append(list[i].toString());
                if (i < list.length - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

