/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.NominalType;
import java.util.List;

public class DeclaredFunctionType {
    private final List<JSType> requiredFormals;
    private final List<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final NominalType klass;
    private final NominalType receiverType;

    private DeclaredFunctionType(List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType klass, NominalType receiverType) {
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.klass = klass;
        this.receiverType = receiverType;
    }

    public FunctionType toFunctionType() {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType formal : this.requiredFormals) {
            builder.addReqFormal(formal == null ? JSType.UNKNOWN : formal);
        }
        for (JSType formal : this.optionalFormals) {
            builder.addOptFormal(formal == null ? JSType.UNKNOWN : formal);
        }
        builder.addRestFormals(this.restFormals == null ? null : this.restFormals);
        builder.addRetType(this.returnType == null ? JSType.UNKNOWN : this.returnType);
        builder.addClass(this.klass);
        return builder.buildFunction();
    }

    static DeclaredFunctionType make(List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType klass, NominalType receiverType) {
        if (requiredFormals == null) {
            requiredFormals = Lists.newArrayList();
        }
        if (optionalFormals == null) {
            optionalFormals = Lists.newArrayList();
        }
        return new DeclaredFunctionType(requiredFormals, optionalFormals, restFormals, retType, klass, receiverType);
    }

    public JSType getFormalType(int argpos) {
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            return this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            return this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public int getRequiredArity() {
        return this.requiredFormals.size();
    }

    public int getOptionalArity() {
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public boolean hasRestFormals() {
        return this.restFormals != null;
    }

    public JSType getReturnType() {
        return this.returnType;
    }

    public NominalType getThisType() {
        if (this.klass != null) {
            return this.klass;
        }
        return this.receiverType;
    }

    public NominalType getClassType() {
        return this.klass;
    }

    public NominalType getReceiverType() {
        return this.receiverType;
    }

    public DeclaredFunctionType withTypeInfoFromSuper(DeclaredFunctionType superType) {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int i = 0;
        for (JSType formal : this.requiredFormals) {
            builder.addReqFormal(formal != null ? formal : superType.getFormalType(i));
            ++i;
        }
        for (JSType formal : this.optionalFormals) {
            builder.addOptFormal(formal != null ? formal : superType.getFormalType(i));
            ++i;
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals);
        } else if (superType.hasRestFormals()) {
            builder.addRestFormals(superType.restFormals);
        }
        builder.addRetType(this.returnType != null ? this.returnType : superType.returnType);
        builder.addClass(this.klass);
        builder.addReceiverType(this.receiverType);
        return builder.buildDeclaration();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("Required formals", this.requiredFormals).add("Optional formals", this.optionalFormals).add("Varargs formals", (Object)this.restFormals).add("Return", (Object)this.returnType).add("Class", (Object)this.klass).toString();
    }
}

