/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.NominalType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.ObjectType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FunctionType {
    private final ImmutableList<JSType> requiredFormals;
    private final ImmutableList<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final boolean isLoose;
    private final ImmutableMap<String, JSType> outerVarPreconditions;
    private final NominalType klass;
    static final FunctionType BOTTOM_FUNCTION = FunctionType.normalized(null, null, JSType.TOP, JSType.BOTTOM, null, null, false);
    public static final FunctionType TOP_FUNCTION = new FunctionType(null, null, null, null, null, null, false);
    public static final FunctionType LOOSE_TOP_FUNCTION = new FunctionType(null, null, null, null, null, null, true);

    private FunctionType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType klass, ImmutableMap<String, JSType> outerVars, boolean isLoose) {
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.klass = klass;
        this.outerVarPreconditions = outerVars;
        this.isLoose = isLoose;
    }

    public void checkValid() {
        if (this.isTopFunction()) {
            return;
        }
        for (JSType formal : this.requiredFormals) {
            Preconditions.checkState((formal != null ? 1 : 0) != 0);
        }
        for (JSType formal : this.optionalFormals) {
            Preconditions.checkState((formal != null ? 1 : 0) != 0);
        }
        Preconditions.checkState((this.returnType != null ? 1 : 0) != 0);
    }

    public boolean isLoose() {
        return this.isLoose;
    }

    FunctionType withLoose() {
        if (this.isTopFunction()) {
            return LOOSE_TOP_FUNCTION;
        }
        return new FunctionType(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.klass, this.outerVarPreconditions, true);
    }

    static FunctionType normalized(List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType klass, Map<String, JSType> outerVars, boolean isLoose) {
        if (requiredFormals == null) {
            requiredFormals = ImmutableList.of();
        }
        if (optionalFormals == null) {
            optionalFormals = ImmutableList.of();
        }
        if (outerVars == null) {
            outerVars = ImmutableMap.of();
        }
        if (restFormals != null) {
            int i = optionalFormals.size() - 1;
            while (i >= 0) {
                if (!restFormals.equals(optionalFormals.get(i))) break;
                optionalFormals.remove(i);
                --i;
            }
        }
        return new FunctionType((ImmutableList<JSType>)ImmutableList.copyOf((Collection)requiredFormals), (ImmutableList<JSType>)ImmutableList.copyOf((Collection)optionalFormals), restFormals, retType, klass, (ImmutableMap<String, JSType>)ImmutableMap.copyOf((Map)outerVars), isLoose);
    }

    @VisibleForTesting
    static JSType makeJSType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType) {
        return JSType.fromFunctionType(FunctionType.normalized(requiredFormals, optionalFormals, restFormals, retType, null, null, false));
    }

    public boolean isTopFunction() {
        if (this.requiredFormals == null) {
            Preconditions.checkState((this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION ? 1 : 0) != 0);
        }
        return this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION;
    }

    public boolean isBottomFunction() {
        return this.equals(BOTTOM_FUNCTION);
    }

    public boolean isConstructor() {
        return this.klass != null;
    }

    public JSType getFormalType(int argpos) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        this.checkValid();
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            Preconditions.checkState((this.requiredFormals.get(argpos) != null ? 1 : 0) != 0);
            return (JSType)this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            Preconditions.checkState((this.optionalFormals.get(argpos - numReqFormals) != null ? 1 : 0) != 0);
            return (JSType)this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public JSType getReturnType() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.isConstructor()) {
            return JSType.fromObjectType(ObjectType.fromClass(this.klass));
        }
        return this.returnType;
    }

    public JSType getOuterVarPrecondition(String name) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return (JSType)this.outerVarPreconditions.get((Object)name);
    }

    public int getMinArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return this.requiredFormals.size();
    }

    public int getMaxArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.restFormals != null) {
            return Integer.MAX_VALUE;
        }
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public JSType getTypeOfThis() {
        Preconditions.checkNotNull((Object)this.klass);
        return JSType.fromObjectType(ObjectType.fromClass(this.klass));
    }

    public JSType createConstructorObject() {
        Preconditions.checkState((this.klass != null ? 1 : 0) != 0);
        return this.klass.createConstructorObject(this);
    }

    private static JSType nullAcceptingJoin(JSType t1, JSType t2) {
        Preconditions.checkArgument((t1 != null || t2 != null ? 1 : 0) != 0);
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.join(t1, t2);
    }

    private static JSType nullAcceptingMeet(JSType t1, JSType t2) {
        Preconditions.checkArgument((t1 != null || t2 != null ? 1 : 0) != 0);
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.meet(t1, t2);
    }

    private static FunctionType looseJoin(FunctionType f1, FunctionType f2) {
        Preconditions.checkArgument((f1.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.getMinArity(), f2.getMinArity());
        int i = 0;
        while (i < minRequiredArity) {
            builder.addReqFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
            ++i;
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        int i2 = minRequiredArity;
        while (i2 < maxTotalArity) {
            builder.addOptFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i2), f2.getFormalType(i2)));
            ++i2;
        }
        return builder.addRetType(FunctionType.nullAcceptingJoin(f1.returnType, f2.returnType)).addLoose().buildFunction();
    }

    public boolean isSubtypeOf(FunctionType other) {
        if (other.isTopFunction()) {
            return true;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int i = 0;
        while (i < other.requiredFormals.size()) {
            JSType formalType = other.getFormalType(i);
            builder.addReqFormal(formalType.isUnknown() ? JSType.BOTTOM : formalType);
            ++i;
        }
        int j = 0;
        while (j < other.optionalFormals.size()) {
            JSType formalType = other.getFormalType(i + j);
            builder.addOptFormal(formalType.isUnknown() ? JSType.BOTTOM : formalType);
            ++j;
        }
        if (other.restFormals != null) {
            JSType formalType = other.restFormals;
            builder.addOptFormal(formalType.isUnknown() ? JSType.BOTTOM : formalType);
        }
        if (this.returnType.isUnknown()) {
            builder.addRetType(JSType.UNKNOWN);
        } else {
            builder.addRetType(other.returnType);
        }
        if (other.isLoose()) {
            builder.addLoose();
        }
        builder.addClass(other.klass);
        FunctionType newOther = builder.buildFunction();
        return newOther.equals(FunctionType.join(this, newOther));
    }

    static FunctionType join(FunctionType f1, FunctionType f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null || f2.isBottomFunction() || f1.equals(f2)) {
            return f1;
        }
        if (f1.isBottomFunction()) {
            return f2;
        }
        if (f1.isTopFunction() || f2.isTopFunction()) {
            return TOP_FUNCTION;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int maxRequiredArity = Math.max(f1.requiredFormals.size(), f2.requiredFormals.size());
        int i = 0;
        while (i < maxRequiredArity) {
            JSType reqFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            builder.addReqFormal(reqFormal);
            ++i;
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        int i2 = maxRequiredArity;
        while (i2 < maxTotalArity) {
            JSType optFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i2), f2.getFormalType(i2));
            builder.addOptFormal(optFormal);
            ++i2;
        }
        if (f1.restFormals != null && f2.restFormals != null) {
            builder.addRestFormals(FunctionType.nullAcceptingMeet(f1.restFormals, f2.restFormals));
        }
        builder.addRetType(JSType.join(f1.returnType, f2.returnType));
        return builder.buildFunction();
    }

    FunctionType specialize(FunctionType other) {
        if (other == null) {
            return null;
        }
        if (!this.isLoose() && other.isLoose()) {
            return this;
        }
        return FunctionType.meet(this, other);
    }

    static FunctionType meet(FunctionType f1, FunctionType f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        if (f1.isTopFunction()) {
            return f2;
        }
        if (f2.isTopFunction() || f1.equals(f2)) {
            return f1;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.requiredFormals.size(), f2.requiredFormals.size());
        int i = 0;
        while (i < minRequiredArity) {
            builder.addReqFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
            ++i;
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        int i2 = minRequiredArity;
        while (i2 < maxTotalArity) {
            builder.addOptFormal(FunctionType.nullAcceptingJoin(f1.getFormalType(i2), f2.getFormalType(i2)));
            ++i2;
        }
        if (f1.restFormals != null || f2.restFormals != null) {
            builder.addRestFormals(FunctionType.nullAcceptingJoin(f1.restFormals, f2.restFormals));
        }
        builder.addRetType(JSType.meet(f1.returnType, f2.returnType));
        return builder.buildFunction();
    }

    boolean isLooseSubtypeOf(FunctionType f2) {
        Preconditions.checkState((this.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        if (this.isTopFunction() || f2.isTopFunction()) {
            return true;
        }
        int maxRequiredArity = Math.max(this.requiredFormals.size(), f2.requiredFormals.size());
        int i = 0;
        while (i < maxRequiredArity) {
            if (JSType.meet(this.getFormalType(i), f2.getFormalType(i)).isBottom()) {
                return false;
            }
            ++i;
        }
        return this.getReturnType().isBottom() || f2.getReturnType().isBottom() || !JSType.meet(this.getReturnType(), f2.getReturnType()).isBottom();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(obj instanceof FunctionType), (Object)("obj is: " + obj));
        FunctionType f2 = (FunctionType)obj;
        return Objects.equal(this.requiredFormals, f2.requiredFormals) && Objects.equal(this.optionalFormals, f2.optionalFormals) && Objects.equal((Object)this.restFormals, (Object)f2.restFormals) && Objects.equal((Object)this.returnType, (Object)f2.returnType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType});
    }

    public String toString() {
        if (this.isTopFunction()) {
            return "TOP_FUNCTION" + (this.isLoose ? " (loose)" : "");
        }
        LinkedList formals = Lists.newLinkedList();
        if (this.klass != null) {
            formals.add("new:" + this.klass.name);
        }
        for (JSType formal : this.requiredFormals) {
            formals.add(formal.toString());
        }
        for (JSType formal : this.optionalFormals) {
            formals.add(String.valueOf(formal.toString()) + "=");
        }
        if (this.restFormals != null) {
            formals.add("..." + this.restFormals.toString());
        }
        String result = "function (" + Joiner.on((String)", ").join((Iterable)formals) + ")";
        if (this.returnType != null) {
            result = String.valueOf(result) + ": " + this.returnType.toString();
        }
        return String.valueOf(result) + (this.isLoose ? " (loose)" : "") + (this.outerVarPreconditions.isEmpty() ? "" : "\tFV:" + this.outerVarPreconditions);
    }
}

