/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.newtypes;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.NominalType;
import java.util.List;
import java.util.Map;

public class FunctionTypeBuilder {
    private final List<JSType> requiredFormals = Lists.newArrayList();
    private final List<JSType> optionalFormals = Lists.newArrayList();
    private final Map<String, JSType> outerVars = Maps.newHashMap();
    private JSType restFormals = null;
    private JSType returnType = null;
    private boolean loose = false;
    private NominalType klass;
    private NominalType receiverType;

    public FunctionTypeBuilder addReqFormal(JSType t) {
        if (!this.optionalFormals.isEmpty() || this.restFormals != null) {
            throw new IllegalStateException("Cannot add required formal after optional or rest args");
        }
        this.requiredFormals.add(t);
        return this;
    }

    public FunctionTypeBuilder addOptFormal(JSType t) {
        if (this.restFormals != null) {
            throw new IllegalStateException("Cannot add optional formal after rest args");
        }
        this.optionalFormals.add(t);
        return this;
    }

    public FunctionTypeBuilder addOuterVarPrecondition(String name, JSType t) {
        this.outerVars.put(name, t);
        return this;
    }

    public FunctionTypeBuilder addRestFormals(JSType t) {
        this.restFormals = t;
        return this;
    }

    public FunctionTypeBuilder addRetType(JSType t) {
        this.returnType = t;
        return this;
    }

    public FunctionTypeBuilder addLoose() {
        this.loose = true;
        return this;
    }

    public FunctionTypeBuilder addClass(NominalType cl) {
        this.klass = cl;
        return this;
    }

    public FunctionTypeBuilder addReceiverType(NominalType cl) {
        this.receiverType = cl;
        return this;
    }

    public DeclaredFunctionType buildDeclaration() {
        Preconditions.checkState((!this.loose ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.outerVars.isEmpty());
        return DeclaredFunctionType.make(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.klass, this.receiverType);
    }

    public FunctionType buildFunction() {
        FunctionType result = FunctionType.normalized(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.klass, this.outerVars, this.loose);
        result.checkValid();
        return result;
    }

    public JSType buildType() {
        return JSType.fromFunctionType(this.buildFunction());
    }
}

