/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser;

import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.TokenType;
import java.util.HashMap;

public enum Keywords {
    BREAK("break", TokenType.BREAK),
    CASE("case", TokenType.CASE),
    CATCH("catch", TokenType.CATCH),
    CONTINUE("continue", TokenType.CONTINUE),
    DEBUGGER("debugger", TokenType.DEBUGGER),
    DEFAULT("default", TokenType.DEFAULT),
    DELETE("delete", TokenType.DELETE),
    DO("do", TokenType.DO),
    ELSE("else", TokenType.ELSE),
    FINALLY("finally", TokenType.FINALLY),
    FOR("for", TokenType.FOR),
    FUNCTION("function", TokenType.FUNCTION),
    IF("if", TokenType.IF),
    IN("in", TokenType.IN),
    INSTANCEOF("instanceof", TokenType.INSTANCEOF),
    NEW("new", TokenType.NEW),
    RETURN("return", TokenType.RETURN),
    SWITCH("switch", TokenType.SWITCH),
    THIS("this", TokenType.THIS),
    THROW("throw", TokenType.THROW),
    TRY("try", TokenType.TRY),
    TYPEOF("typeof", TokenType.TYPEOF),
    VAR("var", TokenType.VAR),
    VOID("void", TokenType.VOID),
    WHILE("while", TokenType.WHILE),
    WITH("with", TokenType.WITH),
    CLASS("class", TokenType.CLASS),
    CONST("const", TokenType.CONST),
    ENUM("enum", TokenType.ENUM),
    EXPORT("export", TokenType.EXPORT),
    EXTENDS("extends", TokenType.EXTENDS),
    IMPORT("import", TokenType.IMPORT),
    SUPER("super", TokenType.SUPER),
    IMPLEMENTS("implements", TokenType.IMPLEMENTS),
    INTERFACE("interface", TokenType.INTERFACE),
    LET("let", TokenType.LET),
    PACKAGE("package", TokenType.PACKAGE),
    PRIVATE("private", TokenType.PRIVATE),
    PROTECTED("protected", TokenType.PROTECTED),
    PUBLIC("public", TokenType.PUBLIC),
    STATIC("static", TokenType.STATIC),
    YIELD("yield", TokenType.YIELD),
    NULL("null", TokenType.NULL),
    TRUE("true", TokenType.TRUE),
    FALSE("false", TokenType.FALSE),
    AWAIT("await", TokenType.AWAIT);

    private static final HashMap<String, Keywords> keywordsByName;
    private static final HashMap<TokenType, Keywords> keywordsByType;
    public final String value;
    public final TokenType type;

    static {
        keywordsByName = new HashMap();
        keywordsByType = new HashMap();
        Keywords[] keywordsArray = Keywords.values();
        int n = keywordsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Keywords kw = keywordsArray[n2];
            keywordsByName.put(kw.value, kw);
            keywordsByType.put(kw.type, kw);
            ++n2;
        }
    }

    private Keywords(String value, TokenType type) {
        this.value = value;
        this.type = type;
    }

    public String toString() {
        return this.value;
    }

    public static boolean isKeyword(String value) {
        return Keywords.get(value) != null;
    }

    public static TokenType getTokenType(String value) {
        return Keywords.keywordsByName.get((Object)value).type;
    }

    public static Keywords get(String value) {
        return keywordsByName.get(value);
    }

    public static Keywords get(TokenType token) {
        return keywordsByType.get((Object)token);
    }
}

