/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.Scanner;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.SourceFile;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.Token;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.TokenType;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.AwaitStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ClassExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FieldDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForEachStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportPathTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinResolveListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinResolveTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ModuleDefinitionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternFieldTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.RequiresMemberTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SpreadPatternElementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TraitDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.YieldStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.MutedErrorReporter;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourceRange;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.Timer;
import java.util.EnumSet;

public class Parser {
    private final Scanner scanner;
    private final ErrorReporter errorReporter;
    private Token lastToken;
    private static final EnumSet<TokenType> declarationDestructuringFollow = EnumSet.of(TokenType.EQUAL);
    private static final EnumSet<TokenType> arraySubPatternFollowSet = EnumSet.of(TokenType.COMMA, TokenType.CLOSE_SQUARE);
    private static final EnumSet<TokenType> objectSubPatternFollowSet = EnumSet.of(TokenType.COMMA, TokenType.CLOSE_CURLY);

    public Parser(ErrorReporter errorReporter, SourceFile source, int offset) {
        this(errorReporter, new Scanner(errorReporter, source, offset));
    }

    public Parser(ErrorReporter errorReporter, SourceFile source) {
        this(errorReporter, new Scanner(errorReporter, source));
    }

    private Parser(ErrorReporter errorReporter, Scanner scanner) {
        this.scanner = scanner;
        this.errorReporter = errorReporter;
    }

    public ProgramTree parseProgram() {
        Timer t = new Timer("Parse Program");
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList<ParseTree> sourceElements = this.parseGlobalSourceElements();
        this.eat(TokenType.END_OF_FILE);
        t.end();
        return new ProgramTree(this.getTreeLocation(start), sourceElements);
    }

    private ImmutableList<ParseTree> parseGlobalSourceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!this.peek(TokenType.END_OF_FILE)) {
            result.add((Object)this.parseScriptElement());
        }
        return result.build();
    }

    private ParseTree parseScriptElement() {
        if (this.peekClassDeclaration()) {
            return this.parseClassDeclaration();
        }
        if (this.peekTraitDeclaration()) {
            return this.parseTraitDeclaration();
        }
        if (this.peekModuleDeclaration()) {
            return this.parseModuleDeclaration();
        }
        return this.parseSourceElement();
    }

    private boolean peekModuleDefinition() {
        return this.peekPredefinedString("module") && this.peek(1, TokenType.IDENTIFIER) && this.peek(2, TokenType.OPEN_CURLY);
    }

    private ParseTree parseModuleDefinition() {
        SourcePosition start = this.getTreeStartLocation();
        this.eatId();
        IdentifierToken name = this.eatId();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekModuleElement()) {
            result.add((Object)this.parseModuleElement());
        }
        this.eat(TokenType.CLOSE_CURLY);
        return new ModuleDefinitionTree(this.getTreeLocation(start), name, (ImmutableList<ParseTree>)result.build());
    }

    private boolean peekModuleElement() {
        return this.peekClassDeclaration() || this.peekTraitDeclaration() || this.peekImportDeclaration() || this.peekExportDeclaration() || this.peekModuleDeclaration() || this.peekSourceElement();
    }

    private ParseTree parseModuleElement() {
        if (this.peekModuleDeclaration()) {
            return this.parseModuleDeclaration();
        }
        if (this.peekImportDeclaration()) {
            return this.parseImportDeclaration();
        }
        if (this.peekExportDeclaration()) {
            return this.parseExportDeclaration();
        }
        return this.parseScriptElement();
    }

    private boolean peekImportDeclaration() {
        return this.peek(TokenType.IMPORT);
    }

    private ParseTree parseImportDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IMPORT);
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object)this.parseImportPath());
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            result.add((Object)this.parseImportPath());
        }
        this.eatPossibleImplicitSemiColon();
        return new ImportDeclarationTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)result.build());
    }

    private ParseTree parseImportPath() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder qualifiedPath = ImmutableList.builder();
        qualifiedPath.add((Object)this.eatId());
        while (this.peek(TokenType.PERIOD) && this.peek(1, TokenType.IDENTIFIER)) {
            this.eat(TokenType.PERIOD);
            qualifiedPath.add((Object)this.eatId());
        }
        if (this.peek(TokenType.PERIOD)) {
            this.eat(TokenType.PERIOD);
            return this.parseImportSpecifierSet(start, (ImmutableList.Builder<IdentifierToken>)qualifiedPath);
        }
        return new ImportPathTree(this.getTreeLocation(start), (ImmutableList<IdentifierToken>)qualifiedPath.build(), ImportPathTree.Kind.NONE);
    }

    private ParseTree parseImportSpecifierSet(SourcePosition start, ImmutableList.Builder<IdentifierToken> qualifiedPath) {
        if (this.peek(TokenType.OPEN_CURLY)) {
            ImmutableList.Builder elements = ImmutableList.builder();
            this.eat(TokenType.OPEN_CURLY);
            elements.add((Object)this.parseImportSpecifier());
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                elements.add((Object)this.parseImportSpecifier());
            }
            this.eat(TokenType.CLOSE_CURLY);
            return new ImportPathTree(this.getTreeLocation(start), (ImmutableList<IdentifierToken>)qualifiedPath.build(), (ImmutableList<ParseTree>)elements.build());
        }
        this.eat(TokenType.STAR);
        return new ImportPathTree(this.getTreeLocation(start), (ImmutableList<IdentifierToken>)qualifiedPath.build(), ImportPathTree.Kind.ALL);
    }

    private ParseTree parseImportSpecifier() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken importedName = this.eatId();
        IdentifierToken destinationName = null;
        if (this.peek(TokenType.COLON)) {
            this.eat(TokenType.COLON);
            destinationName = this.eatId();
        }
        return new ImportSpecifierTree(this.getTreeLocation(start), importedName, destinationName);
    }

    private boolean peekExportDeclaration() {
        return this.peek(TokenType.EXPORT);
    }

    private ParseTree parseExportDeclaration() {
        ParseTree export;
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.EXPORT);
        switch (this.peekType()) {
            case VAR: 
            case CONST: {
                export = this.parseVariableStatement();
                break;
            }
            case FUNCTION: 
            case POUND: {
                export = this.parseFunctionDeclaration();
                break;
            }
            case CLASS: {
                export = this.parseClassDeclaration();
                break;
            }
            case IDENTIFIER: {
                if (this.peekModuleDefinition()) {
                    export = this.parseModuleDefinition();
                    break;
                }
                if (this.peekTraitDeclaration()) {
                    export = this.parseTraitDeclaration();
                    break;
                }
                throw new RuntimeException("UNDONE: export ModuleLoad | ExportPath");
            }
            default: {
                export = null;
            }
        }
        return new ExportDeclarationTree(this.getTreeLocation(start), export);
    }

    private boolean peekModuleDeclaration() {
        return this.peekModuleDefinition();
    }

    private ParseTree parseModuleDeclaration() {
        return this.parseModuleDefinition();
    }

    private boolean peekTraitDeclaration() {
        return this.peekPredefinedString("trait");
    }

    private ParseTree parseTraitDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eatId();
        IdentifierToken name = this.eatId();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = this.parseTraitElements();
        this.eat(TokenType.CLOSE_CURLY);
        return new TraitDeclarationTree(this.getTreeLocation(start), name, elements);
    }

    private ImmutableList<ParseTree> parseTraitElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekTraitElement()) {
            result.add((Object)this.parseTraitElement());
        }
        return result.build();
    }

    private boolean peekTraitElement() {
        switch (this.peekType()) {
            case IDENTIFIER: 
            case FUNCTION: 
            case POUND: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseTraitElement() {
        if (this.peekGetAccessor(false)) {
            return this.parseGetAccessor();
        }
        if (this.peekSetAccessor(false)) {
            return this.parseSetAccessor();
        }
        if (this.peekMixin()) {
            return this.parseMixin();
        }
        if (this.peekRequiresMember()) {
            return this.parseRequiresMember();
        }
        return this.parseMethodDeclaration(false);
    }

    private boolean peekRequiresMember() {
        return this.peekPredefinedString("requires") && this.peek(1, TokenType.IDENTIFIER);
    }

    private ParseTree parseRequiresMember() {
        SourcePosition start = this.getTreeStartLocation();
        this.eatId();
        IdentifierToken name = this.eatId();
        this.eat(TokenType.SEMI_COLON);
        return new RequiresMemberTree(this.getTreeLocation(start), name);
    }

    private boolean peekMixin() {
        return this.peekPredefinedString("mixin") && this.peek(1, TokenType.IDENTIFIER);
    }

    private boolean peekClassDeclaration() {
        return this.peek(TokenType.CLASS);
    }

    private ParseTree parseClassDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CLASS);
        IdentifierToken name = this.eatId();
        ParseTree superClass = null;
        if (this.peek(TokenType.COLON)) {
            this.eat(TokenType.COLON);
            superClass = this.parseExpression();
        }
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = this.parseClassElements();
        this.eat(TokenType.CLOSE_CURLY);
        return new ClassDeclarationTree(this.getTreeLocation(start), name, superClass, elements);
    }

    private ImmutableList<ParseTree> parseClassElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekClassElement()) {
            result.add((Object)this.parseClassElement());
        }
        return result.build();
    }

    private boolean peekClassElement() {
        switch (this.peekType()) {
            case IDENTIFIER: 
            case FUNCTION: 
            case VAR: 
            case CONST: 
            case STATIC: 
            case POUND: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseClassElement() {
        if (this.peekMethodDeclaration()) {
            return this.parseMethodDeclaration(true);
        }
        if (this.peekGetAccessor(true)) {
            return this.parseGetAccessor();
        }
        if (this.peekSetAccessor(true)) {
            return this.parseSetAccessor();
        }
        if (this.peekMixin()) {
            return this.parseMixin();
        }
        if (this.peekRequiresMember()) {
            return this.parseRequiresMember();
        }
        return this.parseFieldDeclaration();
    }

    private ParseTree parseFieldDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = this.eatOpt(TokenType.STATIC) != null;
        TokenType binding = this.peekType();
        boolean isConst = false;
        switch (binding) {
            case CONST: {
                this.eat(TokenType.CONST);
                isConst = true;
                break;
            }
            case VAR: {
                this.eat(TokenType.VAR);
            }
        }
        ImmutableList.Builder declarations = ImmutableList.builder();
        declarations.add((Object)this.parseVariableDeclaration(isStatic, binding, Expression.NORMAL));
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            declarations.add((Object)this.parseVariableDeclaration(isStatic, binding, Expression.NORMAL));
        }
        this.eat(TokenType.SEMI_COLON);
        return new FieldDeclarationTree(this.getTreeLocation(start), isStatic, isConst, (ImmutableList<VariableDeclarationTree>)declarations.build());
    }

    private ParseTree parseMixin() {
        SourcePosition start = this.getTreeStartLocation();
        this.eatId();
        IdentifierToken name = this.eatId();
        MixinResolveListTree mixinResolves = null;
        if (this.peek(TokenType.OPEN_CURLY)) {
            mixinResolves = this.parseMixinResolves();
        }
        this.eat(TokenType.SEMI_COLON);
        return new MixinTree(this.getTreeLocation(start), name, mixinResolves);
    }

    private MixinResolveListTree parseMixinResolves() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder result = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peek(TokenType.IDENTIFIER)) {
            result.add((Object)this.parseMixinResolve());
            if (this.eatOpt(TokenType.COMMA) == null) break;
        }
        this.eat(TokenType.CLOSE_CURLY);
        return new MixinResolveListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)result.build());
    }

    private ParseTree parseMixinResolve() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken from = this.eatId();
        this.eat(TokenType.COLON);
        IdentifierToken to = this.eatId();
        return new MixinResolveTree(this.getTreeLocation(start), from, to);
    }

    private ParseTree parseMethodDeclaration(boolean allowStatic) {
        boolean isStatic;
        SourcePosition start = this.getTreeStartLocation();
        boolean bl = isStatic = allowStatic && this.eatOpt(TokenType.STATIC) != null;
        if (this.peekFunction()) {
            this.nextToken();
        }
        return this.parseFunctionDeclarationTail(start, isStatic);
    }

    private boolean peekMethodDeclaration() {
        int index;
        int n = index = this.peek(TokenType.STATIC) ? 1 : 0;
        return this.peekFunction(index) || this.peek(index, TokenType.IDENTIFIER) && this.peek(index + 1, TokenType.OPEN_PAREN);
    }

    private ParseTree parseSourceElement() {
        if (this.peekFunction()) {
            return this.parseFunctionDeclaration();
        }
        if (this.peek(TokenType.LET)) {
            return this.parseVariableStatement();
        }
        return this.parseStatementStandard();
    }

    private boolean peekSourceElement() {
        return this.peekFunction() || this.peekStatementStandard() || this.peek(TokenType.LET);
    }

    private boolean peekFunction() {
        return this.peekFunction(0);
    }

    private boolean peekFunction(int index) {
        return this.peek(index, TokenType.FUNCTION) || this.peek(index, TokenType.POUND);
    }

    private ParseTree parseFunctionDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.nextToken();
        return this.parseFunctionDeclarationTail(start, false);
    }

    private ParseTree parseFunctionDeclarationTail(SourcePosition start, boolean isStatic) {
        IdentifierToken name = this.eatId();
        this.eat(TokenType.OPEN_PAREN);
        FormalParameterListTree formalParameterList = this.parseFormalParameterList();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree functionBody = this.parseFunctionBody();
        return new FunctionDeclarationTree(this.getTreeLocation(start), name, isStatic, formalParameterList, functionBody);
    }

    private ParseTree parseFunctionExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.nextToken();
        IdentifierToken name = this.eatIdOpt();
        this.eat(TokenType.OPEN_PAREN);
        FormalParameterListTree formalParameterList = this.parseFormalParameterList();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree functionBody = this.parseFunctionBody();
        return new FunctionDeclarationTree(this.getTreeLocation(start), name, false, formalParameterList, functionBody);
    }

    private FormalParameterListTree parseFormalParameterList() {
        ImmutableList.Builder result = ImmutableList.builder();
        boolean hasDefaultParameters = false;
        while (this.peek(TokenType.IDENTIFIER) || this.peek(TokenType.SPREAD)) {
            if (this.peek(TokenType.SPREAD)) {
                SourcePosition start = this.getTreeStartLocation();
                this.eat(TokenType.SPREAD);
                result.add((Object)new RestParameterTree(this.getTreeLocation(start), this.eatId()));
                break;
            }
            if (hasDefaultParameters || this.peek(1, TokenType.EQUAL)) {
                result.add((Object)this.parseDefaultParameter());
                hasDefaultParameters = true;
            } else {
                result.add((Object)this.parseIdentifierExpression());
            }
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            this.eat(TokenType.COMMA);
        }
        return new FormalParameterListTree(null, (ImmutableList<ParseTree>)result.build());
    }

    private DefaultParameterTree parseDefaultParameter() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierExpressionTree ident = this.parseIdentifierExpression();
        this.eat(TokenType.EQUAL);
        ParseTree expr = this.parseAssignmentExpression();
        return new DefaultParameterTree(this.getTreeLocation(start), ident, expr);
    }

    private BlockTree parseFunctionBody() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseSourceElementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekSourceElement()) {
            result.add((Object)this.parseSourceElement());
        }
        return result.build();
    }

    private SpreadExpressionTree parseSpreadExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SPREAD);
        ParseTree operand = this.parseAssignmentExpression();
        return new SpreadExpressionTree(this.getTreeLocation(start), operand);
    }

    private ParseTree parseStatement() {
        return this.parseSourceElement();
    }

    private ParseTree parseStatementStandard() {
        switch (this.peekType()) {
            case OPEN_CURLY: {
                return this.parseBlock();
            }
            case AWAIT: {
                return this.parseAsyncStatement();
            }
            case VAR: 
            case CONST: {
                return this.parseVariableStatement();
            }
            case SEMI_COLON: {
                return this.parseEmptyStatement();
            }
            case IF: {
                return this.parseIfStatement();
            }
            case DO: {
                return this.parseDoWhileStatement();
            }
            case WHILE: {
                return this.parseWhileStatement();
            }
            case FOR: {
                return this.parseForStatement();
            }
            case CONTINUE: {
                return this.parseContinueStatement();
            }
            case BREAK: {
                return this.parseBreakStatement();
            }
            case RETURN: {
                return this.parseReturnStatement();
            }
            case YIELD: {
                return this.parseYieldStatement();
            }
            case WITH: {
                return this.parseWithStatement();
            }
            case SWITCH: {
                return this.parseSwitchStatement();
            }
            case THROW: {
                return this.parseThrowStatement();
            }
            case TRY: {
                return this.parseTryStatement();
            }
            case DEBUGGER: {
                return this.parseDebuggerStatement();
            }
        }
        if (this.peekLabelledStatement()) {
            return this.parseLabelledStatement();
        }
        return this.parseExpressionStatement();
    }

    private boolean peekStatement() {
        return this.peekSourceElement();
    }

    private boolean peekStatementStandard() {
        switch (this.peekType()) {
            case IDENTIFIER: 
            case BREAK: 
            case CONTINUE: 
            case DEBUGGER: 
            case DELETE: 
            case DO: 
            case FOR: 
            case IF: 
            case NEW: 
            case RETURN: 
            case SWITCH: 
            case THIS: 
            case THROW: 
            case TRY: 
            case TYPEOF: 
            case VAR: 
            case VOID: 
            case WHILE: 
            case WITH: 
            case CLASS: 
            case CONST: 
            case SUPER: 
            case YIELD: 
            case OPEN_CURLY: 
            case OPEN_PAREN: 
            case OPEN_SQUARE: 
            case SEMI_COLON: 
            case PLUS: 
            case MINUS: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case BANG: 
            case TILDE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case NULL: 
            case TRUE: 
            case FALSE: 
            case NUMBER: 
            case STRING: 
            case AWAIT: {
                return true;
            }
        }
        return false;
    }

    private BlockTree parseBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseStatementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekStatement()) {
            result.add((Object)this.parseStatement());
        }
        return result.build();
    }

    private VariableStatementTree parseVariableStatement() {
        SourcePosition start = this.getTreeStartLocation();
        VariableDeclarationListTree declarations = this.parseVariableDeclarationList();
        this.checkInitializers(declarations);
        this.eatPossibleImplicitSemiColon();
        return new VariableStatementTree(this.getTreeLocation(start), declarations);
    }

    private VariableDeclarationListTree parseVariableDeclarationList() {
        return this.parseVariableDeclarationList(Expression.NORMAL);
    }

    private VariableDeclarationListTree parseVariableDeclarationListNoIn() {
        return this.parseVariableDeclarationList(Expression.NO_IN);
    }

    private VariableDeclarationListTree parseVariableDeclarationList(Expression expressionIn) {
        TokenType token = this.peekType();
        switch (token) {
            case VAR: 
            case CONST: 
            case LET: {
                this.eat(token);
                break;
            }
            default: {
                throw new RuntimeException("unreachable");
            }
        }
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder declarations = ImmutableList.builder();
        declarations.add((Object)this.parseVariableDeclaration(false, token, expressionIn));
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            declarations.add((Object)this.parseVariableDeclaration(false, token, expressionIn));
        }
        return new VariableDeclarationListTree(this.getTreeLocation(start), token, (ImmutableList<VariableDeclarationTree>)declarations.build());
    }

    private VariableDeclarationTree parseVariableDeclaration(boolean isStatic, TokenType binding, Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree lvalue = this.peekPattern(PatternKind.INITIALIZER, declarationDestructuringFollow) ? this.parsePattern(PatternKind.INITIALIZER) : this.parseIdentifierExpression();
        ParseTree initializer = null;
        if (this.peek(TokenType.EQUAL)) {
            initializer = this.parseInitializer(expressionIn);
        } else if (binding == TokenType.CONST) {
            this.reportError("const variables must have an initializer", new Object[0]);
        } else if (lvalue.isPattern()) {
            this.reportError("destructuring must have an initializer", new Object[0]);
        }
        return new VariableDeclarationTree(this.getTreeLocation(start), lvalue, initializer);
    }

    private ParseTree parseInitializer(Expression expressionIn) {
        this.eat(TokenType.EQUAL);
        return this.parseAssignment(expressionIn);
    }

    private EmptyStatementTree parseEmptyStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SEMI_COLON);
        return new EmptyStatementTree(this.getTreeLocation(start));
    }

    private ExpressionStatementTree parseExpressionStatement() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree expression = this.parseExpression();
        this.eatPossibleImplicitSemiColon();
        return new ExpressionStatementTree(this.getTreeLocation(start), expression);
    }

    private IfStatementTree parseIfStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IF);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree ifClause = this.parseStatement();
        ParseTree elseClause = null;
        if (this.peek(TokenType.ELSE)) {
            this.eat(TokenType.ELSE);
            elseClause = this.parseStatement();
        }
        return new IfStatementTree(this.getTreeLocation(start), condition, ifClause, elseClause);
    }

    private ParseTree parseDoWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DO);
        ParseTree body = this.parseStatement();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        this.eatPossibleImplicitSemiColon();
        return new DoWhileStatementTree(this.getTreeLocation(start), body, condition);
    }

    private ParseTree parseWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WhileStatementTree(this.getTreeLocation(start), condition, body);
    }

    private ParseTree parseForStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FOR);
        this.eat(TokenType.OPEN_PAREN);
        if (this.peekVariableDeclarationList()) {
            VariableDeclarationListTree variables = this.parseVariableDeclarationListNoIn();
            if (this.peek(TokenType.IN)) {
                if (variables.declarations.size() > 1) {
                    this.reportError("for-in statement may not have more than one variable declaration", new Object[0]);
                }
                if (variables.declarationType == TokenType.LET || variables.declarationType == TokenType.CONST) {
                    VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                    if (declaration.initializer != null) {
                        this.reportError("let/const in for-in statement may not have initializer", new Object[0]);
                    }
                }
                return this.parseForInStatement(start, variables);
            }
            if (this.peek(TokenType.COLON)) {
                if (variables.declarations.size() > 1) {
                    this.reportError("for-each statement may not have more than one variable declaration", new Object[0]);
                }
                VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                if (declaration.initializer != null) {
                    this.reportError("for-each statement may not have initializer", new Object[0]);
                }
                return this.parseForEachStatement(start, variables);
            }
            this.checkInitializers(variables);
            return this.parseForStatement(start, variables);
        }
        if (this.peek(TokenType.SEMI_COLON)) {
            return this.parseForStatement(start, null);
        }
        ParseTree initializer = this.parseExpressionNoIn();
        if (this.peek(TokenType.IN)) {
            return this.parseForInStatement(start, initializer);
        }
        return this.parseForStatement(start, initializer);
    }

    private ParseTree parseForEachStatement(SourcePosition start, VariableDeclarationListTree initializer) {
        this.eat(TokenType.COLON);
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForEachStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private void checkInitializers(VariableDeclarationListTree variables) {
        if (variables.declarationType == TokenType.LET || variables.declarationType == TokenType.CONST) {
            for (VariableDeclarationTree declaration : variables.declarations) {
                if (declaration.initializer != null) continue;
                this.reportError("let/const in for statement must have an initializer", new Object[0]);
                break;
            }
        }
    }

    private boolean peekVariableDeclarationList() {
        switch (this.peekType()) {
            case VAR: 
            case CONST: 
            case LET: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseForStatement(SourcePosition start, ParseTree initializer) {
        this.eat(TokenType.SEMI_COLON);
        ParseTree condition = null;
        if (!this.peek(TokenType.SEMI_COLON)) {
            condition = this.parseExpression();
        }
        this.eat(TokenType.SEMI_COLON);
        ParseTree increment = null;
        if (!this.peek(TokenType.CLOSE_PAREN)) {
            increment = this.parseExpression();
        }
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForStatementTree(this.getTreeLocation(start), initializer, condition, increment, body);
    }

    private ParseTree parseForInStatement(SourcePosition start, ParseTree initializer) {
        this.eat(TokenType.IN);
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForInStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private ParseTree parseContinueStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CONTINUE);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new ContinueStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseBreakStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.BREAK);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new BreakStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseReturnStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.RETURN);
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            expression = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ReturnStatementTree(this.getTreeLocation(start), expression);
    }

    private ParseTree parseYieldStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.YIELD);
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            expression = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new YieldStatementTree(this.getTreeLocation(start), expression);
    }

    private ParseTree parseAsyncStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.AWAIT);
        IdentifierToken identifier = null;
        if (this.peek(TokenType.IDENTIFIER) && this.peek(1, TokenType.EQUAL)) {
            identifier = this.eatId();
            this.eat(TokenType.EQUAL);
        }
        ParseTree expression = this.parseExpression();
        this.eatPossibleImplicitSemiColon();
        return new AwaitStatementTree(this.getTreeLocation(start), identifier, expression);
    }

    private ParseTree parseWithStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WITH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WithStatementTree(this.getTreeLocation(start), expression, body);
    }

    private ParseTree parseSwitchStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SWITCH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> caseClauses = this.parseCaseClauses();
        this.eat(TokenType.CLOSE_CURLY);
        return new SwitchStatementTree(this.getTreeLocation(start), expression, caseClauses);
    }

    private ImmutableList<ParseTree> parseCaseClauses() {
        boolean foundDefaultClause = false;
        ImmutableList.Builder result = ImmutableList.builder();
        block4: while (true) {
            SourcePosition start = this.getTreeStartLocation();
            switch (this.peekType()) {
                case CASE: {
                    this.eat(TokenType.CASE);
                    ParseTree expression = this.parseExpression();
                    this.eat(TokenType.COLON);
                    ImmutableList<ParseTree> statements = this.parseCaseStatementsOpt();
                    result.add((Object)new CaseClauseTree(this.getTreeLocation(start), expression, statements));
                    continue block4;
                }
                case DEFAULT: {
                    if (foundDefaultClause) {
                        this.reportError("Switch statements may have at most one default clause", new Object[0]);
                    } else {
                        foundDefaultClause = true;
                    }
                    this.eat(TokenType.DEFAULT);
                    this.eat(TokenType.COLON);
                    result.add((Object)new DefaultClauseTree(this.getTreeLocation(start), this.parseCaseStatementsOpt()));
                    continue block4;
                }
            }
            break;
        }
        return result.build();
    }

    private ImmutableList<ParseTree> parseCaseStatementsOpt() {
        return this.parseStatementList();
    }

    private ParseTree parseLabelledStatement() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken name = this.eatId();
        this.eat(TokenType.COLON);
        return new LabelledStatementTree(this.getTreeLocation(start), name, this.parseStatement());
    }

    private boolean peekLabelledStatement() {
        return this.peek(TokenType.IDENTIFIER) && this.peek(1, TokenType.COLON);
    }

    private ParseTree parseThrowStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THROW);
        ParseTree value = null;
        if (!this.peekImplicitSemiColon()) {
            value = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ThrowStatementTree(this.getTreeLocation(start), value);
    }

    private ParseTree parseTryStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.TRY);
        BlockTree body = this.parseBlock();
        ParseTree catchBlock = null;
        if (this.peek(TokenType.CATCH)) {
            catchBlock = this.parseCatch();
        }
        ParseTree finallyBlock = null;
        if (this.peek(TokenType.FINALLY)) {
            finallyBlock = this.parseFinallyBlock();
        }
        if (catchBlock == null && finallyBlock == null) {
            this.reportError("'catch' or 'finally' expected.", new Object[0]);
        }
        return new TryStatementTree(this.getTreeLocation(start), body, catchBlock, finallyBlock);
    }

    private ParseTree parseCatch() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CATCH);
        this.eat(TokenType.OPEN_PAREN);
        IdentifierToken exceptionName = this.eatId();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree catchBody = this.parseBlock();
        CatchTree catchBlock = new CatchTree(this.getTreeLocation(start), exceptionName, catchBody);
        return catchBlock;
    }

    private ParseTree parseFinallyBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FINALLY);
        BlockTree finallyBlock = this.parseBlock();
        return new FinallyTree(this.getTreeLocation(start), finallyBlock);
    }

    private ParseTree parseDebuggerStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DEBUGGER);
        this.eatPossibleImplicitSemiColon();
        return new DebuggerStatementTree(this.getTreeLocation(start));
    }

    private ParseTree parsePrimaryExpression() {
        switch (this.peekType()) {
            case CLASS: {
                return this.parseClassExpression();
            }
            case SUPER: {
                return this.parseSuperExpression();
            }
            case THIS: {
                return this.parseThisExpression();
            }
            case IDENTIFIER: {
                return this.parseIdentifierExpression();
            }
            case NULL: 
            case TRUE: 
            case FALSE: 
            case NUMBER: 
            case STRING: {
                return this.parseLiteralExpression();
            }
            case OPEN_SQUARE: {
                return this.parseArrayLiteral();
            }
            case OPEN_CURLY: {
                return this.parseObjectLiteral();
            }
            case OPEN_PAREN: {
                return this.parseParenExpression();
            }
            case SLASH: 
            case SLASH_EQUAL: {
                return this.parseRegularExpressionLiteral();
            }
        }
        return this.parseMissingPrimaryExpression();
    }

    private ParseTree parseClassExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CLASS);
        return new ClassExpressionTree(this.getTreeLocation(start));
    }

    private SuperExpressionTree parseSuperExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SUPER);
        return new SuperExpressionTree(this.getTreeLocation(start));
    }

    private ThisExpressionTree parseThisExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THIS);
        return new ThisExpressionTree(this.getTreeLocation(start));
    }

    private IdentifierExpressionTree parseIdentifierExpression() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken identifier = this.eatId();
        return new IdentifierExpressionTree(this.getTreeLocation(start), identifier);
    }

    private LiteralExpressionTree parseLiteralExpression() {
        SourcePosition start = this.getTreeStartLocation();
        Token literal = this.nextLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private Token nextLiteralToken() {
        return this.nextToken();
    }

    private ParseTree parseRegularExpressionLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        LiteralToken literal = this.nextRegularExpressionLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private ParseTree parseArrayLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        while (this.peek(TokenType.COMMA) || this.peek(TokenType.SPREAD) || this.peekAssignmentExpression()) {
            if (this.peek(TokenType.COMMA)) {
                elements.add((Object)NullTree.Instance);
            } else if (this.peek(TokenType.SPREAD)) {
                elements.add((Object)this.parseSpreadExpression());
            } else {
                elements.add((Object)this.parseAssignmentExpression());
            }
            if (this.peek(TokenType.CLOSE_SQUARE)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_SQUARE);
        return new ArrayLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder result = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekPropertyAssignment()) {
            result.add((Object)this.parsePropertyAssignment());
            if (this.eatOpt(TokenType.COMMA) == null) break;
        }
        this.eat(TokenType.CLOSE_CURLY);
        return new ObjectLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)result.build());
    }

    private boolean peekPropertyAssignment() {
        return this.peekPropertyName(0);
    }

    private boolean peekPropertyName(int tokenIndex) {
        switch (this.peekType(tokenIndex)) {
            case IDENTIFIER: 
            case NUMBER: 
            case STRING: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parsePropertyAssignment() {
        switch (this.peekType()) {
            case IDENTIFIER: {
                if (this.peekGetAccessor(false)) {
                    return this.parseGetAccessor();
                }
                if (this.peekSetAccessor(false)) {
                    return this.parseSetAccessor();
                }
                return this.parsePropertyNameAssignment();
            }
            case NUMBER: 
            case STRING: {
                return this.parsePropertyNameAssignment();
            }
        }
        throw new RuntimeException("unreachable");
    }

    private boolean peekGetAccessor(boolean allowStatic) {
        int index;
        int n = index = allowStatic && this.peek(TokenType.STATIC) ? 1 : 0;
        return this.peekPredefinedString(index, "get") && this.peekPropertyName(index + 1);
    }

    private boolean peekPredefinedString(String string) {
        return this.peekPredefinedString(0, string);
    }

    private boolean peekPredefinedString(int index, String string) {
        return this.peek(index, TokenType.IDENTIFIER) && ((IdentifierToken)this.peekToken((int)index)).value.equals(string);
    }

    private ParseTree parseGetAccessor() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = this.eatOpt(TokenType.STATIC) != null;
        this.eatId();
        Token propertyName = this.nextToken();
        this.eat(TokenType.OPEN_PAREN);
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree body = this.parseFunctionBody();
        return new GetAccessorTree(this.getTreeLocation(start), propertyName, isStatic, body);
    }

    private boolean peekSetAccessor(boolean allowStatic) {
        int index;
        int n = index = allowStatic && this.peek(TokenType.STATIC) ? 1 : 0;
        return this.peekPredefinedString(index, "set") && this.peekPropertyName(index + 1);
    }

    private ParseTree parseSetAccessor() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = this.eatOpt(TokenType.STATIC) != null;
        this.eatId();
        Token propertyName = this.nextToken();
        this.eat(TokenType.OPEN_PAREN);
        IdentifierToken parameter = this.eatId();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree body = this.parseFunctionBody();
        return new SetAccessorTree(this.getTreeLocation(start), propertyName, isStatic, parameter, body);
    }

    private ParseTree parsePropertyNameAssignment() {
        SourcePosition start = this.getTreeStartLocation();
        Token name = this.nextToken();
        this.eat(TokenType.COLON);
        ParseTree value = this.parseAssignmentExpression();
        return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parseParenExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_PAREN);
        ParseTree result = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ParenExpressionTree(this.getTreeLocation(start), result);
    }

    private ParseTree parseMissingPrimaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.reportError("primary expression expected", new Object[0]);
        Token token = this.nextToken();
        return new MissingPrimaryExpressionTree(this.getTreeLocation(start), token);
    }

    private ParseTree parseExpressionNoIn() {
        return this.parse(Expression.NO_IN);
    }

    private ParseTree parseExpression() {
        return this.parse(Expression.NORMAL);
    }

    private boolean peekExpression() {
        switch (this.peekType()) {
            case IDENTIFIER: 
            case DELETE: 
            case FUNCTION: 
            case NEW: 
            case THIS: 
            case TYPEOF: 
            case VOID: 
            case CLASS: 
            case SUPER: 
            case OPEN_CURLY: 
            case OPEN_PAREN: 
            case OPEN_SQUARE: 
            case PLUS: 
            case MINUS: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case BANG: 
            case TILDE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case NULL: 
            case TRUE: 
            case FALSE: 
            case NUMBER: 
            case STRING: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parse(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree result = this.parseAssignment(expressionIn);
        if (this.peek(TokenType.COMMA)) {
            ImmutableList.Builder exprs = ImmutableList.builder();
            exprs.add((Object)result);
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                exprs.add((Object)this.parseAssignment(expressionIn));
            }
            return new CommaExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)exprs.build());
        }
        return result;
    }

    private ParseTree parseAssignmentExpression() {
        return this.parseAssignment(Expression.NORMAL);
    }

    private boolean peekAssignmentExpression() {
        return this.peekExpression();
    }

    private ParseTree parseAssignment(Expression expressionIn) {
        ParseTree left;
        SourcePosition start = this.getTreeStartLocation();
        ParseTree parseTree = left = this.peekParenPatternAssignment() ? this.parseParenPattern() : this.parseConditional(expressionIn);
        if (this.peekAssignmentOperator()) {
            if (!left.isLeftHandSideExpression() && !left.isPattern()) {
                this.reportError("Left hand side of assignment must be new, call, member, function, primary expressions or destructuring pattern", new Object[0]);
            }
            Token operator = this.nextToken();
            ParseTree right = this.parseAssignment(expressionIn);
            return new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekAssignmentOperator() {
        switch (this.peekType()) {
            case EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case STAR_EQUAL: 
            case PERCENT_EQUAL: 
            case LEFT_SHIFT_EQUAL: 
            case RIGHT_SHIFT_EQUAL: 
            case UNSIGNED_RIGHT_SHIFT_EQUAL: 
            case AMPERSAND_EQUAL: 
            case BAR_EQUAL: 
            case CARET_EQUAL: 
            case SLASH_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseConditional(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree condition = this.parseLogicalOR(expressionIn);
        if (this.peek(TokenType.QUESTION)) {
            this.eat(TokenType.QUESTION);
            ParseTree left = this.parseAssignment(expressionIn);
            this.eat(TokenType.COLON);
            ParseTree right = this.parseAssignment(expressionIn);
            return new ConditionalExpressionTree(this.getTreeLocation(start), condition, left, right);
        }
        return condition;
    }

    private ParseTree parseLogicalOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseLogicalAND(expressionIn);
        while (this.peek(TokenType.OR)) {
            Token operator = this.eat(TokenType.OR);
            ParseTree right = this.parseLogicalAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseLogicalAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseOR(expressionIn);
        while (this.peek(TokenType.AND)) {
            Token operator = this.eat(TokenType.AND);
            ParseTree right = this.parseBitwiseOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseXOR(expressionIn);
        while (this.peek(TokenType.BAR)) {
            Token operator = this.eat(TokenType.BAR);
            ParseTree right = this.parseBitwiseXOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseXOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseAND(expressionIn);
        while (this.peek(TokenType.CARET)) {
            Token operator = this.eat(TokenType.CARET);
            ParseTree right = this.parseBitwiseAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseEquality(expressionIn);
        while (this.peek(TokenType.AMPERSAND)) {
            Token operator = this.eat(TokenType.AMPERSAND);
            ParseTree right = this.parseEquality(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseEquality(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseRelational(expressionIn);
        while (this.peekEqualityOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseRelational(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekEqualityOperator() {
        switch (this.peekType()) {
            case EQUAL_EQUAL: 
            case NOT_EQUAL: 
            case EQUAL_EQUAL_EQUAL: 
            case NOT_EQUAL_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseRelational(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseShiftExpression();
        while (this.peekRelationalOperator(expressionIn)) {
            Token operator = this.nextToken();
            ParseTree right = this.parseShiftExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekRelationalOperator(Expression expressionIn) {
        switch (this.peekType()) {
            case INSTANCEOF: 
            case OPEN_ANGLE: 
            case CLOSE_ANGLE: 
            case LESS_EQUAL: 
            case GREATER_EQUAL: {
                return true;
            }
            case IN: {
                return expressionIn == Expression.NORMAL;
            }
        }
        return false;
    }

    private ParseTree parseShiftExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseAdditiveExpression();
        while (this.peekShiftOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseAdditiveExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekShiftOperator() {
        switch (this.peekType()) {
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseAdditiveExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseMultiplicativeExpression();
        while (this.peekAdditiveOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseMultiplicativeExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekAdditiveOperator() {
        switch (this.peekType()) {
            case PLUS: 
            case MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseMultiplicativeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseUnaryExpression();
        while (this.peekMultiplicativeOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseUnaryExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekMultiplicativeOperator() {
        switch (this.peekType()) {
            case STAR: 
            case PERCENT: 
            case SLASH: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseUnaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekUnaryOperator()) {
            Token operator = this.nextToken();
            ParseTree operand = this.parseUnaryExpression();
            return new UnaryExpressionTree(this.getTreeLocation(start), operator, operand);
        }
        return this.parsePostfixExpression();
    }

    private boolean peekUnaryOperator() {
        switch (this.peekType()) {
            case DELETE: 
            case TYPEOF: 
            case VOID: 
            case PLUS: 
            case MINUS: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case BANG: 
            case TILDE: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parsePostfixExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.parseLeftHandSideExpression();
        while (this.peekPostfixOperator()) {
            Token operator = this.nextToken();
            operand = new PostfixExpressionTree(this.getTreeLocation(start), operand, operator);
        }
        return operand;
    }

    private boolean peekPostfixOperator() {
        if (this.peekImplicitSemiColon()) {
            return false;
        }
        switch (this.peekType()) {
            case PLUS_PLUS: 
            case MINUS_MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseLeftHandSideExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.parseNewExpression();
        if (!(operand instanceof NewExpressionTree) || ((NewExpressionTree)operand).arguments != null) {
            while (this.peekCallSuffix()) {
                switch (this.peekType()) {
                    case OPEN_PAREN: {
                        ArgumentListTree arguments = this.parseArguments();
                        operand = new CallExpressionTree(this.getTreeLocation(start), operand, arguments);
                        break;
                    }
                    case OPEN_SQUARE: {
                        this.eat(TokenType.OPEN_SQUARE);
                        ParseTree member = this.parseExpression();
                        this.eat(TokenType.CLOSE_SQUARE);
                        operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                        break;
                    }
                    case PERIOD: {
                        this.eat(TokenType.PERIOD);
                        operand = new MemberExpressionTree(this.getTreeLocation(start), operand, this.eatId());
                    }
                }
            }
        }
        return operand;
    }

    private boolean peekCallSuffix() {
        return this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD);
    }

    private ParseTree parseMemberExpressionNoNew() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.peekFunction() ? this.parseFunctionExpression() : this.parsePrimaryExpression();
        while (this.peekMemberExpressionSuffix()) {
            if (this.peek(TokenType.OPEN_SQUARE)) {
                this.eat(TokenType.OPEN_SQUARE);
                ParseTree member = this.parseExpression();
                this.eat(TokenType.CLOSE_SQUARE);
                operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                continue;
            }
            this.eat(TokenType.PERIOD);
            operand = new MemberExpressionTree(this.getTreeLocation(start), operand, this.eatId());
        }
        return operand;
    }

    private boolean peekMemberExpressionSuffix() {
        return this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD);
    }

    private ParseTree parseNewExpression() {
        if (this.peek(TokenType.NEW)) {
            SourcePosition start = this.getTreeStartLocation();
            this.eat(TokenType.NEW);
            ParseTree operand = this.parseNewExpression();
            ArgumentListTree arguments = null;
            if (this.peek(TokenType.OPEN_PAREN)) {
                arguments = this.parseArguments();
            }
            return new NewExpressionTree(this.getTreeLocation(start), operand, arguments);
        }
        return this.parseMemberExpressionNoNew();
    }

    private ArgumentListTree parseArguments() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder arguments = ImmutableList.builder();
        this.eat(TokenType.OPEN_PAREN);
        while (this.peekAssignmentOrSpread()) {
            arguments.add((Object)this.parseAssignmentOrSpead());
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new ArgumentListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)arguments.build());
    }

    private boolean peekAssignmentOrSpread() {
        return this.peek(TokenType.SPREAD) || this.peekAssignmentExpression();
    }

    private ParseTree parseAssignmentOrSpead() {
        if (this.peek(TokenType.SPREAD)) {
            return this.parseSpreadExpression();
        }
        return this.parseAssignmentExpression();
    }

    private boolean peekParenPatternAssignment() {
        if (!this.peekParenPatternStart()) {
            return false;
        }
        Parser p = this.createLookaheadParser();
        p.parseParenPattern();
        return !p.errorReporter.hadError() && p.peek(TokenType.EQUAL);
    }

    private boolean peekParenPatternStart() {
        int index = 0;
        while (this.peek(index, TokenType.OPEN_PAREN)) {
            ++index;
        }
        return this.peekPatternStart(index);
    }

    private boolean peekPatternStart() {
        return this.peekPatternStart(0);
    }

    private boolean peekPatternStart(int index) {
        return this.peek(index, TokenType.OPEN_SQUARE) || this.peek(index, TokenType.OPEN_CURLY);
    }

    private ParseTree parseParenPattern() {
        return this.parseParenPattern(PatternKind.ANY);
    }

    private ParseTree parseParenPattern(PatternKind kind) {
        if (this.peek(TokenType.OPEN_PAREN)) {
            SourcePosition start = this.getTreeStartLocation();
            this.eat(TokenType.OPEN_PAREN);
            ParseTree result = this.parseParenPattern(kind);
            this.eat(TokenType.CLOSE_PAREN);
            return new ParenExpressionTree(this.getTreeLocation(start), result);
        }
        return this.parsePattern(kind);
    }

    private boolean peekPattern(PatternKind kind, EnumSet<TokenType> follow) {
        if (!this.peekPatternStart()) {
            return false;
        }
        Parser p = this.createLookaheadParser();
        p.parsePattern(kind);
        return !p.errorReporter.hadError() && follow.contains((Object)p.peekType());
    }

    private boolean peekParenPattern(PatternKind kind, EnumSet<TokenType> follow) {
        if (!this.peekParenPatternStart()) {
            return false;
        }
        Parser p = this.createLookaheadParser();
        p.parsePattern(kind);
        return !p.errorReporter.hadError() && follow.contains((Object)p.peekType());
    }

    private ParseTree parsePattern(PatternKind kind) {
        switch (this.peekType()) {
            case OPEN_SQUARE: {
                return this.parseArrayPattern(kind);
            }
        }
        return this.parseObjectPattern(kind);
    }

    private boolean peekPatternElement() {
        return this.peekExpression() || this.peek(TokenType.SPREAD);
    }

    private ParseTree parsePatternElement(PatternKind kind, EnumSet<TokenType> follow) {
        if (this.peekParenPattern(kind, follow)) {
            return this.parseParenPattern(kind);
        }
        boolean spread = false;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peek(TokenType.SPREAD)) {
            this.eat(TokenType.SPREAD);
            spread = true;
        }
        ParseTree lvalue = this.parseLeftHandSideExpression();
        if (kind == PatternKind.INITIALIZER && lvalue.type != ParseTreeType.IDENTIFIER_EXPRESSION) {
            this.reportError("lvalues in initializer patterns must be identifiers", new Object[0]);
        }
        return spread ? new SpreadPatternElementTree(this.getTreeLocation(start), lvalue) : lvalue;
    }

    private ParseTree parseArrayPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        while (this.peek(TokenType.COMMA) || this.peekPatternElement()) {
            if (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                elements.add((Object)NullTree.Instance);
                continue;
            }
            ParseTree element = this.parsePatternElement(kind, arraySubPatternFollowSet);
            elements.add((Object)element);
            if (element.isSpreadPatternElement() || !this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_SQUARE);
        return new ArrayPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder fields = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekObjectPatternField(kind)) {
            fields.add((Object)this.parseObjectPatternField(kind));
            if (!this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return new ObjectPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)fields.build());
    }

    private boolean peekObjectPatternField(PatternKind kind) {
        return this.peek(TokenType.IDENTIFIER);
    }

    private ParseTree parseObjectPatternField(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken identifier = this.eatId();
        ParseTree element = null;
        if (this.peek(TokenType.COLON)) {
            this.eat(TokenType.COLON);
            element = this.parsePatternElement(kind, objectSubPatternFollowSet);
            if (element.isSpreadPatternElement()) {
                this.reportError("Rest can not be used in object patterns", new Object[0]);
            }
        }
        return new ObjectPatternFieldTree(this.getTreeLocation(start), identifier, element);
    }

    private void eatPossibleImplicitSemiColon() {
        if (this.peek(TokenType.SEMI_COLON) && this.peekToken().location.start.line == this.getLastLine()) {
            this.eat(TokenType.SEMI_COLON);
            return;
        }
        if (this.peekImplicitSemiColon()) {
            return;
        }
        this.reportError("Semi-colon expected", new Object[0]);
    }

    private boolean peekImplicitSemiColon() {
        return this.getNextLine() > this.getLastLine() || this.peek(TokenType.SEMI_COLON) || this.peek(TokenType.CLOSE_CURLY);
    }

    private int getLastLine() {
        return this.lastToken.location.end.line;
    }

    private int getNextLine() {
        return this.peekToken().location.start.line;
    }

    private Token eatOpt(TokenType expectedTokenType) {
        if (this.peek(expectedTokenType)) {
            return this.eat(expectedTokenType);
        }
        return null;
    }

    private IdentifierToken eatIdOpt() {
        return this.peek(TokenType.IDENTIFIER) ? this.eatId() : null;
    }

    private IdentifierToken eatId() {
        Token result = this.eat(TokenType.IDENTIFIER);
        return (IdentifierToken)result;
    }

    private Token eat(TokenType expectedTokenType) {
        Token token = this.nextToken();
        if (token.type != expectedTokenType) {
            this.reportExpectedError(token, (Object)expectedTokenType);
            return null;
        }
        return token;
    }

    private void reportExpectedError(Token token, Object expected) {
        this.reportError(token, "'%s' expected", expected);
    }

    private SourcePosition getTreeStartLocation() {
        return this.peekToken().location.start;
    }

    private SourcePosition getTreeEndLocation() {
        return this.lastToken.location.end;
    }

    private SourceRange getTreeLocation(SourcePosition start) {
        return new SourceRange(start, this.getTreeEndLocation());
    }

    private Token nextToken() {
        this.lastToken = this.scanner.nextToken();
        return this.lastToken;
    }

    private LiteralToken nextRegularExpressionLiteralToken() {
        LiteralToken lastToken = this.scanner.nextRegularExpressionLiteralToken();
        this.lastToken = lastToken;
        return lastToken;
    }

    private boolean peek(TokenType expectedType) {
        return this.peek(0, expectedType);
    }

    private boolean peek(int index, TokenType expectedType) {
        return this.peekType(index) == expectedType;
    }

    private TokenType peekType() {
        return this.peekType(0);
    }

    private TokenType peekType(int index) {
        return this.peekToken((int)index).type;
    }

    private Token peekToken() {
        return this.peekToken(0);
    }

    private Token peekToken(int index) {
        return this.scanner.peekToken(index);
    }

    private Parser createLookaheadParser() {
        return new Parser(new MutedErrorReporter(), this.scanner.getFile(), this.scanner.getOffset());
    }

    private void reportError(Token token, String message, Object ... arguments) {
        if (token == null) {
            this.reportError(message, arguments);
        } else {
            this.errorReporter.reportError(token.getStart(), message, arguments);
        }
    }

    private void reportError(String message, Object ... arguments) {
        this.errorReporter.reportError(this.scanner.getPosition(), message, arguments);
    }

    private static enum Expression {
        NO_IN,
        NORMAL;

    }

    private static enum PatternKind {
        INITIALIZER,
        ANY;

    }
}

