/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser;

import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.Keywords;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.LineNumberTable;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.SourceFile;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.Token;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.TokenType;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourceRange;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.util.LinkedList;

public class Scanner {
    private final ErrorReporter errorReporter;
    private final SourceFile source;
    private final LinkedList<Token> currentTokens = new LinkedList();
    private int index;

    public Scanner(ErrorReporter errorReporter, SourceFile source) {
        this(errorReporter, source, 0);
    }

    public Scanner(ErrorReporter errorReporter, SourceFile file, int offset) {
        this.errorReporter = errorReporter;
        this.source = file;
        this.index = offset;
    }

    private LineNumberTable getLineNumberTable() {
        return this.getFile().lineNumberTable;
    }

    public SourceFile getFile() {
        return this.source;
    }

    public int getOffset() {
        return this.currentTokens.isEmpty() ? this.index : this.peekToken().location.start.offset;
    }

    public SourcePosition getPosition() {
        return this.getPosition(this.getOffset());
    }

    private SourcePosition getPosition(int offset) {
        return this.getLineNumberTable().getSourcePosition(offset);
    }

    private SourceRange getTokenRange(int startOffset) {
        return this.getLineNumberTable().getSourceRange(startOffset, this.index);
    }

    public Token nextToken() {
        this.peekToken();
        return this.currentTokens.remove();
    }

    private void clearTokenLookahead() {
        this.index = this.getOffset();
        this.currentTokens.clear();
    }

    public LiteralToken nextRegularExpressionLiteralToken() {
        this.clearTokenLookahead();
        int beginToken = this.index;
        this.nextChar();
        if (!this.skipRegularExpressionBody()) {
            return new LiteralToken(TokenType.REGULAR_EXPRESSION, this.getTokenString(beginToken), this.getTokenRange(beginToken));
        }
        if (this.peekChar() != '/') {
            this.reportError("Expected '/' in regular expression literal", new Object[0]);
            return new LiteralToken(TokenType.REGULAR_EXPRESSION, this.getTokenString(beginToken), this.getTokenRange(beginToken));
        }
        this.nextChar();
        while (this.isIdentifierPart(this.peekChar())) {
            this.nextChar();
        }
        return new LiteralToken(TokenType.REGULAR_EXPRESSION, this.getTokenString(beginToken), this.getTokenRange(beginToken));
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipRegularExpressionBody() {
        if (!this.isRegularExpressionFirstChar(this.peekChar())) {
            this.reportError("Expected regular expression first char", new Object[0]);
            return false;
        }
        if (this.skipRegularExpressionChar()) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.skipRegularExpressionChar()) continue;
            return false;
lbl8:
            // 2 sources

            ** while (this.isRegularExpressionChar((char)this.peekChar()))
        }
lbl9:
        // 1 sources

        return true;
    }

    private boolean skipRegularExpressionChar() {
        switch (this.peekChar()) {
            case '\\': {
                return this.skipRegularExpressionBackslashSequence();
            }
            case '[': {
                return this.skipRegularExpressionClass();
            }
        }
        this.nextChar();
        return true;
    }

    private boolean skipRegularExpressionBackslashSequence() {
        this.nextChar();
        if (Scanner.isLineTerminator(this.peekChar())) {
            this.reportError("New line not allowed in regular expression literal", new Object[0]);
            return false;
        }
        this.nextChar();
        return true;
    }

    private boolean skipRegularExpressionClass() {
        this.nextChar();
        while (!this.isAtEnd() && this.peekRegularExpressionClassChar()) {
            if (this.skipRegularExpressionClassChar()) continue;
            return false;
        }
        if (this.peekChar() != ']') {
            this.reportError("']' expected", new Object[0]);
            return false;
        }
        this.nextChar();
        return true;
    }

    private boolean peekRegularExpressionClassChar() {
        return this.peekChar() != ']' && !Scanner.isLineTerminator(this.peekChar());
    }

    private boolean skipRegularExpressionClassChar() {
        if (this.peek('\\')) {
            return this.skipRegularExpressionBackslashSequence();
        }
        this.nextChar();
        return true;
    }

    private boolean isRegularExpressionFirstChar(char ch) {
        return this.isRegularExpressionChar(ch) && ch != '*';
    }

    private boolean isRegularExpressionChar(char ch) {
        switch (ch) {
            case '/': {
                return false;
            }
            case '[': 
            case '\\': {
                return true;
            }
        }
        return !Scanner.isLineTerminator(ch);
    }

    public Token peekToken() {
        return this.peekToken(0);
    }

    public Token peekToken(int index) {
        while (this.currentTokens.size() <= index) {
            this.currentTokens.add(this.scanToken());
        }
        return this.currentTokens.get(index);
    }

    private boolean isAtEnd() {
        return !this.isValidIndex(this.index);
    }

    private boolean isValidIndex(int index) {
        return index >= 0 && index < this.source.contents.length();
    }

    private void skipWhitespace() {
        while (!this.isAtEnd() && this.peekWhitespace()) {
            this.nextChar();
        }
    }

    private boolean peekWhitespace() {
        return Scanner.isWhitespace(this.peekChar());
    }

    private static boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u00a0': 
            case '\u2028': 
            case '\u2029': 
            case '\ufeff': {
                return true;
            }
        }
        return false;
    }

    private static boolean isLineTerminator(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private void skipComments() {
        while (this.skipComment()) {
        }
    }

    private boolean skipComment() {
        this.skipWhitespace();
        if (!this.isAtEnd() && this.peek('/')) {
            switch (this.peekChar(1)) {
                case '/': {
                    this.skipSingleLineComment();
                    return true;
                }
                case '*': {
                    this.skipMultiLineComment();
                    return true;
                }
            }
        }
        return false;
    }

    private void skipSingleLineComment() {
        while (!this.isAtEnd() && !Scanner.isLineTerminator(this.peekChar())) {
            this.nextChar();
        }
    }

    private void skipMultiLineComment() {
        this.nextChar();
        this.nextChar();
        while (!(this.isAtEnd() || this.peekChar() == '*' && this.peekChar(1) == '/')) {
            this.nextChar();
        }
        this.nextChar();
        this.nextChar();
    }

    private Token scanToken() {
        this.skipComments();
        int beginToken = this.index;
        if (this.isAtEnd()) {
            return this.createToken(TokenType.END_OF_FILE, beginToken);
        }
        char ch = this.nextChar();
        switch (ch) {
            case '{': {
                return this.createToken(TokenType.OPEN_CURLY, beginToken);
            }
            case '}': {
                return this.createToken(TokenType.CLOSE_CURLY, beginToken);
            }
            case '(': {
                return this.createToken(TokenType.OPEN_PAREN, beginToken);
            }
            case ')': {
                return this.createToken(TokenType.CLOSE_PAREN, beginToken);
            }
            case '[': {
                return this.createToken(TokenType.OPEN_SQUARE, beginToken);
            }
            case ']': {
                return this.createToken(TokenType.CLOSE_SQUARE, beginToken);
            }
            case '.': {
                if (Scanner.isDecimalDigit(this.peekChar())) {
                    return this.scanNumberPostPeriod(beginToken);
                }
                if (this.peek('.') && this.peekChar(1) == '.') {
                    this.nextChar();
                    this.nextChar();
                    return this.createToken(TokenType.SPREAD, beginToken);
                }
                return this.createToken(TokenType.PERIOD, beginToken);
            }
            case ';': {
                return this.createToken(TokenType.SEMI_COLON, beginToken);
            }
            case ',': {
                return this.createToken(TokenType.COMMA, beginToken);
            }
            case '~': {
                return this.createToken(TokenType.TILDE, beginToken);
            }
            case '?': {
                return this.createToken(TokenType.QUESTION, beginToken);
            }
            case ':': {
                return this.createToken(TokenType.COLON, beginToken);
            }
            case '<': {
                switch (this.peekChar()) {
                    case '<': {
                        this.nextChar();
                        if (this.peek('=')) {
                            this.nextChar();
                            return this.createToken(TokenType.LEFT_SHIFT_EQUAL, beginToken);
                        }
                        return this.createToken(TokenType.LEFT_SHIFT, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.LESS_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.OPEN_ANGLE, beginToken);
            }
            case '>': {
                switch (this.peekChar()) {
                    case '>': {
                        this.nextChar();
                        switch (this.peekChar()) {
                            case '=': {
                                this.nextChar();
                                return this.createToken(TokenType.RIGHT_SHIFT_EQUAL, beginToken);
                            }
                            case '>': {
                                this.nextChar();
                                if (this.peek('=')) {
                                    this.nextChar();
                                    return this.createToken(TokenType.UNSIGNED_RIGHT_SHIFT_EQUAL, beginToken);
                                }
                                return this.createToken(TokenType.UNSIGNED_RIGHT_SHIFT, beginToken);
                            }
                        }
                        return this.createToken(TokenType.RIGHT_SHIFT, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.GREATER_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.CLOSE_ANGLE, beginToken);
            }
            case '=': {
                if (this.peek('=')) {
                    this.nextChar();
                    if (this.peek('=')) {
                        this.nextChar();
                        return this.createToken(TokenType.EQUAL_EQUAL_EQUAL, beginToken);
                    }
                    return this.createToken(TokenType.EQUAL_EQUAL, beginToken);
                }
                return this.createToken(TokenType.EQUAL, beginToken);
            }
            case '!': {
                if (this.peek('=')) {
                    this.nextChar();
                    if (this.peek('=')) {
                        this.nextChar();
                        return this.createToken(TokenType.NOT_EQUAL_EQUAL, beginToken);
                    }
                    return this.createToken(TokenType.NOT_EQUAL, beginToken);
                }
                return this.createToken(TokenType.BANG, beginToken);
            }
            case '*': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.STAR_EQUAL, beginToken);
                }
                return this.createToken(TokenType.STAR, beginToken);
            }
            case '%': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.PERCENT_EQUAL, beginToken);
                }
                return this.createToken(TokenType.PERCENT, beginToken);
            }
            case '^': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.CARET_EQUAL, beginToken);
                }
                return this.createToken(TokenType.CARET, beginToken);
            }
            case '/': {
                if (this.peek('=')) {
                    this.nextChar();
                    return this.createToken(TokenType.SLASH_EQUAL, beginToken);
                }
                return this.createToken(TokenType.SLASH, beginToken);
            }
            case '+': {
                switch (this.peekChar()) {
                    case '+': {
                        this.nextChar();
                        return this.createToken(TokenType.PLUS_PLUS, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.PLUS_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.PLUS, beginToken);
            }
            case '-': {
                switch (this.peekChar()) {
                    case '-': {
                        this.nextChar();
                        return this.createToken(TokenType.MINUS_MINUS, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.MINUS_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.MINUS, beginToken);
            }
            case '&': {
                switch (this.peekChar()) {
                    case '&': {
                        this.nextChar();
                        return this.createToken(TokenType.AND, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.AMPERSAND_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.AMPERSAND, beginToken);
            }
            case '|': {
                switch (this.peekChar()) {
                    case '|': {
                        this.nextChar();
                        return this.createToken(TokenType.OR, beginToken);
                    }
                    case '=': {
                        this.nextChar();
                        return this.createToken(TokenType.BAR_EQUAL, beginToken);
                    }
                }
                return this.createToken(TokenType.BAR, beginToken);
            }
            case '#': {
                return this.createToken(TokenType.POUND, beginToken);
            }
            case '0': {
                return this.scanPostZero(beginToken);
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.scanPostDigit(beginToken);
            }
            case '\"': 
            case '\'': {
                return this.scanStringLiteral(beginToken, ch);
            }
        }
        return this.scanIdentifierOrKeyword(beginToken, ch);
    }

    private Token scanNumberPostPeriod(int beginToken) {
        this.skipDecimalDigits();
        return this.scanExponentOfNumericLiteral(beginToken);
    }

    private Token scanPostDigit(int beginToken) {
        this.skipDecimalDigits();
        return this.scanFractionalNumericLiteral(beginToken);
    }

    private Token scanPostZero(int beginToken) {
        switch (this.peekChar()) {
            case 'X': 
            case 'x': {
                this.nextChar();
                if (!Scanner.isHexDigit(this.peekChar())) {
                    this.reportError("Hex Integer Literal must contain at least one digit", new Object[0]);
                }
                this.skipHexDigits();
                return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
            }
            case '.': {
                return this.scanFractionalNumericLiteral(beginToken);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.scanPostDigit(beginToken);
            }
        }
        return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
    }

    private Token createToken(TokenType type, int beginToken) {
        return new Token(type, this.getTokenRange(beginToken));
    }

    /*
     * Unable to fully structure code
     */
    private Token scanIdentifierOrKeyword(int beginToken, char ch) {
        if (ch == '\\') {
            throw new RuntimeException(SimpleFormat.format("Unicode escape sequence at line %d", new Object[]{this.getPosition().line}));
        }
        if (this.isIdentifierStart(ch)) ** GOTO lbl8
        this.reportError(this.getPosition(beginToken), "Character code '%d' is not a valid identifier start char", new Object[]{(int)ch});
        return this.createToken(TokenType.ERROR, beginToken);
lbl-1000:
        // 1 sources

        {
            this.nextChar();
lbl8:
            // 2 sources

            ** while (this.isIdentifierPart((char)this.peekChar()))
        }
lbl9:
        // 1 sources

        if (ch == '\\') {
            throw new RuntimeException(SimpleFormat.format("Unicode escape sequence at line %d", new Object[]{this.getPosition().line}));
        }
        value = this.source.contents.substring(beginToken, this.index);
        if (Keywords.isKeyword(value)) {
            return new Token(Keywords.getTokenType(value), this.getTokenRange(beginToken));
        }
        return new IdentifierToken(this.getTokenRange(beginToken), value);
    }

    private boolean isIdentifierStart(char ch) {
        switch (ch) {
            case '$': 
            case '_': {
                return true;
            }
        }
        return Character.isLetter(ch);
    }

    private boolean isIdentifierPart(char ch) {
        return this.isIdentifierStart(ch) || Character.isDigit(ch);
    }

    private Token scanStringLiteral(int beginIndex, char terminator) {
        while (this.peekStringLiteralChar(terminator)) {
            if (this.skipStringLiteralChar()) continue;
            return new LiteralToken(TokenType.STRING, this.getTokenString(beginIndex), this.getTokenRange(beginIndex));
        }
        if (this.peekChar() != terminator) {
            this.reportError(this.getPosition(beginIndex), "Unterminated String Literal", new Object[0]);
        } else {
            this.nextChar();
        }
        return new LiteralToken(TokenType.STRING, this.getTokenString(beginIndex), this.getTokenRange(beginIndex));
    }

    private String getTokenString(int beginIndex) {
        return this.source.contents.substring(beginIndex, this.index);
    }

    private boolean peekStringLiteralChar(char terminator) {
        return !this.isAtEnd() && this.peekChar() != terminator && !Scanner.isLineTerminator(this.peekChar());
    }

    private boolean skipStringLiteralChar() {
        if (this.peek('\\')) {
            return this.skipStringLiteralEscapeSequence();
        }
        this.nextChar();
        return true;
    }

    private boolean skipStringLiteralEscapeSequence() {
        this.nextChar();
        if (this.isAtEnd()) {
            this.reportError("Unterminated string literal escape sequence", new Object[0]);
            return false;
        }
        if (Scanner.isLineTerminator(this.peekChar())) {
            this.skipLineTerminator();
            return true;
        }
        switch (this.nextChar()) {
            case '\"': 
            case '\'': 
            case '0': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                return true;
            }
            case 'x': {
                return this.skipHexDigit() && this.skipHexDigit();
            }
            case 'u': {
                return this.skipHexDigit() && this.skipHexDigit() && this.skipHexDigit() && this.skipHexDigit();
            }
        }
        return true;
    }

    private boolean skipHexDigit() {
        if (!Scanner.isHexDigit(this.peekChar())) {
            this.reportError("Hex digit expected", new Object[0]);
            return false;
        }
        this.nextChar();
        return true;
    }

    private void skipLineTerminator() {
        char first = this.nextChar();
        if (first == '\r' && this.peek('\n')) {
            this.nextChar();
        }
    }

    private LiteralToken scanFractionalNumericLiteral(int beginToken) {
        if (this.peek('.')) {
            this.nextChar();
            this.skipDecimalDigits();
        }
        return this.scanExponentOfNumericLiteral(beginToken);
    }

    private LiteralToken scanExponentOfNumericLiteral(int beginToken) {
        switch (this.peekChar()) {
            case 'E': 
            case 'e': {
                this.nextChar();
                switch (this.peekChar()) {
                    case '+': 
                    case '-': {
                        this.nextChar();
                    }
                }
                if (!Scanner.isDecimalDigit(this.peekChar())) {
                    this.reportError("Exponent part must contain at least one digit", new Object[0]);
                }
                this.skipDecimalDigits();
                break;
            }
        }
        return new LiteralToken(TokenType.NUMBER, this.getTokenString(beginToken), this.getTokenRange(beginToken));
    }

    private void skipDecimalDigits() {
        while (Scanner.isDecimalDigit(this.peekChar())) {
            this.nextChar();
        }
    }

    private static boolean isDecimalDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private void skipHexDigits() {
        while (Scanner.isHexDigit(this.peekChar())) {
            this.nextChar();
        }
    }

    private static boolean isHexDigit(char ch) {
        return Scanner.valueOfHexDigit(ch) >= 0;
    }

    private static int valueOfHexDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return ch - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return ch - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return ch - 65 + 10;
            }
        }
        return -1;
    }

    private char nextChar() {
        if (this.isAtEnd()) {
            return '\u0000';
        }
        return this.source.contents.charAt(this.index++);
    }

    private boolean peek(char ch) {
        return this.peekChar() == ch;
    }

    private char peekChar() {
        return this.peekChar(0);
    }

    private char peekChar(int offset) {
        return !this.isValidIndex(this.index + offset) ? (char)'\u0000' : this.source.contents.charAt(this.index + offset);
    }

    private void reportError(String message, Object ... arguments) {
        this.reportError(this.getPosition(), message, arguments);
    }

    private void reportError(SourcePosition position, String format, Object ... arguments) {
        this.errorReporter.reportError(position, format, arguments);
    }
}

