/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.codegeneration;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.codegeneration.ParseTreeFactory;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.AwaitStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ClassExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FieldDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForEachStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportPathTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinResolveListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinResolveTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.MixinTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ModuleDefinitionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternFieldTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.RequiresMemberTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SpreadPatternElementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TraitDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.trees.YieldStatementTree;

public class ParseTreeTransformer {
    public ParseTree transformAny(ParseTree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.type) {
            case ARGUMENT_LIST: {
                return this.transform(tree.asArgumentList());
            }
            case ARRAY_LITERAL_EXPRESSION: {
                return this.transform(tree.asArrayLiteralExpression());
            }
            case ARRAY_PATTERN: {
                return this.transform(tree.asArrayPattern());
            }
            case AWAIT_STATEMENT: {
                return this.transform(tree.asAsyncStatement());
            }
            case BINARY_OPERATOR: {
                return this.transform(tree.asBinaryOperator());
            }
            case BLOCK: {
                return this.transform(tree.asBlock());
            }
            case BREAK_STATEMENT: {
                return this.transform(tree.asBreakStatement());
            }
            case CALL_EXPRESSION: {
                return this.transform(tree.asCallExpression());
            }
            case CASE_CLAUSE: {
                return this.transform(tree.asCaseClause());
            }
            case CATCH: {
                return this.transform(tree.asCatch());
            }
            case CLASS_DECLARATION: {
                return this.transform(tree.asClassDeclaration());
            }
            case CLASS_EXPRESSION: {
                return this.transform(tree.asClassExpression());
            }
            case COMMA_EXPRESSION: {
                return this.transform(tree.asCommaExpression());
            }
            case CONDITIONAL_EXPRESSION: {
                return this.transform(tree.asConditionalExpression());
            }
            case CONTINUE_STATEMENT: {
                return this.transform(tree.asContinueStatement());
            }
            case DEBUGGER_STATEMENT: {
                return this.transform(tree.asDebuggerStatement());
            }
            case DEFAULT_CLAUSE: {
                return this.transform(tree.asDefaultClause());
            }
            case DEFAULT_PARAMETER: {
                return this.transform(tree.asDefaultParameter());
            }
            case DO_WHILE_STATEMENT: {
                return this.transform(tree.asDoWhileStatement());
            }
            case EMPTY_STATEMENT: {
                return this.transform(tree.asEmptyStatement());
            }
            case EXPORT_DECLARATION: {
                return this.transform(tree.asExportDeclaration());
            }
            case EXPRESSION_STATEMENT: {
                return this.transform(tree.asExpressionStatement());
            }
            case FIELD_DECLARATION: {
                return this.transform(tree.asFieldDeclaration());
            }
            case FINALLY: {
                return this.transform(tree.asFinally());
            }
            case FOR_EACH_STATEMENT: {
                return this.transform(tree.asForEachStatement());
            }
            case FOR_IN_STATEMENT: {
                return this.transform(tree.asForInStatement());
            }
            case FOR_STATEMENT: {
                return this.transform(tree.asForStatement());
            }
            case FORMAL_PARAMETER_LIST: {
                return this.transform(tree.asFormalParameterList());
            }
            case FUNCTION_DECLARATION: {
                return this.transform(tree.asFunctionDeclaration());
            }
            case GET_ACCESSOR: {
                return this.transform(tree.asGetAccessor());
            }
            case IDENTIFIER_EXPRESSION: {
                return this.transform(tree.asIdentifierExpression());
            }
            case IF_STATEMENT: {
                return this.transform(tree.asIfStatement());
            }
            case IMPORT_DECLARATION: {
                return this.transform(tree.asImportDeclaration());
            }
            case IMPORT_PATH: {
                return this.transform(tree.asImportPath());
            }
            case IMPORT_SPECIFIER: {
                return this.transform(tree.asImportSpecifier());
            }
            case LABELLED_STATEMENT: {
                return this.transform(tree.asLabelledStatement());
            }
            case LITERAL_EXPRESSION: {
                return this.transform(tree.asLiteralExpression());
            }
            case MEMBER_EXPRESSION: {
                return this.transform(tree.asMemberExpression());
            }
            case MEMBER_LOOKUP_EXPRESSION: {
                return this.transform(tree.asMemberLookupExpression());
            }
            case MISSING_PRIMARY_EXPRESSION: {
                return this.transform(tree.asMissingPrimaryExpression());
            }
            case MIXIN: {
                return this.transform(tree.asMixin());
            }
            case MIXIN_RESOLVE: {
                return this.transform(tree.asMixinResolve());
            }
            case MIXIN_RESOLVE_LIST: {
                return this.transform(tree.asMixinResolveList());
            }
            case MODULE_DEFINITION: {
                return this.transform(tree.asModuleDefinition());
            }
            case NEW_EXPRESSION: {
                return this.transform(tree.asNewExpression());
            }
            case NULL: {
                return this.transform(tree.asNull());
            }
            case OBJECT_LITERAL_EXPRESSION: {
                return this.transform(tree.asObjectLiteralExpression());
            }
            case OBJECT_PATTERN: {
                return this.transform(tree.asObjectPattern());
            }
            case OBJECT_PATTERN_FIELD: {
                return this.transform(tree.asObjectPatternField());
            }
            case PAREN_EXPRESSION: {
                return this.transform(tree.asParenExpression());
            }
            case POSTFIX_EXPRESSION: {
                return this.transform(tree.asPostfixExpression());
            }
            case PROGRAM: {
                return this.transform(tree.asProgram());
            }
            case PROPERTY_NAME_ASSIGNMENT: {
                return this.transform(tree.asPropertyNameAssignment());
            }
            case REQUIRES_MEMBER: {
                return this.transform(tree.asRequiresMember());
            }
            case REST_PARAMETER: {
                return this.transform(tree.asRestParameter());
            }
            case RETURN_STATEMENT: {
                return this.transform(tree.asReturnStatement());
            }
            case SET_ACCESSOR: {
                return this.transform(tree.asSetAccessor());
            }
            case SPREAD_EXPRESSION: {
                return this.transform(tree.asSpreadExpression());
            }
            case SPREAD_PATTERN_ELEMENT: {
                return this.transform(tree.asSpreadPatternElement());
            }
            case SUPER_EXPRESSION: {
                return this.transform(tree.asSuperExpression());
            }
            case SWITCH_STATEMENT: {
                return this.transform(tree.asSwitchStatement());
            }
            case THIS_EXPRESSION: {
                return this.transform(tree.asThisExpression());
            }
            case THROW_STATEMENT: {
                return this.transform(tree.asThrowStatement());
            }
            case TRAIT_DECLARATION: {
                return this.transform(tree.asTraitDeclaration());
            }
            case TRY_STATEMENT: {
                return this.transform(tree.asTryStatement());
            }
            case UNARY_EXPRESSION: {
                return this.transform(tree.asUnaryExpression());
            }
            case VARIABLE_DECLARATION: {
                return this.transform(tree.asVariableDeclaration());
            }
            case VARIABLE_DECLARATION_LIST: {
                return this.transform(tree.asVariableDeclarationList());
            }
            case VARIABLE_STATEMENT: {
                return this.transform(tree.asVariableStatement());
            }
            case WHILE_STATEMENT: {
                return this.transform(tree.asWhileStatement());
            }
            case WITH_STATEMENT: {
                return this.transform(tree.asWithStatement());
            }
            case YIELD_STATEMENT: {
                return this.transform(tree.asYieldStatement());
            }
        }
        throw new RuntimeException("Should never get here!");
    }

    protected <E extends ParseTree> ImmutableList<E> transformList(ImmutableList<E> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ImmutableList.Builder builder = null;
        int index = 0;
        while (index < list.size()) {
            ParseTree element = (ParseTree)list.get(index);
            ParseTree transformed = this.transformAny(element);
            if (builder != null || element != transformed) {
                if (builder == null) {
                    builder = ImmutableList.builder();
                    builder.addAll((Iterable)list.subList(0, index));
                }
                builder.add((Object)transformed);
            }
            ++index;
        }
        return builder != null ? builder.build() : list;
    }

    protected final ParseTree toSourceElement(ParseTree tree) {
        return tree.isSourceElement() ? tree : ParseTreeFactory.createExpressionStatement(tree);
    }

    protected final ImmutableList<ParseTree> transformSourceElements(ImmutableList<ParseTree> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ImmutableList.Builder builder = null;
        int index = 0;
        while (index < list.size()) {
            ParseTree element = (ParseTree)list.get(index);
            ParseTree transformed = this.toSourceElement(this.transformAny(element));
            if (builder != null || element != transformed) {
                if (builder == null) {
                    builder = ImmutableList.builder();
                    builder.addAll((Iterable)list.subList(0, index));
                }
                builder.add((Object)transformed);
            }
            ++index;
        }
        return builder != null ? builder.build() : list;
    }

    protected ParseTree transform(ArgumentListTree tree) {
        ImmutableList<ParseTree> arguments = this.transformList(tree.arguments);
        if (arguments == tree.arguments) {
            return tree;
        }
        return ParseTreeFactory.createArgumentList(arguments);
    }

    protected ParseTree transform(ArrayLiteralExpressionTree tree) {
        ImmutableList<ParseTree> elements = this.transformList(tree.elements);
        if (elements == tree.elements) {
            return tree;
        }
        return ParseTreeFactory.createArrayLiteralExpression(elements);
    }

    protected ParseTree transform(ArrayPatternTree tree) {
        ImmutableList<ParseTree> elements = this.transformList(tree.elements);
        if (elements == tree.elements) {
            return tree;
        }
        return ParseTreeFactory.createArrayPattern(elements);
    }

    protected ParseTree transform(AwaitStatementTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        if (tree.expression == expression) {
            return tree;
        }
        return new AwaitStatementTree(null, tree.identifier, expression);
    }

    protected ParseTree transform(BinaryOperatorTree tree) {
        ParseTree left = this.transformAny(tree.left);
        ParseTree right = this.transformAny(tree.right);
        if (left == tree.left && right == tree.right) {
            return tree;
        }
        return ParseTreeFactory.createBinaryOperator(left, tree.operator, right);
    }

    protected ParseTree transform(BlockTree tree) {
        ImmutableList<ParseTree> elements = this.transformList(tree.statements);
        if (elements == tree.statements) {
            return tree;
        }
        return ParseTreeFactory.createBlock(elements);
    }

    protected ParseTree transform(BreakStatementTree tree) {
        return tree;
    }

    protected ParseTree transform(CallExpressionTree tree) {
        ParseTree operand = this.transformAny(tree.operand);
        ArgumentListTree arguments = this.transformAny(tree.arguments).asArgumentList();
        if (operand == tree.operand && arguments == tree.arguments) {
            return tree;
        }
        return ParseTreeFactory.createCallExpression(operand, arguments);
    }

    protected ParseTree transform(CaseClauseTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        ImmutableList<ParseTree> statements = this.transformList(tree.statements);
        if (expression == tree.expression && statements == tree.statements) {
            return tree;
        }
        return ParseTreeFactory.createCaseClause(expression, statements);
    }

    protected ParseTree transform(CatchTree tree) {
        ParseTree catchBody = this.transformAny(tree.catchBody);
        if (catchBody == tree.catchBody) {
            return tree;
        }
        return ParseTreeFactory.createCatch(tree.exceptionName, catchBody);
    }

    protected ParseTree transform(ClassDeclarationTree tree) {
        ParseTree superClass = this.transformAny(tree.superClass);
        ImmutableList<ParseTree> elements = this.transformList(tree.elements);
        if (superClass == tree.superClass && elements == tree.elements) {
            return tree;
        }
        return ParseTreeFactory.createClassDeclaration(tree.name, superClass, elements);
    }

    protected ParseTree transform(ClassExpressionTree tree) {
        return tree;
    }

    protected ParseTree transform(CommaExpressionTree tree) {
        ImmutableList<ParseTree> expressions = this.transformList(tree.expressions);
        if (expressions == tree.expressions) {
            return tree;
        }
        return ParseTreeFactory.createCommaExpression(expressions);
    }

    protected ParseTree transform(ConditionalExpressionTree tree) {
        ParseTree condition = this.transformAny(tree.condition);
        ParseTree left = this.transformAny(tree.left);
        ParseTree right = this.transformAny(tree.right);
        if (condition == tree.condition && left == tree.left && right == tree.right) {
            return tree;
        }
        return ParseTreeFactory.createConditionalExpression(condition, left, right);
    }

    protected ParseTree transform(ContinueStatementTree tree) {
        return tree;
    }

    protected ParseTree transform(DebuggerStatementTree tree) {
        return tree;
    }

    protected ParseTree transform(DefaultClauseTree tree) {
        ImmutableList<ParseTree> statements = this.transformList(tree.statements);
        if (statements == tree.statements) {
            return tree;
        }
        return ParseTreeFactory.createDefaultClause(statements);
    }

    protected ParseTree transform(DefaultParameterTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        if (expression == tree.expression) {
            return tree;
        }
        return ParseTreeFactory.createDefaultParameter(tree.identifier, expression);
    }

    protected ParseTree transform(DoWhileStatementTree tree) {
        ParseTree body = this.transformAny(tree.body);
        ParseTree condition = this.transformAny(tree.condition);
        if (body == tree.body && condition == tree.condition) {
            return tree;
        }
        return ParseTreeFactory.createDoWhileStatement(body, condition);
    }

    protected ParseTree transform(EmptyStatementTree tree) {
        return tree;
    }

    protected ParseTree transform(ExportDeclarationTree tree) {
        ParseTree declaration = this.transformAny(tree.declaration);
        if (tree.declaration == declaration) {
            return tree;
        }
        return new ExportDeclarationTree(null, declaration);
    }

    protected ParseTree transform(ExpressionStatementTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        if (expression == tree.expression) {
            return tree;
        }
        return ParseTreeFactory.createExpressionStatement(expression);
    }

    protected ParseTree transform(FieldDeclarationTree tree) {
        ImmutableList<VariableDeclarationTree> declarations = this.transformList(tree.declarations);
        if (declarations == tree.declarations) {
            return tree;
        }
        return ParseTreeFactory.createFieldDeclaration(tree.isStatic, tree.isConst, declarations);
    }

    protected ParseTree transform(FinallyTree tree) {
        ParseTree block = this.transformAny(tree.block);
        if (block == tree.block) {
            return tree;
        }
        return ParseTreeFactory.createFinally(block);
    }

    protected ParseTree transform(ForEachStatementTree tree) {
        ParseTree initializer = this.transformAny(tree.initializer);
        ParseTree collection = this.transformAny(tree.collection);
        ParseTree body = this.transformAny(tree.body);
        if (initializer == tree.initializer && collection == tree.collection && body == tree.body) {
            return tree;
        }
        return ParseTreeFactory.createForEachStatement(initializer.asVariableDeclarationList(), collection, body);
    }

    protected ParseTree transform(ForInStatementTree tree) {
        ParseTree initializer = this.transformAny(tree.initializer);
        ParseTree collection = this.transformAny(tree.collection);
        ParseTree body = this.transformAny(tree.body);
        if (initializer == tree.initializer && collection == tree.collection && body == tree.body) {
            return tree;
        }
        return ParseTreeFactory.createForInStatement(initializer, collection, body);
    }

    protected ParseTree transform(ForStatementTree tree) {
        ParseTree initializer = this.transformAny(tree.initializer);
        ParseTree condition = this.transformAny(tree.condition);
        ParseTree increment = this.transformAny(tree.increment);
        ParseTree body = this.transformAny(tree.body);
        if (initializer == tree.initializer && condition == tree.condition && increment == tree.increment && body == tree.body) {
            return tree;
        }
        return ParseTreeFactory.createForStatement(initializer, condition, increment, body);
    }

    protected ParseTree transform(FormalParameterListTree tree) {
        return tree;
    }

    protected ParseTree transform(FunctionDeclarationTree tree) {
        FormalParameterListTree parameters = this.transformAny(tree.formalParameterList).asFormalParameterList();
        BlockTree functionBody = this.transformAny(tree.functionBody).asBlock();
        if (parameters == tree.formalParameterList && functionBody == tree.functionBody) {
            return tree;
        }
        return ParseTreeFactory.createFunctionDeclaration(tree.name, parameters, functionBody);
    }

    protected ParseTree transform(GetAccessorTree tree) {
        BlockTree body = this.transformAny(tree.body).asBlock();
        if (body == tree.body) {
            return tree;
        }
        return ParseTreeFactory.createGetAccessor(tree.propertyName, tree.isStatic, body);
    }

    protected ParseTree transform(IdentifierExpressionTree tree) {
        return tree;
    }

    protected ParseTree transform(IfStatementTree tree) {
        ParseTree condition = this.transformAny(tree.condition);
        ParseTree ifClause = this.transformAny(tree.ifClause);
        ParseTree elseClause = this.transformAny(tree.elseClause);
        if (condition == tree.condition && ifClause == tree.ifClause && elseClause == tree.elseClause) {
            return tree;
        }
        return ParseTreeFactory.createIfStatement(condition, ifClause, elseClause);
    }

    protected ParseTree transform(ImportDeclarationTree tree) {
        ImmutableList<ParseTree> importPathList = this.transformList(tree.importPathList);
        if (importPathList == tree.importPathList) {
            return tree;
        }
        return new ImportDeclarationTree(null, importPathList);
    }

    protected ParseTree transform(ImportPathTree tree) {
        ImmutableList<ParseTree> importSpecifierSet;
        if (tree.importSpecifierSet != null && (importSpecifierSet = this.transformList(tree.importSpecifierSet)) != tree.importSpecifierSet) {
            return new ImportPathTree(null, tree.qualifiedPath, importSpecifierSet);
        }
        return tree;
    }

    protected ParseTree transform(ImportSpecifierTree tree) {
        return tree;
    }

    protected ParseTree transform(LabelledStatementTree tree) {
        ParseTree statement = this.transformAny(tree.statement);
        if (statement == tree.statement) {
            return tree;
        }
        return ParseTreeFactory.createLabelledStatement(tree.name, statement);
    }

    protected ParseTree transform(LiteralExpressionTree tree) {
        return tree;
    }

    protected ParseTree transform(MemberExpressionTree tree) {
        ParseTree operand = this.transformAny(tree.operand);
        if (operand == tree.operand) {
            return tree;
        }
        return ParseTreeFactory.createMemberExpression(operand, tree.memberName);
    }

    protected ParseTree transform(MemberLookupExpressionTree tree) {
        ParseTree operand = this.transformAny(tree.operand);
        ParseTree memberExpression = this.transformAny(tree.memberExpression);
        if (operand == tree.operand && memberExpression == tree.memberExpression) {
            return tree;
        }
        return ParseTreeFactory.createMemberLookupExpression(operand, memberExpression);
    }

    protected ParseTree transform(MissingPrimaryExpressionTree tree) {
        throw new RuntimeException("Should never transform trees that had errors during parse");
    }

    protected ParseTree transform(MixinTree tree) {
        MixinResolveListTree mixinResolves = (MixinResolveListTree)this.transformAny(tree.mixinResolves);
        if (mixinResolves == tree.mixinResolves) {
            return tree;
        }
        return ParseTreeFactory.createMixin(tree.name, mixinResolves);
    }

    protected ParseTree transform(MixinResolveTree tree) {
        return tree;
    }

    protected ParseTree transform(MixinResolveListTree tree) {
        ImmutableList<ParseTree> resolves = this.transformList(tree.resolves);
        if (resolves == tree.resolves) {
            return tree;
        }
        return ParseTreeFactory.createMixinResolveList(resolves);
    }

    protected ParseTree transform(ModuleDefinitionTree tree) {
        ImmutableList<ParseTree> elements = this.transformList(tree.elements);
        if (elements == tree.elements) {
            return tree;
        }
        return new ModuleDefinitionTree(null, tree.name, elements);
    }

    protected ParseTree transform(NewExpressionTree tree) {
        ParseTree operand = this.transformAny(tree.operand);
        ArgumentListTree arguments = (ArgumentListTree)this.transformAny(tree.arguments);
        if (operand == tree.operand && arguments == tree.arguments) {
            return tree;
        }
        return ParseTreeFactory.createNewExpression(operand, arguments);
    }

    protected ParseTree transform(NullTree tree) {
        return tree;
    }

    protected ParseTree transform(ObjectLiteralExpressionTree tree) {
        ImmutableList<ParseTree> propertyNameAndValues = this.transformList(tree.propertyNameAndValues);
        if (propertyNameAndValues == tree.propertyNameAndValues) {
            return tree;
        }
        return ParseTreeFactory.createObjectLiteralExpression(propertyNameAndValues);
    }

    protected ParseTree transform(ObjectPatternTree tree) {
        ImmutableList<ParseTree> fields = this.transformList(tree.fields);
        if (fields == tree.fields) {
            return tree;
        }
        return ParseTreeFactory.createObjectPattern(fields);
    }

    protected ParseTree transform(ObjectPatternFieldTree tree) {
        ParseTree element = this.transformAny(tree.element);
        if (element == tree.element) {
            return tree;
        }
        return ParseTreeFactory.createObjectPatternField(tree.identifier, element);
    }

    protected ParseTree transform(ParenExpressionTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        if (expression == tree.expression) {
            return tree;
        }
        return ParseTreeFactory.createParenExpression(expression);
    }

    protected ParseTree transform(PostfixExpressionTree tree) {
        ParseTree operand = this.transformAny(tree.operand);
        if (operand == tree.operand) {
            return tree;
        }
        return ParseTreeFactory.createPostfixExpression(operand, tree.operator);
    }

    protected ParseTree transform(ProgramTree tree) {
        ImmutableList<ParseTree> elements = this.transformList(tree.sourceElements);
        if (elements == tree.sourceElements) {
            return tree;
        }
        return new ProgramTree(null, elements);
    }

    protected ParseTree transform(PropertyNameAssignmentTree tree) {
        ParseTree value = this.transformAny(tree.value);
        if (value == tree.value) {
            return tree;
        }
        return ParseTreeFactory.createPropertyNameAssignment(tree.name, value);
    }

    protected ParseTree transform(RequiresMemberTree tree) {
        return tree;
    }

    protected ParseTree transform(RestParameterTree tree) {
        return tree;
    }

    protected ParseTree transform(ReturnStatementTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        if (expression == tree.expression) {
            return tree;
        }
        return ParseTreeFactory.createReturnStatement(expression);
    }

    protected ParseTree transform(SetAccessorTree tree) {
        BlockTree body = this.transformAny(tree.body).asBlock();
        if (body == tree.body) {
            return tree;
        }
        return ParseTreeFactory.createSetAccessor(tree.propertyName, tree.isStatic, tree.parameter, body);
    }

    protected ParseTree transform(SpreadExpressionTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        if (expression == tree.expression) {
            return tree;
        }
        return ParseTreeFactory.createSpreadExpression(expression);
    }

    protected ParseTree transform(SpreadPatternElementTree tree) {
        ParseTree lvalue = this.transformAny(tree.lvalue);
        if (lvalue == tree.lvalue) {
            return tree;
        }
        return ParseTreeFactory.createSpreadPatternElement(lvalue);
    }

    protected ParseTree transform(SuperExpressionTree tree) {
        return tree;
    }

    protected ParseTree transform(SwitchStatementTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        ImmutableList<ParseTree> caseClauses = this.transformList(tree.caseClauses);
        if (expression == tree.expression && caseClauses == tree.caseClauses) {
            return tree;
        }
        return ParseTreeFactory.createSwitchStatement(expression, caseClauses);
    }

    protected ParseTree transform(ThisExpressionTree tree) {
        return tree;
    }

    protected ParseTree transform(ThrowStatementTree tree) {
        ParseTree value = this.transformAny(tree.value);
        if (value == tree.value) {
            return tree;
        }
        return ParseTreeFactory.createThrowStatement(value);
    }

    protected ParseTree transform(TraitDeclarationTree tree) {
        ImmutableList<ParseTree> elements = this.transformList(tree.elements);
        if (elements == tree.elements) {
            return tree;
        }
        return ParseTreeFactory.createTraitDeclaration(tree.name, elements);
    }

    protected ParseTree transform(TryStatementTree tree) {
        ParseTree body = this.transformAny(tree.body);
        ParseTree catchBlock = this.transformAny(tree.catchBlock);
        ParseTree finallyBlock = this.transformAny(tree.finallyBlock);
        if (body == tree.body && catchBlock == tree.catchBlock && finallyBlock == tree.finallyBlock) {
            return tree;
        }
        return ParseTreeFactory.createTryStatement(body, catchBlock, finallyBlock);
    }

    protected ParseTree transform(UnaryExpressionTree tree) {
        ParseTree operand = this.transformAny(tree.operand);
        if (operand == tree.operand) {
            return tree;
        }
        return ParseTreeFactory.createUnaryExpression(tree.operator, operand);
    }

    protected ParseTree transform(VariableDeclarationTree tree) {
        ParseTree lvalue = this.transformAny(tree.lvalue);
        ParseTree initializer = this.transformAny(tree.initializer);
        if (lvalue == tree.lvalue && initializer == tree.initializer) {
            return tree;
        }
        return ParseTreeFactory.createVariableDeclaration(lvalue, initializer);
    }

    protected ParseTree transform(VariableDeclarationListTree tree) {
        ImmutableList<VariableDeclarationTree> declarations = this.transformList(tree.declarations);
        if (declarations == tree.declarations) {
            return tree;
        }
        return ParseTreeFactory.createVariableDeclarationList(tree.declarationType, declarations);
    }

    protected ParseTree transform(VariableStatementTree tree) {
        VariableDeclarationListTree declarations = this.transformAny(tree.declarations).asVariableDeclarationList();
        if (declarations == tree.declarations) {
            return tree;
        }
        return ParseTreeFactory.createVariableStatement(declarations);
    }

    protected ParseTree transform(WhileStatementTree tree) {
        ParseTree condition = this.transformAny(tree.condition);
        ParseTree body = this.transformAny(tree.body);
        if (condition == tree.condition && body == tree.body) {
            return tree;
        }
        return ParseTreeFactory.createWhileStatement(condition, body);
    }

    protected ParseTree transform(WithStatementTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        ParseTree body = this.transformAny(tree.body);
        if (expression == tree.expression && body == tree.body) {
            return tree;
        }
        return ParseTreeFactory.createWithStatement(expression, body);
    }

    protected ParseTree transform(YieldStatementTree tree) {
        ParseTree expression = this.transformAny(tree.expression);
        if (expression == tree.expression) {
            return tree;
        }
        return ParseTreeFactory.createYieldStatement(expression);
    }
}

