/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util;

import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.gwt.thirdparty.javascript.jscomp.parsing.parser.util.format.SimpleFormat;

public abstract class ErrorReporter {
    private boolean hadError;

    public final void reportError(SourcePosition location, String format, Object ... arguments) {
        this.hadError = true;
        this.reportMessage(location, "Error", format, arguments);
    }

    public final void reportWarning(SourcePosition location, String format, Object ... arguments) {
        this.reportMessage(location, "Warning", format, arguments);
    }

    protected void reportMessage(SourcePosition location, String kind, String format, Object ... arguments) {
        String message = SimpleFormat.format("%s: %s", kind, SimpleFormat.format(format, arguments));
        if (location != null) {
            message = SimpleFormat.format("%s: %s", location, message);
        }
        this.reportMessage(location, message);
    }

    protected abstract void reportMessage(SourcePosition var1, String var2);

    public final boolean hadError() {
        return this.hadError;
    }

    public final void clearError() {
        this.hadError = false;
    }
}

