/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.testing;

import com.google.gwt.thirdparty.javascript.rhino.head.ErrorReporter;
import com.google.gwt.thirdparty.javascript.rhino.head.EvaluatorException;
import junit.framework.Assert;

public final class TestErrorReporter
extends Assert
implements ErrorReporter {
    private final String[] errors;
    private final String[] warnings;
    private int errorsIndex = 0;
    private int warningsIndex = 0;

    public TestErrorReporter(String[] errors, String[] warnings) {
        this.errors = errors;
        this.warnings = warnings;
    }

    @Override
    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.errors != null && this.errorsIndex < this.errors.length) {
            TestErrorReporter.assertEquals((String)this.errors[this.errorsIndex++], (String)message);
        } else {
            TestErrorReporter.fail((String)("extra error: " + message));
        }
    }

    @Override
    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.warnings != null && this.warningsIndex < this.warnings.length) {
            TestErrorReporter.assertEquals((String)this.warnings[this.warningsIndex++], (String)message);
        } else {
            TestErrorReporter.fail((String)("extra warning: " + message));
        }
    }

    @Override
    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        return new EvaluatorException("JSCompiler test code: " + message);
    }

    public boolean hasEncounteredAllWarnings() {
        return this.warnings == null ? this.warningsIndex == 0 : this.warnings.length == this.warningsIndex;
    }

    public boolean hasEncounteredAllErrors() {
        return this.errors == null ? this.errorsIndex == 0 : this.errors.length == this.errorsIndex;
    }
}

