/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.webservice.common;

import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class Protocol {
    public static final String MAX_INPUT_SIZE_KEY = "com.google.gwt.thirdparty.javascript.jscomp.webservice.maximumInputSize";
    public static final int FALLBACK_MAX_INPUT_SIZE = 512000;
    private static int maxInputSize;

    static {
        Protocol.resetMaximumInputSize();
    }

    private Protocol() {
    }

    public static final int maximumInputSize() {
        return maxInputSize;
    }

    public static final void resetMaximumInputSize() {
        String maxInputSizeStr = System.getProperty(MAX_INPUT_SIZE_KEY);
        maxInputSize = maxInputSizeStr == null ? 512000 : Integer.parseInt(maxInputSizeStr);
    }

    public static enum ApiKeyResponse implements ProtocolEnum
    {
        API_KEY("api_key");

        private final String responseParam;

        private ApiKeyResponse(String responseParam) {
            this.responseParam = responseParam;
        }

        public String getResponseParam() {
            return this.responseParam;
        }

        public String toString() {
            return this.getResponseParam();
        }

        @Override
        public String getValue() {
            return this.getResponseParam();
        }
    }

    public static enum CompilationLevelKey implements ProtocolEnum
    {
        WHITESPACE_ONLY("whitespace_only"),
        SIMPLE_OPTIMIZATIONS("simple_optimizations"),
        ADVANCED_OPTIMIZATIONS("advanced_optimizations");

        private final String value;

        private CompilationLevelKey(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum FormattingKey implements ProtocolEnum
    {
        PRETTY_PRINT("pretty_print"),
        PRINT_INPUT_DELIMITER("print_input_delimiter");

        private final String value;

        private FormattingKey(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum OutputFormatKey implements ProtocolEnum
    {
        TEXT("text"),
        XML("xml"),
        JSON("json");

        private final String value;

        private OutputFormatKey(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }

    public static enum OutputInfoKey implements ProtocolEnum
    {
        VARIABLE_MAP("variable_map"),
        COMPILED_CODE("compiled_code"),
        WARNINGS("warnings"),
        ERRORS("errors"),
        STATISTICS("statistics");

        private final String value;

        private OutputInfoKey(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static interface ProtocolEnum {
        public String getValue();
    }

    public static enum RequestKey implements ProtocolEnum
    {
        CODE_URL("code_url"),
        JS_CODE("js_code"),
        EXCLUDE_DEFAULT_EXTERNS("exclude_default_externs"),
        EXTERNS_URL("externs_url"),
        EXTERNS_CODE("js_externs"),
        COMPILATION_LEVEL("compilation_level"),
        OUTPUT_FORMAT("output_format"),
        OUTPUT_INFO("output_info"),
        OUTPUT_FILE_NAME("output_file_name"),
        OUTPUT_WRAPPER("output_wrapper"),
        API_KEY("api_key"),
        FORMATTING("formatting"),
        WARNING_LEVEL("warning_level"),
        USER_ID("uid"),
        USE_CLOSURE("use_closure_library"),
        BUILD_DEBUG("debug"),
        CHARSET("charset"),
        LANGUAGE("language"),
        USE_TYPES_FOR_OPTIMIZATIONS("use_types_for_optimization"),
        RAWJS("rawjs"),
        BASE("base"),
        MODE("mode"),
        SCRIPT("script"),
        NOCACHE("nocache");

        private static final Set<String> permittedKeys;
        private final String asGetParameter;

        static {
            permittedKeys = RequestKey.getPermittedKeys();
        }

        private static Set<String> getPermittedKeys() {
            HashSet keys = Sets.newHashSet();
            RequestKey[] requestKeyArray = RequestKey.values();
            int n = requestKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                RequestKey key = requestKeyArray[n2];
                keys.add(key.asGetParameter());
                ++n2;
            }
            return keys;
        }

        private RequestKey(String asGetParameter) {
            this.asGetParameter = asGetParameter;
        }

        public String asGetParameter() {
            return this.asGetParameter;
        }

        public String toString() {
            return this.asGetParameter;
        }

        public static boolean isKeyValid(String key) {
            return permittedKeys.contains(key.toLowerCase());
        }

        @Override
        public String getValue() {
            return this.asGetParameter;
        }
    }

    public static enum ResponseTag implements ProtocolEnum
    {
        ROOT_TAG("compilationResult"),
        COMPILED_CODE_TAG("compiledCode"),
        WARNINGS_TAG("warnings"),
        WARNING_TAG("warning"),
        ERRORS_TAG("errors"),
        ERROR_TAG("error"),
        ERROR_LINE_NO_ATTR("lineno"),
        ERROR_LINE_ATTR("line"),
        ERROR_CHAR_ATTR("charno"),
        ERROR_FILE_ATTR("file"),
        ERROR_TYPE_ATTR("type"),
        STATS_TAG("statistics"),
        ORIGINAL_SIZE_TAG("originalSize"),
        ORIGINAL_GZIP_SIZE_TAG("originalGzipSize"),
        COMPRESSED_SIZE_TAG("compressedSize"),
        COMPRESSED_GZIP_SIZE_TAG("compressedGzipSize"),
        COMPILE_TIME_TAG("compileTime"),
        SERVER_ERRORS_TAG("serverErrors"),
        SERVER_ERROR_TAG("error"),
        SERVER_ERROR_CODE_ATTR("code"),
        VARIABLE_MAP("variableMap"),
        VARIABLE_MAP_ENTRY("variableMapEntry"),
        ORIGINAL_NAME_ATTR("originalName"),
        NEW_NAME_ATTR("newName"),
        OUTPUT_FILE_PATH("outputFilePath");

        private final String responseTag;

        private ResponseTag(String responseTag) {
            this.responseTag = responseTag;
        }

        public String getResponseTag() {
            return this.responseTag;
        }

        public String toString() {
            return this.getResponseTag();
        }

        @Override
        public String getValue() {
            return this.getResponseTag();
        }
    }

    public static enum WarningLevelKey implements ProtocolEnum
    {
        QUIET("quiet"),
        DEFAULT("default"),
        VERBOSE("verbose");

        private final String value;

        private WarningLevelKey(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

