/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.jstype;

import com.google.gwt.thirdparty.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TernaryValue;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ValueType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.Visitor;

public class BooleanType
extends ValueType {
    private static final long serialVersionUID = 1L;

    BooleanType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isUnknownType() || that.isSubtype(this.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN)) || that.isObject()) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    @Override
    public boolean isBooleanValueType() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public JSType autoboxesTo() {
        return this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE);
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return "boolean";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseBooleanType();
    }
}

