/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.jstype;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.EnumElementType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionBuilder;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.NamedType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.NoType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ObjectType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ProxyObjectType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplateType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TemplatizedType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.UnionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.gwt.thirdparty.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Set;

public class ModificationVisitor
implements Visitor<JSType> {
    private final JSTypeRegistry registry;
    private final boolean visitProperties;
    private final Set<JSType> seenTypes = Sets.newIdentityHashSet();

    public ModificationVisitor(JSTypeRegistry registry, boolean visitProperties) {
        this.registry = registry;
        this.visitProperties = visitProperties;
    }

    @Override
    public JSType caseNoType(NoType type) {
        return type;
    }

    @Override
    public JSType caseEnumElementType(EnumElementType type) {
        return type;
    }

    @Override
    public JSType caseAllType() {
        return this.getNativeType(JSTypeNative.ALL_TYPE);
    }

    @Override
    public JSType caseBooleanType() {
        return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
    }

    @Override
    public JSType caseNoObjectType() {
        return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
    }

    @Override
    public JSType caseFunctionType(FunctionType type) {
        JSType afterReturn;
        JSType beforeReturn;
        JSType afterThis;
        if (this.isNativeFunctionType(type)) {
            return type;
        }
        if (!type.isOrdinaryFunction()) {
            return type;
        }
        boolean changed = false;
        JSType beforeThis = type.getTypeOfThis();
        if (beforeThis != (afterThis = this.coerseToThisType(beforeThis.visit(this)))) {
            changed = true;
        }
        if ((beforeReturn = type.getReturnType()) != (afterReturn = beforeReturn.visit(this))) {
            changed = true;
        }
        FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this.registry);
        for (Node paramNode : type.getParameters()) {
            JSType afterParamType;
            JSType beforeParamType = paramNode.getJSType();
            if (beforeParamType != (afterParamType = beforeParamType.visit(this))) {
                changed = true;
            }
            if (paramNode.isOptionalArg()) {
                paramBuilder.addOptionalParams(afterParamType);
                continue;
            }
            if (paramNode.isVarArgs()) {
                paramBuilder.addVarArgs(afterParamType);
                continue;
            }
            paramBuilder.addRequiredParams(afterParamType);
        }
        if (changed) {
            FunctionBuilder builder = new FunctionBuilder(this.registry);
            builder.withParams(paramBuilder);
            builder.withReturnType(afterReturn);
            builder.withTypeOfThis(afterThis);
            builder.withTemplateKeys(type.getTemplateTypeMap().getUnfilledTemplateKeys());
            return builder.build();
        }
        return type;
    }

    private JSType coerseToThisType(JSType type) {
        return type != null ? type : this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public JSType caseObjectType(ObjectType objType) {
        if (!this.visitProperties || objType.isNominalType() || objType instanceof ProxyObjectType || !objType.isRecordType()) {
            return objType;
        }
        if (this.seenTypes.contains(objType)) {
            return objType;
        }
        this.seenTypes.add(objType);
        boolean changed = false;
        RecordTypeBuilder builder = new RecordTypeBuilder(this.registry);
        for (String prop : objType.getOwnPropertyNames()) {
            JSType afterType;
            Node propertyNode = objType.getPropertyNode(prop);
            JSType beforeType = objType.getPropertyType(prop);
            if (beforeType != (afterType = beforeType.visit(this))) {
                changed = true;
            }
            builder.addProperty(prop, afterType, propertyNode);
        }
        this.seenTypes.remove(objType);
        if (changed) {
            return builder.build();
        }
        return objType;
    }

    @Override
    public JSType caseTemplatizedType(TemplatizedType type) {
        ObjectType afterBaseType;
        boolean changed = false;
        ObjectType beforeBaseType = type.getReferencedType();
        if (beforeBaseType != (afterBaseType = ObjectType.cast(beforeBaseType.visit(this)))) {
            changed = true;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSType beforeTemplateType : type.getTemplateTypes()) {
            JSType afterTemplateType;
            if (beforeTemplateType != (afterTemplateType = beforeTemplateType.visit(this))) {
                changed = true;
            }
            builder.add((Object)afterTemplateType);
        }
        if (changed) {
            type = this.registry.createTemplatizedType(afterBaseType, (ImmutableList<JSType>)builder.build());
        }
        return type;
    }

    @Override
    public JSType caseUnknownType() {
        return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public JSType caseNullType() {
        return this.getNativeType(JSTypeNative.NULL_TYPE);
    }

    @Override
    public JSType caseNumberType() {
        return this.getNativeType(JSTypeNative.NUMBER_TYPE);
    }

    @Override
    public JSType caseStringType() {
        return this.getNativeType(JSTypeNative.STRING_TYPE);
    }

    @Override
    public JSType caseVoidType() {
        return this.getNativeType(JSTypeNative.VOID_TYPE);
    }

    @Override
    public JSType caseUnionType(UnionType type) {
        boolean changed = false;
        ArrayList results = Lists.newArrayList();
        for (JSType alternative : type.getAlternates()) {
            JSType replacement = alternative.visit(this);
            if (replacement != alternative) {
                changed = true;
            }
            results.add(replacement);
        }
        if (changed) {
            UnionTypeBuilder builder = new UnionTypeBuilder(this.registry);
            for (JSType alternate : results) {
                builder.addAlternate(alternate);
            }
            return builder.build();
        }
        return type;
    }

    @Override
    public JSType caseTemplateType(TemplateType type) {
        return type;
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        return this.registry.getNativeType(nativeType);
    }

    private boolean isNativeFunctionType(FunctionType type) {
        return type.isNativeObjectType();
    }

    @Override
    public JSType caseNamedType(NamedType type) {
        return type;
    }

    @Override
    public JSType caseProxyObjectType(ProxyObjectType type) {
        JSType beforeType = type.getReferencedTypeInternal();
        JSType replacement = beforeType.visit(this);
        if (replacement != beforeType) {
            return replacement;
        }
        return type;
    }
}

