/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(domClasses={DomAttr.class})
public class Attr
extends Node {
    public void detachFromParent() {
        DomAttr domNode = this.getDomNodeOrDie();
        DomElement parent = (DomElement)domNode.getParentNode();
        if (parent != null) {
            domNode.setValue(parent.getAttribute(this.getName()));
        }
        domNode.remove();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public boolean getIsId() {
        return this.getDomNodeOrDie().isId();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getExpando() {
        Object owner = this.getOwnerElement();
        if (null == owner) {
            return false;
        }
        return !ScriptableObject.hasProperty((Scriptable)owner, this.getName());
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getName();
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Object getOwnerElement() {
        DomElement parent = this.getDomNodeOrDie().getOwnerElement();
        if (parent != null) {
            return parent.getScriptObject();
        }
        return null;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @JsxGetter
    public boolean getSpecified() {
        return this.getDomNodeOrDie().getSpecified();
    }

    @JsxGetter
    public String getValue() {
        return this.getDomNodeOrDie().getValue();
    }

    @JsxSetter
    public void setValue(String value) {
        this.getDomNodeOrDie().setValue(value);
    }

    @Override
    public Node getFirstChild() {
        return this.getLastChild();
    }

    @Override
    public Node getLastChild() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ATTR_FIRST_LAST_CHILD_RETURNS_NULL)) {
            return null;
        }
        DomText text = new DomText(this.getDomNodeOrDie().getPage(), this.getNodeValue());
        return (Node)text.getScriptObject();
    }

    public DomAttr getDomNodeOrDie() throws IllegalStateException {
        return (DomAttr)super.getDomNodeOrDie();
    }

    @Override
    public Object getBaseName() {
        return Undefined.instance;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public String getBaseURI() {
        return this.getDomNodeOrDie().getPage().getUrl().toExternalForm();
    }
}

