/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMException;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Interpreter;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.RhinoException;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

@JsxClass
public class Node
extends SimpleScriptable {
    private NodeList childNodes_;
    private EventListenersContainer eventListenersContainer_;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short ELEMENT_NODE = 1;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short ATTRIBUTE_NODE = 2;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short TEXT_NODE = 3;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short CDATA_SECTION_NODE = 4;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short ENTITY_REFERENCE_NODE = 5;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short ENTITY_NODE = 6;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short COMMENT_NODE = 8;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_NODE = 9;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_TYPE_NODE = 10;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_FRAGMENT_NODE = 11;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short NOTATION_NODE = 12;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_POSITION_DISCONNECTED = 1;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_POSITION_PRECEDING = 2;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_POSITION_FOLLOWING = 4;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_POSITION_CONTAINS = 8;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_POSITION_CONTAINED_BY = 16;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;

    @JsxGetter
    public short getNodeType() {
        return ((DomNode)this.getDomNodeOrDie()).getNodeType();
    }

    @JsxGetter
    public String getNodeName() {
        return ((DomNode)this.getDomNodeOrDie()).getNodeName();
    }

    @JsxGetter
    public String getNodeValue() {
        return ((DomNode)this.getDomNodeOrDie()).getNodeValue();
    }

    @JsxSetter
    public void setNodeValue(String newValue) {
        ((DomNode)this.getDomNodeOrDie()).setNodeValue(newValue);
    }

    @JsxFunction
    public Object appendChild(Object childObject) {
        Object appendedChild = null;
        if (childObject instanceof Node) {
            Node childNode = (Node)childObject;
            if (!this.isNodeInsertable(childNode)) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_APPEND_CHILD_THROWS_NO_EXCEPTION_FOR_WRONG_NOTE)) {
                    return childObject;
                }
                throw this.asJavaScriptException(new DOMException("Node cannot be inserted at the specified point in the hierarchy", 3));
            }
            Object childDomNode = childNode.getDomNodeOrDie();
            Object parentNode = this.getDomNodeOrDie();
            ((DomNode)parentNode).appendChild((org.w3c.dom.Node)childDomNode);
            appendedChild = childObject;
            if (!(parentNode instanceof SgmlPage) && !(this instanceof DocumentFragment) && ((DomNode)parentNode).getParentNode() == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_APPEND_CHILD_CREATE_DOCUMENT_FRAGMENT_PARENT)) {
                DomDocumentFragment fragment = ((DomNode)parentNode).getPage().createDomDocumentFragment();
                fragment.appendChild((org.w3c.dom.Node)parentNode);
            }
            this.initInlineFrameIfNeeded((DomNode)childDomNode);
            for (DomNode domNode : ((DomNode)childDomNode).getChildren()) {
                this.initInlineFrameIfNeeded(domNode);
            }
        }
        return appendedChild;
    }

    private void initInlineFrameIfNeeded(DomNode childDomNode) {
        HtmlInlineFrame frame;
        if (childDomNode instanceof HtmlInlineFrame && DomElement.ATTRIBUTE_NOT_DEFINED == (frame = (HtmlInlineFrame)childDomNode).getSrcAttribute()) {
            frame.loadInnerPage();
        }
    }

    private RhinoException asJavaScriptException(DOMException exception) {
        exception.setPrototype(this.getWindow().getPrototype(exception.getClass()));
        exception.setParentScope(this.getWindow());
        if (Context.getCurrentContext().getOptimizationLevel() != -1) {
            throw new Error("HtmlUnit not ready to run in compiled mode");
        }
        int[] linep = new int[1];
        String sourceName = new Interpreter().getSourcePositionFromStack(Context.getCurrentContext(), linep);
        String fileName = sourceName.replaceFirst("script in (.*) from .*", "$1");
        int lineNumber = linep[0];
        exception.setLocation(fileName, lineNumber);
        return new JavaScriptException(exception, fileName, lineNumber);
    }

    private boolean isNodeInsertable(Node childObject) {
        return !(childObject instanceof HTMLHtmlElement);
    }

    @JsxFunction
    public Object cloneNode(boolean deep) {
        Object domNode = this.getDomNodeOrDie();
        DomNode clonedNode = ((DomNode)domNode).cloneNode(deep);
        Node jsClonedNode = this.getJavaScriptNode(clonedNode);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLONE_NODE_COPIES_EVENT_LISTENERS)) {
            this.copyEventListenersWhenNeeded((DomNode)domNode, clonedNode);
        }
        return jsClonedNode;
    }

    private void copyEventListenersWhenNeeded(DomNode domNode, DomNode clonedNode) {
        Node jsNode = (Node)domNode.getScriptObject();
        if (jsNode != null) {
            Node jsClonedNode = this.getJavaScriptNode(clonedNode);
            jsClonedNode.getEventListenersContainer().copyFrom(jsNode.getEventListenersContainer());
        }
        DomNode child = domNode.getFirstChild();
        for (DomNode clonedChild = clonedNode.getFirstChild(); child != null && clonedChild != null; child = child.getNextSibling(), clonedChild = clonedChild.getNextSibling()) {
            this.copyEventListenersWhenNeeded(child, clonedChild);
        }
    }

    @JsxFunction
    public static Object insertBefore(Context context, Scriptable thisObj, Object[] args, Function function) {
        return ((Node)thisObj).insertBeforeImpl(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object insertBeforeImpl(Object[] args) {
        DomNode refChildNode;
        Object newChildObject = args[0];
        Object refChildObject = args.length > 1 ? args[1] : Undefined.instance;
        Object appendedChild = null;
        if (!(newChildObject instanceof Node)) return appendedChild;
        Node newChild = (Node)newChildObject;
        Object newChildNode = newChild.getDomNodeOrDie();
        if (!this.isNodeInsertable(newChild)) {
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_APPEND_CHILD_THROWS_NO_EXCEPTION_FOR_WRONG_NOTE)) throw Context.reportRuntimeError("Node cannot be inserted at the specified point in the hierarchy");
            return newChildNode;
        }
        if (newChildNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)newChildNode;
            for (DomNode child : fragment.getChildren()) {
                this.insertBeforeImpl(new Object[]{child.getScriptObject(), refChildObject});
            }
            return newChildObject;
        }
        if (refChildObject == Undefined.instance) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_121)) {
                if (args.length > 1) {
                    throw Context.reportRuntimeError("Invalid argument.");
                }
                refChildNode = null;
            } else {
                if (args.length != 2) throw Context.reportRuntimeError("insertBefore: not enough arguments");
                refChildNode = null;
            }
        } else {
            refChildNode = refChildObject != null ? (DomNode)((Node)refChildObject).getDomNodeOrDie() : null;
        }
        Object domNode = this.getDomNodeOrDie();
        if (refChildNode != null) {
            refChildNode.insertBefore((DomNode)newChildNode);
            appendedChild = newChildObject;
        } else {
            ((DomNode)domNode).appendChild((org.w3c.dom.Node)newChildNode);
            appendedChild = newChildObject;
        }
        if (((DomNode)domNode).getParentNode() != null || !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_APPEND_CHILD_CREATE_DOCUMENT_FRAGMENT_PARENT)) return appendedChild;
        DomDocumentFragment fragment = ((DomNode)domNode).getPage().createDomDocumentFragment();
        fragment.appendChild((org.w3c.dom.Node)domNode);
        return appendedChild;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF, maxVersion=3.6f)})
    public boolean isSameNode(Object other) {
        return other == this;
    }

    @JsxFunction
    public Object removeChild(Object childObject) {
        Object removedChild = null;
        if (childObject instanceof Node) {
            Object childNode = ((Node)childObject).getDomNodeOrDie();
            ((DomNode)childNode).remove();
            removedChild = childObject;
        }
        return removedChild;
    }

    @JsxFunction
    public boolean hasChildNodes() {
        return ((DomNode)this.getDomNodeOrDie()).getChildren().iterator().hasNext();
    }

    @JsxGetter
    public NodeList getChildNodes() {
        if (this.childNodes_ == null) {
            Object node = this.getDomNodeOrDie();
            boolean isXmlPage = ((DomNode)node).getOwnerDocument() instanceof XmlPage;
            boolean isIE = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_45);
            Boolean xmlSpaceDefault = Node.isXMLSpaceDefault(node);
            boolean skipEmptyTextNode = isIE && isXmlPage && !Boolean.FALSE.equals(xmlSpaceDefault);
            this.childNodes_ = new NodeList((DomNode)node, false, "Node.childNodes", (DomNode)node, skipEmptyTextNode){
                final /* synthetic */ DomNode val$node;
                final /* synthetic */ boolean val$skipEmptyTextNode;
                {
                    this.val$node = domNode;
                    this.val$skipEmptyTextNode = bl;
                    super(x0, x1, x2);
                }

                @Override
                protected List<Object> computeElements() {
                    ArrayList<Object> response = new ArrayList<Object>();
                    for (DomNode child : this.val$node.getChildren()) {
                        if (this.val$skipEmptyTextNode && child instanceof DomText && StringUtils.isBlank((CharSequence)((DomText)child).getNodeValue())) continue;
                        response.add(child);
                    }
                    return response;
                }
            };
        }
        return this.childNodes_;
    }

    private static Boolean isXMLSpaceDefault(DomNode node) {
        while (node instanceof DomElement) {
            String value = ((DomElement)node).getAttribute("xml:space");
            if (!value.isEmpty()) {
                if ("default".equals(value)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            node = node.getParentNode();
        }
        return null;
    }

    @JsxFunction
    public Object replaceChild(Object newChildObject, Object oldChildObject) {
        Object removedChild = null;
        if (newChildObject instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)newChildObject;
            Node firstNode = null;
            Node refChildObject = ((Node)oldChildObject).getNextSibling();
            for (DomNode node : ((DomNode)fragment.getDomNodeOrDie()).getChildren()) {
                if (firstNode == null) {
                    this.replaceChild(node.getScriptObject(), oldChildObject);
                    firstNode = (Node)node.getScriptObject();
                    continue;
                }
                this.insertBeforeImpl(new Object[]{node.getScriptObject(), refChildObject});
            }
            if (firstNode == null) {
                this.removeChild(oldChildObject);
            }
            removedChild = oldChildObject;
        } else if (newChildObject instanceof Node && oldChildObject instanceof Node) {
            Node newChild = (Node)newChildObject;
            if (!this.isNodeInsertable(newChild)) {
                throw Context.reportRuntimeError("Node cannot be inserted at the specified point in the hierarchy");
            }
            Object newChildNode = newChild.getDomNodeOrDie();
            Object oldChildNode = ((Node)oldChildObject).getDomNodeOrDie();
            ((DomNode)oldChildNode).replace((DomNode)newChildNode);
            removedChild = oldChildObject;
        }
        return removedChild;
    }

    public Node getParent() {
        return this.getJavaScriptNode(((DomNode)this.getDomNodeOrDie()).getParentNode());
    }

    @JsxGetter
    public Object getParentNode() {
        return this.getJavaScriptNode(((DomNode)this.getDomNodeOrDie()).getParentNode());
    }

    @JsxGetter
    public Node getNextSibling() {
        return this.getJavaScriptNode(((DomNode)this.getDomNodeOrDie()).getNextSibling());
    }

    @JsxGetter
    public Node getPreviousSibling() {
        return this.getJavaScriptNode(((DomNode)this.getDomNodeOrDie()).getPreviousSibling());
    }

    @JsxGetter
    public Node getFirstChild() {
        return this.getJavaScriptNode(((DomNode)this.getDomNodeOrDie()).getFirstChild());
    }

    @JsxGetter
    public Node getLastChild() {
        return this.getJavaScriptNode(((DomNode)this.getDomNodeOrDie()).getLastChild());
    }

    protected Node getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return (Node)this.getScriptableFor(domNode);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public boolean attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    private EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void detachEvent(String type, Function listener) {
        this.removeEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public void removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    public ScriptResult executeEvent(Event event) {
        if (this.eventListenersContainer_ != null) {
            HtmlPage page = (HtmlPage)((DomNode)this.getDomNodeOrDie()).getPage();
            Window window = (Window)page.getEnclosingWindow().getScriptObject();
            return window.executeEvent(event, this.eventListenersContainer_);
        }
        return null;
    }

    public ScriptResult fireEvent(Event event) {
        return Node.fireEvent(this, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptResult fireEvent(SimpleScriptable scriptable, Event event) {
        HtmlPage page = (HtmlPage)((DomNode)scriptable.getDomNodeOrDie()).getPage();
        Window window = (Window)page.getEnclosingWindow().getScriptObject();
        Object[] args = new Object[]{event};
        event.startFire();
        ScriptResult result = null;
        Event previousEvent = window.getCurrentEvent();
        window.setCurrentEvent(event);
        try {
            Object node;
            EventListenersContainer windowsListeners = scriptable.getWindow().getEventListenersContainer();
            event.setEventPhase((short)1);
            result = windowsListeners.executeCapturingListeners(event, args);
            if (event.isPropagationStopped()) {
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            ArrayList parents = new ArrayList();
            for (node = scriptable.getDomNodeOrDie(); node != null; node = ((DomNode)node).getParentNode()) {
                parents.add(node);
            }
            boolean ie = scriptable.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_124);
            for (int i = parents.size() - 1; i >= 0; --i) {
                DomNode curNode = (DomNode)parents.get(i);
                Node jsNode = (Node)curNode.getScriptObject();
                EventListenersContainer elc = jsNode.eventListenersContainer_;
                if (elc == null) continue;
                ScriptResult r = elc.executeCapturingListeners(event, args);
                result = ScriptResult.combine(r, result, ie);
                if (!event.isPropagationStopped()) continue;
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            Object[] propHandlerArgs = ie ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            event.setEventPhase((short)2);
            for (node = scriptable.getDomNodeOrDie(); node != null; node = ((DomNode)node).getParentNode()) {
                Node jsNode = (Node)((DomNode)node).getScriptObject();
                EventListenersContainer elc = jsNode.eventListenersContainer_;
                if (elc != null) {
                    ScriptResult r = elc.executeBubblingListeners(event, args, propHandlerArgs);
                    result = ScriptResult.combine(r, result, ie);
                    if (event.isPropagationStopped()) {
                        ScriptResult scriptResult = result;
                        return scriptResult;
                    }
                }
                event.setEventPhase((short)3);
            }
            ScriptResult r = windowsListeners.executeBubblingListeners(event, args, propHandlerArgs);
            result = ScriptResult.combine(r, result, ie);
        }
        finally {
            event.endFire();
            window.setCurrentEvent(previousEvent);
        }
        return result;
    }

    public Function getEventHandler(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandler(StringUtils.substring((String)eventName, (int)2));
    }

    public boolean hasEventHandlers(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return false;
        }
        return this.eventListenersContainer_.hasEventHandlers(StringUtils.substring((String)eventName, (int)2));
    }

    public void setEventHandler(String eventName, Function eventHandler) {
        this.setEventHandlerProp(eventName, eventHandler);
    }

    protected void setEventHandlerProp(String eventName, Object value) {
        this.getEventListenersContainer().setEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2), value);
    }

    protected Object getEventHandlerProp(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        String name = StringUtils.substring((String)eventName.toLowerCase(Locale.ENGLISH), (int)2);
        return this.eventListenersContainer_.getEventHandlerProp(name);
    }

    @JsxGetter
    public Object getOwnerDocument() {
        Document document = ((DomNode)this.getDomNodeOrDie()).getOwnerDocument();
        if (document == null) {
            return null;
        }
        return ((SgmlPage)document).getScriptObject();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPrefix() {
        Object domNode = this.getDomNodeOrDie();
        String prefix = ((DomNode)domNode).getPrefix();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_PREFIX_RETURNS_EMPTY_WHEN_UNDEFINED) && (prefix == null || ((DomNode)domNode).getHtmlPageOrNull() != null)) {
            return "";
        }
        return prefix;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getLocalName() {
        return ((DomNode)this.getDomNodeOrDie()).getLocalName();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getNamespaceURI() {
        String namespaceURI = ((DomNode)this.getDomNodeOrDie()).getNamespaceURI();
        if (namespaceURI == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SUPPORT_VIA_ACTIVEXOBJECT)) {
            return "";
        }
        return namespaceURI;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getBaseName() {
        DomElement domElem = (DomElement)this.getDomNodeOrDie();
        boolean isXmlPage = domElem.getOwnerDocument() instanceof XmlPage;
        if (isXmlPage) {
            return domElem.getLocalName();
        }
        return Undefined.instance;
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SUPPORT_VIA_ACTIVEXOBJECT) && null == ((DomNode)this.getDomNodeOrDie()).getHtmlPageOrNull()) {
            ActiveXObject.addProperty((SimpleScriptable)this, "namespaceURI", true, false);
            ActiveXObject.addProperty((SimpleScriptable)this, "prefix", true, false);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public short compareDocumentPosition(Object node) {
        if (!(node instanceof Node)) {
            throw Context.reportRuntimeError("Could not convert JavaScript argument arg 0");
        }
        return ((DomNode)this.getDomNodeOrDie()).compareDocumentPosition((org.w3c.dom.Node)((Node)node).getDomNodeOrDie());
    }

    @JsxFunction
    public void normalize() {
        ((DomNode)this.getDomNodeOrDie()).normalize();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getXml() {
        Object node = this.getDomNodeOrDie();
        if (((DomNode)node).getPage() instanceof XmlPage) {
            if (this instanceof Element) {
                XMLSerializer serializer = new XMLSerializer();
                serializer.setParentScope(this.getParentScope());
                String xml = serializer.serializeToString(this);
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_SERIALIZER_APPENDS_CRLF) && xml.endsWith("\r\n")) {
                    xml = xml.substring(0, xml.length() - 2);
                }
                return xml;
            }
            return ((DomNode)node).asXml();
        }
        return Undefined.instance;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getTextContent() {
        return ((DomNode)this.getDomNodeOrDie()).getTextContent();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setTextContent(Object value) {
        ((DomNode)this.getDomNodeOrDie()).setTextContent(value == null ? null : Context.toString(value));
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, minVersion=10.0f), @WebBrowser(value=BrowserName.CHROME)})
    public Element getParentElement() {
        Node parent = this.getParent();
        if (!(parent instanceof Element)) {
            return null;
        }
        return (Element)parent;
    }

    @JsxGetter
    public Object getAttributes() {
        return null;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=10.0f), @WebBrowser(value=BrowserName.CHROME)})
    public boolean contains(Object element) {
        if (!(element instanceof Node)) {
            throw Context.reportRuntimeError("Could not convert JavaScript argument arg 0");
        }
        for (Node parent = (Node)element; parent != null; parent = parent.getParentElement()) {
            if (this != parent) continue;
            return true;
        }
        return false;
    }
}

