/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class BasicErrorManager
implements ErrorManager {
    protected final SortedSet<GssError> errors = Sets.newTreeSet();
    protected final SortedSet<GssError> warnings = Sets.newTreeSet();

    @Override
    public void report(GssError error) {
        this.errors.add(error);
    }

    @Override
    public void reportWarning(GssError warning) {
        this.warnings.add(warning);
    }

    @Override
    public void generateReport() {
        TreeSet all = Sets.newTreeSet();
        all.addAll(this.warnings);
        all.addAll(this.errors);
        for (GssError error : all) {
            this.print(error.format());
        }
        if (!all.isEmpty()) {
            this.print(this.errors.size() + " error(s), " + this.warnings.size() + " warning(s)\n");
        }
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public abstract void print(String var1);
}

