/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAbstractBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCommentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNodesListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CssAtRuleNode
extends CssNodesListNode<CssValueNode> {
    private final Type type;
    private CssLiteralNode name;
    private CssAbstractBlockNode block;

    CssAtRuleNode(Type type, CssLiteralNode name, @Nullable CssAbstractBlockNode block, @Nullable List<CssCommentNode> comments) {
        super(false, comments);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((type.hasBlock() || block == null ? 1 : 0) != 0);
        this.type = type;
        this.name = name;
        this.block = block;
        this.becomeParentForNode(this.name);
        this.becomeParentForNode(this.block);
    }

    CssAtRuleNode(Type type, CssLiteralNode name, @Nullable CssAbstractBlockNode block) {
        this(type, name, block, null);
    }

    CssAtRuleNode(Type type, CssLiteralNode name) {
        this(type, name, type.hasBlock() ? new CssBlockNode() : null);
    }

    CssAtRuleNode(Type type, CssLiteralNode name, List<CssCommentNode> comments) {
        this(type, name, type.hasBlock() ? new CssBlockNode() : null, comments);
    }

    CssAtRuleNode(CssAtRuleNode node) {
        this(node.getType(), node.getName().deepCopy(), node.getBlock() != null ? node.getBlock().deepCopy() : null, CssAtRuleNode.copyNodes(node.getComments()));
        this.setParameters(CssAtRuleNode.copyNodes(node.getParameters()));
        this.setSourceCodeLocation(node.getSourceCodeLocation());
    }

    public static <N extends CssNode> List<N> copyNodes(List<N> nodes) {
        ArrayList list = Lists.newArrayList();
        for (CssNode node : nodes) {
            CssNode copy = node.deepCopy();
            list.add(copy);
        }
        return list;
    }

    public Type getType() {
        return this.type;
    }

    public CssLiteralNode getName() {
        return this.name;
    }

    void setName(CssLiteralNode name) {
        Preconditions.checkNotNull((Object)name);
        this.removeAsParentOfNode(this.name);
        this.name = name;
        this.becomeParentForNode(this.name);
    }

    public List<CssValueNode> getParameters() {
        return this.children;
    }

    public int getParametersCount() {
        return this.numChildren();
    }

    public void setParameters(List<CssValueNode> parameters) {
        this.setChildren(parameters);
    }

    protected CssAbstractBlockNode getBlock() {
        return this.block;
    }

    void setBlock(@Nullable CssAbstractBlockNode block) {
        Preconditions.checkArgument((boolean)block.isEnclosedWithBraces(), (Object)"Only blocks that are enclosed with braces are valid for @-rules.");
        this.removeAsParentOfNode(this.block);
        this.block = block;
        this.becomeParentForNode(this.block);
    }

    @Override
    public String toString() {
        String output = "";
        if (!this.getComments().isEmpty()) {
            output = this.getComments().toString();
        }
        output = output + this.getType().toString() + this.getParameters().toString();
        if (this.getBlock() != null) {
            output = output + "{" + this.getBlock().toString() + "}";
        }
        return output;
    }

    public static enum Type {
        CHARSET("charset", false),
        IMPORT("import", false),
        NAMESPACE("namespace", false),
        MEDIA("media"),
        PAGE("page"),
        FONT_FACE("font-face"),
        TOP_LEFT_CORNER("top-left-corner"),
        TOP_LEFT("top-left"),
        TOP_CENTER("top-center"),
        TOP_RIGHT("top-right"),
        TOP_RIGHT_CORNER("top-right-corner"),
        LEFT_TOP("left-top"),
        LEFT_MIDDLE("left-middle"),
        LEFT_BOTTOM("left-bottom"),
        RIGHT_TOP("right-top"),
        RIGHT_MIDDLE("right-middle"),
        RIGHT_BOTTOM("right-bottom"),
        BOTTOM_LEFT_CORNER("bottom-left-corner"),
        BOTTOM_LEFT("bottom-left"),
        BOTTOM_CENTER("bottom-center"),
        BOTTOM_RIGHT("bottom-right"),
        BOTTOM_RIGHT_CORNER("bottom-right-corner"),
        VARIABLES("variables"),
        DEF("def", false),
        IF("if"),
        ELSEIF("elseif"),
        ELSE("else"),
        ABSTRACT_COMPONENT("abstract_component"),
        COMPONENT("component"),
        DEFMIXIN("defmixin"),
        MIXIN("mixin", false),
        PROVIDE("provide", false),
        REQUIRE("require", false),
        UNKNOWN(null, false),
        UNKNOWN_BLOCK(null, true);

        private final String canonicalName;
        private final boolean hasBlock;

        private Type(String canonicalName) {
            this(canonicalName, true);
        }

        private Type(String canonicalName, boolean hasBlock) {
            this.canonicalName = canonicalName;
            this.hasBlock = hasBlock;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public boolean hasBlock() {
            return this.hasBlock;
        }

        public boolean isConditional() {
            return this == IF || this == ELSEIF || this == ELSE;
        }

        public String toString() {
            return "@" + this.getCanonicalName();
        }
    }
}

