/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCommentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyValueNode;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;

public class CssDeclarationNode
extends CssNode {
    private CssPropertyNode propertyName;
    private CssPropertyValueNode propertyValue;
    private boolean hasStarHack;

    public CssDeclarationNode(CssPropertyNode propertyName) {
        this(propertyName, new CssPropertyValueNode());
    }

    public CssDeclarationNode(CssPropertyNode propertyName, List<CssCommentNode> comments) {
        this(propertyName, new CssPropertyValueNode(), comments);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, CssPropertyValueNode propertyValue) {
        this(propertyName, propertyValue, null);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, CssPropertyValueNode propertyValue, @Nullable List<CssCommentNode> comments) {
        this(propertyName, propertyValue, comments, false);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, CssPropertyValueNode propertyValue, @Nullable List<CssCommentNode> comments, boolean hasStarHack) {
        super(null, comments, null);
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.becomeParentForNode(this.propertyName);
        this.becomeParentForNode(this.propertyValue);
        this.setStarHack(hasStarHack);
    }

    public CssDeclarationNode(CssDeclarationNode node) {
        this(node.getPropertyName().deepCopy(), node.getPropertyValue().deepCopy(), node.getComments(), node.hasStarHack());
    }

    @Override
    public CssDeclarationNode deepCopy() {
        return new CssDeclarationNode(this);
    }

    public CssPropertyNode getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(CssPropertyNode propertyName) {
        Preconditions.checkNotNull((Object)propertyName);
        this.removeAsParentOfNode(this.propertyName);
        this.propertyName = propertyName;
        this.becomeParentForNode(this.propertyName);
    }

    public CssPropertyValueNode getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(CssPropertyValueNode propertyValue) {
        Preconditions.checkNotNull((Object)propertyValue);
        this.removeAsParentOfNode(this.propertyValue);
        this.propertyValue = propertyValue;
        this.becomeParentForNode(this.propertyValue);
    }

    public void setStarHack(boolean hasStarHack) {
        this.hasStarHack = hasStarHack;
    }

    public boolean hasStarHack() {
        return this.hasStarHack;
    }

    @Override
    public String toString() {
        String output = "";
        if (!this.getComments().isEmpty()) {
            output = this.getComments().toString();
        }
        if (this.hasStarHack()) {
            output = "*";
        }
        output = output + this.getPropertyName().getValue() + ":" + this.getPropertyValue();
        return output;
    }
}

