/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCommentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultVisitController;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CssNode {
    private CssNode parent;
    private SourceCodeLocation sourceCodeLocation;
    private List<CssCommentNode> comments;
    private boolean shouldBeFlipped = true;

    public CssNode() {
        this(null, null);
    }

    public CssNode(@Nullable SourceCodeLocation sourceCodeLocation) {
        this(null, sourceCodeLocation);
    }

    public CssNode(@Nullable CssNode parent) {
        this(parent, null);
    }

    public CssNode(@Nullable CssNode parent, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(parent, null, sourceCodeLocation);
    }

    public CssNode(@Nullable CssNode parent, @Nullable List<CssCommentNode> comments, @Nullable SourceCodeLocation sourceCodeLocation) {
        this.parent = parent;
        this.sourceCodeLocation = sourceCodeLocation;
        this.comments = comments == null ? Lists.newArrayListWithExpectedSize((int)0) : Lists.newArrayList(comments);
        this.becomeParentForNodes(this.comments);
    }

    public abstract CssNode deepCopy();

    public CssNode getParent() {
        return this.parent;
    }

    void setParent(CssNode parent) {
        this.parent = parent;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public void setSourceCodeLocation(@Nullable SourceCodeLocation sourceCodeLocation) {
        this.sourceCodeLocation = sourceCodeLocation;
    }

    void removeParent() {
        this.parent = null;
    }

    void removeAsParentOfNode(CssNode child) {
        if (child == null) {
            return;
        }
        Preconditions.checkArgument((child.getParent() == this ? 1 : 0) != 0);
        child.removeParent();
    }

    void removeAsParentOfNodes(List<? extends CssNode> children) {
        if (children == null) {
            return;
        }
        for (CssNode cssNode : children) {
            this.removeAsParentOfNode(cssNode);
        }
    }

    final void becomeParentForNode(@Nullable CssNode child) {
        if (child == null) {
            return;
        }
        child.setParent(this);
    }

    final void becomeParentForNodes(List<? extends CssNode> children) {
        Preconditions.checkNotNull(children);
        if (children.size() == 0) {
            return;
        }
        for (CssNode cssNode : children) {
            this.becomeParentForNode(cssNode);
        }
    }

    public void appendComment(CssCommentNode comment) {
        this.comments.add(comment);
        this.becomeParentForNode(comment);
    }

    public void setComments(List<CssCommentNode> comments) {
        Preconditions.checkNotNull(this.comments);
        this.removeAsParentOfNodes(this.comments);
        this.comments = Lists.newArrayList(comments);
        this.becomeParentForNodes(this.comments);
    }

    public List<CssCommentNode> getComments() {
        return this.comments;
    }

    public boolean hasComment(String comment) {
        for (CssCommentNode c : this.comments) {
            if (!c.getValue().equals(comment)) continue;
            return true;
        }
        return false;
    }

    public boolean getShouldBeFlipped() {
        return this.shouldBeFlipped;
    }

    public void setShouldBeFlipped(boolean shouldBeFlipped) {
        this.shouldBeFlipped = shouldBeFlipped;
    }

    <T extends CssNode> List<T> copyToList(List<T> list) {
        return Lists.newArrayList(list);
    }

    public final boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    public Iterable<CssNode> ancestors() {
        return new Iterable<CssNode>(){

            @Override
            public Iterator<CssNode> iterator() {
                return new UnmodifiableIterator<CssNode>(){
                    private CssNode current;
                    {
                        this.current = CssNode.this;
                    }

                    public boolean hasNext() {
                        return this.current != null;
                    }

                    public CssNode next() {
                        CssNode result = this.current;
                        this.current = this.current.getParent();
                        return result;
                    }
                };
            }
        };
    }

    public boolean inFunArgs() {
        for (CssNode n : this.ancestors()) {
            if (!(n instanceof CssFunctionNode)) continue;
            return true;
        }
        return false;
    }

    public VisitController getVisitController() {
        return new DefaultVisitController(this, false);
    }
}

