/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.ChunkAware;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCombinatorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRefinerListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRefinerNode;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.collect.ComparisonChain;
import javax.annotation.Nullable;

public class CssSelectorNode
extends CssNode
implements ChunkAware {
    private CssRefinerListNode refiners;
    private CssCombinatorNode combinator = null;
    private String selectorName;
    private Object chunk;

    public CssSelectorNode(@Nullable String selectorName, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(sourceCodeLocation);
        this.selectorName = selectorName;
        this.refiners = new CssRefinerListNode();
        this.becomeParentForNode(this.refiners);
    }

    public CssSelectorNode(String selectorName) {
        this(selectorName, null);
    }

    public CssSelectorNode(CssSelectorNode node) {
        this(node.getSelectorName(), node.getSourceCodeLocation());
        this.chunk = node.getChunk();
        this.refiners = node.getRefiners().deepCopy();
        this.becomeParentForNode(this.refiners);
        if (node.getCombinator() != null) {
            this.combinator = node.getCombinator().deepCopy();
            this.becomeParentForNode(this.combinator);
        }
    }

    @Override
    public CssSelectorNode deepCopy() {
        return new CssSelectorNode(this);
    }

    public CssRefinerListNode getRefiners() {
        return this.refiners;
    }

    public void setRefiners(CssRefinerListNode refiners) {
        this.removeAsParentOfNode(this.refiners);
        this.refiners = refiners;
        this.becomeParentForNode(this.refiners);
    }

    public CssCombinatorNode getCombinator() {
        return this.combinator;
    }

    public void setCombinator(CssCombinatorNode combinator) {
        if (this.combinator != null) {
            this.removeAsParentOfNode(this.combinator);
        }
        this.combinator = combinator;
        this.becomeParentForNode(this.combinator);
    }

    public void setSelectorName(String selectorName) {
        this.selectorName = selectorName;
    }

    public String getSelectorName() {
        return this.selectorName;
    }

    public Specificity getSpecificity() {
        return Specificity.of(this);
    }

    @Override
    public void setChunk(Object chunk) {
        this.chunk = chunk;
    }

    @Override
    public Object getChunk() {
        return this.chunk;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.selectorName != null) {
            sb.append(this.selectorName);
        }
        if (!this.refiners.isEmpty()) {
            for (CssRefinerNode node : this.refiners.childIterable()) {
                sb.append(node.toString());
            }
        }
        if (this.combinator != null) {
            sb.append(this.combinator.toString());
        }
        return sb.toString();
    }

    public static class Specificity
    implements Comparable<Specificity> {
        private final int b;
        private final int c;
        private final int d;

        Specificity(int b, int c, int d) {
            this.b = b;
            this.c = c;
            this.d = d;
        }

        private static Specificity of(CssSelectorNode s) {
            int b = 0;
            int c = 0;
            int d = 0;
            if (s.selectorName != null && !s.selectorName.isEmpty() && !s.selectorName.equals("*")) {
                ++d;
            }
            for (CssRefinerNode refiner : s.refiners.childIterable()) {
                Specificity refinerSecificity = refiner.getSpecificity();
                b += refinerSecificity.b;
                c += refinerSecificity.c;
                d += refinerSecificity.d;
            }
            if (s.combinator != null) {
                Specificity o = s.combinator.getSelector().getSpecificity();
                b += o.b;
                c += o.c;
                d += o.d;
            }
            return new Specificity(b, c, d);
        }

        @Override
        public int compareTo(Specificity other) {
            return ComparisonChain.start().compare(this.b, other.b).compare(this.c, other.c).compare(this.d, other.d).result();
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof Specificity) {
                Specificity that = (Specificity)object;
                return this.b == that.b && this.c == that.c && this.d == that.d;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.b, this.c, this.d});
        }

        public String toString() {
            return "0," + this.b + "," + this.c + "," + this.d;
        }
    }
}

