/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.guava.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssStringNode
extends CssValueNode {
    private static final String LINE_BREAK_PATTERN_STRING = "(?:\\n|\\r\\n|\\r|\\f)";
    private static final Pattern ESCAPE_CHAR_STRING_CONTINUATION_PATTERN = Pattern.compile("\\\\(?:\\n|\\r\\n|\\r|\\f)");
    private static final Pattern ESCAPE_CHAR_NOT_SPECIAL = Pattern.compile("\\\\([^0-9a-fA-F\\n\\r\\f])");
    private static final Pattern ESCAPE_CHAR_HARD_TO_TYPE = Pattern.compile("\\\\([0-9a-fA-F]{1,6})(\\r\\n|[ \\t\\r\\n\\f])?");
    private static final Pattern HTML_PATTERN = Pattern.compile("[<>\"&']");
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("(?:\\n|\\r\\n|\\r|\\f)");
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]+");
    private static final Pattern WIDE_NONASCII_PATTERN = Pattern.compile("\\P{ASCII}");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\n");
    private final Type type;
    private String concreteValue;
    public static final Function<String, String> HTML_ESCAPER = new Function<String, String>(){

        public String apply(String input) {
            return CssStringNode.paranoidEscapeChars(WIDE_NONASCII_PATTERN, CssStringNode.paranoidEscapeChars(HTML_PATTERN, input));
        }
    };
    public static final Function<String, String> SHORT_ESCAPER = new Function<String, String>(){

        public String apply(String input) {
            StringBuffer sb = new StringBuffer();
            Matcher m = WIDE_NONASCII_PATTERN.matcher(input);
            while (m.find()) {
                String match = m.group(0);
                assert (match.length() > 0 && match.length() == match.offsetByCodePoints(0, 1));
                String hexDigits = String.format("%x", match.codePointAt(0));
                String trailer = input.length() <= m.end() || hexDigits.length() == 6 || !HEX_PATTERN.matcher(input.subSequence(m.end(), m.end() + 1)).matches() ? "" : " ";
                m.appendReplacement(sb, String.format("\\\\%s%s", hexDigits, trailer));
            }
            m.appendTail(sb);
            return sb.toString();
        }
    };

    public CssStringNode(Type type, SourceCodeLocation location) {
        super("", location);
        this.setConcreteValue(location.getSourceCode().getFileContents().substring(location.getBeginCharacterIndex() + 1, location.getEndCharacterIndex()));
        this.type = type;
    }

    public CssStringNode(Type type, String value) {
        super(value, null);
        this.type = type;
        this.setValue(value);
    }

    public CssStringNode(CssStringNode node) {
        super(node);
        this.type = node.type;
        this.concreteValue = node.getConcreteValue();
    }

    public Type getType() {
        return this.type;
    }

    public String setConcreteValue(String concreteValue) {
        this.concreteValue = concreteValue;
        super.setValue(CssStringNode.unescape(concreteValue));
        return concreteValue;
    }

    public String getConcreteValue() {
        return this.concreteValue;
    }

    @Override
    public void setValue(String value) {
        this.setConcreteValue(CssStringNode.escape(this.type, HTML_ESCAPER, value));
    }

    @Override
    public CssStringNode deepCopy() {
        return new CssStringNode(this);
    }

    @Override
    public String toString() {
        return this.type.toString(this.getValue(), SHORT_ESCAPER);
    }

    public static String unescape(String escaped) {
        String result = ESCAPE_CHAR_STRING_CONTINUATION_PATTERN.matcher(escaped).replaceAll("");
        result = ESCAPE_CHAR_NOT_SPECIAL.matcher(result).replaceAll("$1");
        Matcher unicode = ESCAPE_CHAR_HARD_TO_TYPE.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (unicode.find()) {
            int codepoint = Integer.parseInt(unicode.group(1), 16);
            if (codepoint > 0x10FFFF && codepoint > 0x10FFFF) {
                codepoint = 65533;
            }
            String replacement = codepoint == 0 ? "" : new String(Character.toChars(codepoint));
            unicode.appendReplacement(sb, replacement);
        }
        unicode.appendTail(sb);
        result = sb.toString();
        return result;
    }

    public static String escape(Type type, Function<? super String, String> discretionaryEscaper, String raw) {
        String result = raw.replaceAll("\\\\", "\\\\\\\\");
        result = LINE_BREAK_PATTERN.matcher(result).replaceAll("\\\\00000a");
        result = (String)discretionaryEscaper.apply((Object)result);
        result = type.escapeForDelimiters(result);
        return result;
    }

    private static String paranoidEscapeChars(Pattern banned, String context) {
        StringBuffer sb = new StringBuffer();
        Matcher markup = banned.matcher(context);
        while (markup.find()) {
            String match = markup.group(0);
            assert (match.length() > 0 && match.length() == match.offsetByCodePoints(0, 1));
            markup.appendReplacement(sb, String.format("\\\\%06x", markup.group(0).codePointAt(0)));
        }
        markup.appendTail(sb);
        return sb.toString();
    }

    public String toString(Function<? super String, String> discretionaryEscaper) {
        return this.type.toString(this.getValue(), discretionaryEscaper);
    }

    public static enum Type {
        DOUBLE_QUOTED_STRING("\""),
        SINGLE_QUOTED_STRING("'");

        public final String delimiter;
        public final String format;

        private Type(String delimiter) {
            this.delimiter = delimiter;
            this.format = String.format("%s%%s%s", delimiter, delimiter);
        }

        public String toString(String value, Function<? super String, String> discretionaryEscaper) {
            return String.format(this.format, CssStringNode.escape(this, discretionaryEscaper, value));
        }

        public String escapeForDelimiters(String input) {
            return input.replaceAll(this.delimiter, "\\\\" + this.delimiter);
        }
    }
}

