/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.gssfunctions;

import java.awt.Color;

class ColorUtil {
    public static final int H = 0;
    public static final int S = 1;
    public static final int B = 2;

    public static float[] toHsb(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    public static String formatColor(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color hsbToColor(float[] inputHsb) {
        return Color.getHSBColor(inputHsb[0], inputHsb[1], inputHsb[2]);
    }

    public static boolean testContrast(Color color1, Color color2, float margin) {
        float differenceFraction = 1.0f - margin;
        return (float)ColorUtil.luminanceDiff(color1, color2) > 125.0f * differenceFraction && (float)ColorUtil.colorDiff(color1, color2) > 500.0f * differenceFraction;
    }

    public static boolean testContrast(Color color1, Color color2) {
        return ColorUtil.luminanceDiff(color1, color2) > 125 && ColorUtil.colorDiff(color1, color2) > 500;
    }

    public static int luminanceDiff(Color c1, Color c2) {
        return Math.abs(ColorUtil.luminance(c1) - ColorUtil.luminance(c2));
    }

    public static int luminance(Color color) {
        return ColorUtil.luminance(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int luminance(int red, int green, int blue) {
        return (red * 299 + green * 587 + blue * 114) / 1000;
    }

    public static int colorDiff(Color color1, Color color2) {
        return ColorUtil.colorDiff(color1.getRed(), color1.getGreen(), color1.getBlue(), color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    public static int colorDiff(int r1, int g1, int b1, int r2, int g2, int b2) {
        return Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
    }

    private ColorUtil() {
    }
}

