/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssHexColorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class BiDiFlipper
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final DecimalFormat percentFormatter = new DecimalFormat("#.########");
    private final MutatingVisitController visitController;
    boolean shouldSwapLeftRightInUrl;
    boolean shouldSwapLtrRtlInUrl;
    boolean shouldFlipConstantReferences;
    private static final Logger logger = Logger.getLogger(BiDiFlipper.class.getName());
    private static final Map<String, String> EXACT_MATCHING_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)"ltr", (Object)"rtl").put((Object)"rtl", (Object)"ltr").put((Object)"left", (Object)"right").put((Object)"right", (Object)"left").put((Object)"e-resize", (Object)"w-resize").put((Object)"w-resize", (Object)"e-resize").put((Object)"ne-resize", (Object)"nw-resize").put((Object)"nw-resize", (Object)"ne-resize").put((Object)"nesw-resize", (Object)"nwse-resize").put((Object)"nwse-resize", (Object)"nesw-resize").put((Object)"se-resize", (Object)"sw-resize").put((Object)"sw-resize", (Object)"se-resize").build();
    private static final Map<String, String> ENDS_WITH_MATCHING_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)"-left", (Object)"-right").put((Object)"-right", (Object)"-left").put((Object)"-bottomleft", (Object)"-bottomright").put((Object)"-topleft", (Object)"-topright").put((Object)"-bottomright", (Object)"-bottomleft").put((Object)"-topright", (Object)"-topleft").build();
    private static final Map<String, String> CONTAINS_MATCHING_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)"-left-", (Object)"-right-").put((Object)"-right-", (Object)"-left-").build();
    private static final Set<String> PROPERTIES_WITH_FLIPPABLE_PERCENTAGE = ImmutableSet.of((Object)"background", (Object)"background-position", (Object)"background-position-x", (Object)"-ms-background-position-x");
    private static final Set<String> BORDER_RADIUS_PROPERTIES = ImmutableSet.of((Object)"border-radius", (Object)"-webkit-border-radius", (Object)"-moz-border-radius");
    private static final Set<String> FOUR_PART_PROPERTIES_THAT_SHOULD_FLIP = ImmutableSet.of((Object)"border-color", (Object)"border-style", (Object)"border-width", (Object)"margin", (Object)"padding");
    private static final Map<Pattern, String> URL_LTRTL_PATTERN_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)Pattern.compile("(?<![a-zA-Z])([-_\\./]*)ltr([-_\\./]+)"), (Object)"$1rtl$2").put((Object)Pattern.compile("(?<![a-zA-Z])([-_\\./]*)rtl([-_\\./]+)"), (Object)"$1ltr$2").build();
    private static final Map<Pattern, String> URL_LEFTRIGHT_PATTERN_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)Pattern.compile("(?<![a-zA-Z])([-_\\./]*)left([-_\\./]+)"), (Object)"$1right$2").put((Object)Pattern.compile("(?<![a-zA-Z])([-_\\./]*)right([-_\\./]+)"), (Object)"$1left$2").build();

    public BiDiFlipper(MutatingVisitController visitController, boolean swapLtrRtlInUrl, boolean swapLeftRightInUrl, boolean shouldFlipConstantReferences) {
        this.visitController = visitController;
        this.shouldSwapLtrRtlInUrl = swapLtrRtlInUrl;
        this.shouldSwapLeftRightInUrl = swapLeftRightInUrl;
        this.shouldFlipConstantReferences = shouldFlipConstantReferences;
    }

    public BiDiFlipper(MutatingVisitController visitController, boolean swapLtrRtlInUrl, boolean swapLeftRightInUrl) {
        this(visitController, swapLtrRtlInUrl, swapLeftRightInUrl, false);
    }

    private boolean isLeftOrCenterOrRight(String value) {
        return "left".equals(value) || "center".equals(value) || "right".equals(value);
    }

    private boolean isCssHexColorNode(CssValueNode valueNode) {
        return valueNode instanceof CssHexColorNode;
    }

    private boolean isCssLiteralNode(CssValueNode valueNode) {
        return valueNode instanceof CssLiteralNode;
    }

    private boolean isNumericNode(CssValueNode valueNode) {
        return valueNode instanceof CssNumericNode;
    }

    private boolean isSlashNode(CssValueNode valueNode) {
        if (valueNode instanceof CssCompositeValueNode) {
            CssCompositeValueNode compositeNode = (CssCompositeValueNode)valueNode;
            return compositeNode.getOperator() == CssCompositeValueNode.Operator.SLASH;
        }
        return false;
    }

    private boolean shouldFlipConstantReference(CssValueNode valueNode) {
        if (!this.shouldFlipConstantReferences) {
            return false;
        }
        if (!(valueNode instanceof CssConstantReferenceNode)) {
            return false;
        }
        String ref = valueNode.getValue();
        return !ref.startsWith("__F");
    }

    private boolean isNumericAndHasPercentage(CssValueNode value) {
        if (!this.isNumericNode(value)) {
            return false;
        }
        CssNumericNode numericNode = (CssNumericNode)value;
        return "%".equals(numericNode.getUnit());
    }

    private boolean isValidForPercentageFlipping(CssPropertyNode propertyNode, CssPropertyValueNode propertyValueNode, int valueIndex) {
        String propertyName = propertyNode.getPropertyName();
        if (PROPERTIES_WITH_FLIPPABLE_PERCENTAGE.contains(propertyName)) {
            CssValueNode previousValueNode;
            if (valueIndex == 0) {
                return true;
            }
            if ("background".equals(propertyName) && !this.isNumericNode(previousValueNode = (CssValueNode)propertyValueNode.getChildAt(valueIndex - 1)) && !this.isLeftOrCenterOrRight(previousValueNode.getValue())) {
                return true;
            }
        }
        return false;
    }

    private CssValueNode flipPercentageValueNode(CssValueNode valueNode) {
        if (!this.isNumericAndHasPercentage(valueNode)) {
            return valueNode;
        }
        CssNumericNode numericNode = (CssNumericNode)valueNode;
        String oldPercentageValue = numericNode.getNumericPart();
        double newPercentValue = 100.0 - Double.parseDouble(oldPercentageValue);
        CssNumericNode newNumericNode = new CssNumericNode(this.percentFormatter.format(newPercentValue), "%");
        return newNumericNode;
    }

    private List<CssValueNode> flipCorners(List<CssValueNode> valueNodes) {
        switch (valueNodes.size()) {
            case 2: {
                return Lists.newArrayList((Object[])new CssValueNode[]{valueNodes.get(1), valueNodes.get(0)});
            }
            case 3: {
                return Lists.newArrayList((Object[])new CssValueNode[]{valueNodes.get(1), valueNodes.get(0), valueNodes.get(1).deepCopy(), valueNodes.get(2)});
            }
            case 4: {
                return Lists.newArrayList((Object[])new CssValueNode[]{valueNodes.get(1), valueNodes.get(0), valueNodes.get(3), valueNodes.get(2)});
            }
        }
        return valueNodes;
    }

    private List<CssValueNode> flipBorderRadius(List<CssValueNode> valueNodes) {
        int count = 0;
        int slashLocation = -1;
        CssCompositeValueNode slashNode = null;
        for (CssValueNode valueNode : valueNodes) {
            if (this.isSlashNode(valueNode)) {
                slashLocation = count;
                slashNode = (CssCompositeValueNode)valueNode;
                break;
            }
            ++count;
        }
        if (slashLocation == -1) {
            return this.flipCorners(valueNodes);
        }
        List<CssValueNode> slashNodeValues = slashNode.getValues();
        ArrayList horizontalValues = Lists.newArrayList();
        horizontalValues.addAll(valueNodes.subList(0, slashLocation));
        horizontalValues.add(slashNodeValues.get(0));
        List<CssValueNode> newHorizontalValues = this.flipCorners(horizontalValues);
        ArrayList verticalValues = Lists.newArrayList();
        verticalValues.add(slashNodeValues.get(1));
        verticalValues.addAll(valueNodes.subList(slashLocation + 1, valueNodes.size()));
        List<CssValueNode> newVerticalValues = this.flipCorners(verticalValues);
        ArrayList newSlashNodeValues = Lists.newArrayList();
        newSlashNodeValues.add(newHorizontalValues.get(newHorizontalValues.size() - 1));
        newSlashNodeValues.add(newVerticalValues.get(0));
        CssCompositeValueNode newSlashNode = new CssCompositeValueNode(newSlashNodeValues, CssCompositeValueNode.Operator.SLASH, null);
        ArrayList newValueList = Lists.newArrayList();
        newValueList.addAll(newHorizontalValues.subList(0, newHorizontalValues.size() - 1));
        newValueList.add(newSlashNode);
        newValueList.addAll(newVerticalValues.subList(1, newVerticalValues.size()));
        return newValueList;
    }

    private List<CssValueNode> flipNumericValues(List<CssValueNode> valueNodes, String propertyName) {
        if (BORDER_RADIUS_PROPERTIES.contains(propertyName)) {
            return this.flipBorderRadius(valueNodes);
        }
        if (valueNodes.size() != 4 || !FOUR_PART_PROPERTIES_THAT_SHOULD_FLIP.contains(propertyName)) {
            return valueNodes;
        }
        int count = 0;
        CssValueNode secondValueNode = null;
        CssValueNode fourthValueNode = null;
        for (CssValueNode valueNode : valueNodes) {
            if (this.isNumericNode(valueNode) || this.isCssLiteralNode(valueNode) || this.isCssHexColorNode(valueNode) || this.shouldFlipConstantReference(valueNode)) {
                switch (count) {
                    case 3: {
                        fourthValueNode = valueNode.deepCopy();
                        break;
                    }
                    case 1: {
                        secondValueNode = valueNode.deepCopy();
                    }
                }
            } else {
                return valueNodes;
            }
            ++count;
        }
        count = 0;
        ArrayList newValueList = Lists.newArrayList();
        for (CssValueNode valueNode : valueNodes) {
            if (1 == count) {
                newValueList.add(fourthValueNode);
            } else if (3 == count) {
                newValueList.add(secondValueNode);
            } else {
                newValueList.add(valueNode);
            }
            ++count;
        }
        return newValueList;
    }

    private String flipValue(String value) {
        for (String s : EXACT_MATCHING_FOR_FLIPPING.keySet()) {
            if (!value.equals(s)) continue;
            value = EXACT_MATCHING_FOR_FLIPPING.get(s);
            break;
        }
        for (String s : ENDS_WITH_MATCHING_FOR_FLIPPING.keySet()) {
            if (!value.endsWith(s)) continue;
            value = value.replace(s, ENDS_WITH_MATCHING_FOR_FLIPPING.get(s));
            break;
        }
        for (String s : CONTAINS_MATCHING_FOR_FLIPPING.keySet()) {
            if (value.indexOf(s) <= 0) continue;
            value = value.replace(s, CONTAINS_MATCHING_FOR_FLIPPING.get(s));
            break;
        }
        return value;
    }

    private <T extends CssValueNode> T flipNode(T tNode) {
        if (tNode instanceof CssLiteralNode) {
            CssLiteralNode literalNode = (CssLiteralNode)tNode;
            String oldValue = literalNode.getValue();
            if (null == oldValue) {
                return tNode;
            }
            String flippedValue = this.flipValue(oldValue);
            if (flippedValue.equals(oldValue)) {
                return tNode;
            }
            CssLiteralNode flippedLiteralNode = new CssLiteralNode(flippedValue);
            return (T)flippedLiteralNode;
        }
        if (tNode instanceof CssPropertyNode) {
            CssPropertyNode propertyNode = (CssPropertyNode)tNode;
            String oldValue = propertyNode.getPropertyName();
            if (null == oldValue) {
                return tNode;
            }
            String flippedValue = this.flipValue(oldValue);
            if (flippedValue.equals(oldValue)) {
                return tNode;
            }
            CssPropertyNode flippedPropertyNode = new CssPropertyNode(flippedValue);
            return (T)flippedPropertyNode;
        }
        return tNode;
    }

    private String flipUrlValue(String value) {
        String s;
        if (null == value) {
            return null;
        }
        if (this.shouldSwapLtrRtlInUrl) {
            for (Pattern p : URL_LTRTL_PATTERN_FOR_FLIPPING.keySet()) {
                if (!p.matcher(value).find()) continue;
                s = URL_LTRTL_PATTERN_FOR_FLIPPING.get(p);
                value = p.matcher(value).replaceFirst(s);
                break;
            }
        }
        if (this.shouldSwapLeftRightInUrl) {
            for (Pattern p : URL_LEFTRIGHT_PATTERN_FOR_FLIPPING.keySet()) {
                if (!p.matcher(value).find()) continue;
                s = URL_LEFTRIGHT_PATTERN_FOR_FLIPPING.get(p);
                value = p.matcher(value).replaceFirst(s);
                break;
            }
        }
        return value;
    }

    private CssValueNode flipUrlNode(CssValueNode valueNode) {
        if (!(valueNode instanceof CssFunctionNode) || !"url".equals(((CssFunctionNode)valueNode).getFunctionName())) {
            return valueNode;
        }
        CssFunctionNode oldFunctionNode = (CssFunctionNode)valueNode;
        CssFunctionArgumentsNode functionArguments = oldFunctionNode.getArguments();
        Preconditions.checkArgument((1 == functionArguments.numChildren() ? 1 : 0) != 0, (Object)"url function taking more than one argument");
        CssValueNode oldArgument = (CssValueNode)functionArguments.getChildAt(0);
        String oldUrlValue = oldArgument.getValue();
        String newUrlValue = this.flipUrlValue(oldUrlValue);
        CssValueNode newArgument = oldArgument.deepCopy();
        newArgument.setValue(newUrlValue);
        ArrayList<CssValueNode> newArgumentsList = new ArrayList<CssValueNode>();
        newArgumentsList.add(newArgument);
        CssFunctionNode newFunctionNode = oldFunctionNode.deepCopy();
        newFunctionNode.setArguments(new CssFunctionArgumentsNode(newArgumentsList));
        return newFunctionNode;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declarationNode) {
        if (!declarationNode.getShouldBeFlipped()) {
            return true;
        }
        CssDeclarationNode newDeclarationNode = declarationNode.deepCopy();
        CssPropertyNode propertyNode = declarationNode.getPropertyName();
        newDeclarationNode.setPropertyName(this.flipNode(propertyNode));
        CssPropertyValueNode propertyValueNode = declarationNode.getPropertyValue();
        ArrayList valueNodes = Lists.newArrayList();
        int valueIndex = 0;
        for (CssValueNode valueNode : propertyValueNode.childIterable()) {
            CssValueNode temp = this.flipUrlNode(valueNode);
            temp = this.flipNode(temp);
            if (this.isValidForPercentageFlipping(propertyNode, propertyValueNode, valueIndex)) {
                temp = this.flipPercentageValueNode(temp);
            }
            valueNodes.add(temp.deepCopy());
            ++valueIndex;
        }
        if (valueNodes.size() != 0) {
            newDeclarationNode.setPropertyValue(new CssPropertyValueNode(this.flipNumericValues(valueNodes, propertyNode.getPropertyName())));
        } else {
            newDeclarationNode.setPropertyValue(propertyValueNode.deepCopy());
        }
        ArrayList replacementList = Lists.newArrayList();
        replacementList.add(newDeclarationNode);
        this.visitController.replaceCurrentBlockChildWith(replacementList, false);
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

