/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssClassSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCombinatorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFontFaceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssIdSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssImportRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyframesNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMediaRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNodesListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPageRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPageSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPriorityNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPseudoClassNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPseudoElementNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRefinerNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssStringNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import java.util.logging.Logger;

public class CompactPrinter
extends DefaultTreeVisitor
implements CssCompilerPass {
    private String compactedPrintedString = null;
    private VisitController visitController;
    private CssNode subtree;
    private static final Logger logger = Logger.getLogger(CompactPrinter.class.getName());
    protected StringBuilder sb = null;
    private static final ImmutableSet<String> ARGUMENT_SEPARATORS = ImmutableSet.of((Object)",", (Object)"=", (Object)" ");

    public CompactPrinter(CssNode subtree) {
        this.subtree = subtree;
        this.visitController = this.subtree.getVisitController();
    }

    public CompactPrinter(CssTree tree) {
        this(tree.getRoot());
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        return false;
    }

    @Override
    public boolean enterImportRule(CssImportRuleNode node) {
        this.sb.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(' ');
            if (param instanceof CssStringNode) {
                this.sb.append(param.toString());
                continue;
            }
            this.sb.append(param.getValue());
        }
        return true;
    }

    @Override
    public void leaveImportRule(CssImportRuleNode node) {
        this.sb.append(';');
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode node) {
        this.sb.append(node.getType().toString());
        if (node.getParameters().size() > 0) {
            this.sb.append(" ");
        }
        return true;
    }

    private void appendMediaParameterWithParentheses(CssValueNode node) {
        this.sb.append("(");
        this.sb.append(node.getValue());
        this.sb.append(")");
    }

    @Override
    public void leaveMediaRule(CssMediaRuleNode node) {
        this.sb.append('}');
    }

    @Override
    public boolean enterPageRule(CssPageRuleNode node) {
        this.sb.append(node.getType().toString());
        this.sb.append(' ');
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(param.getValue());
        }
        this.deleteLastCharIfCharIs(' ');
        return true;
    }

    @Override
    public boolean enterPageSelector(CssPageSelectorNode node) {
        this.sb.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(' ');
            this.sb.append(param.getValue());
        }
        return true;
    }

    @Override
    public boolean enterFontFace(CssFontFaceNode node) {
        this.sb.append(node.getType().toString());
        return true;
    }

    @Override
    public boolean enterSelector(CssSelectorNode selector) {
        String name = selector.getSelectorName();
        if (name != null) {
            this.sb.append(name);
        }
        return true;
    }

    @Override
    public void leaveSelector(CssSelectorNode selector) {
        this.sb.append(',');
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterIdSelector(CssIdSelectorNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        this.sb.append(node.getPrefix());
        this.sb.append(node.getRefinerName());
        switch (node.getFunctionType()) {
            case NTH: {
                this.sb.append(node.getArgument().replace(" ", ""));
                this.sb.append(")");
                break;
            }
            case LANG: {
                this.sb.append(node.getArgument());
                this.sb.append(")");
            }
        }
        return true;
    }

    @Override
    public void leavePseudoClass(CssPseudoClassNode node) {
        if (node.getFunctionType() == CssPseudoClassNode.FunctionType.NOT) {
            this.deleteLastCharIfCharIs(',');
            this.sb.append(")");
        }
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterAttributeSelector(CssAttributeSelectorNode node) {
        this.sb.append(node.getPrefix());
        this.sb.append(node.getAttributeName());
        this.sb.append(node.getMatchSymbol());
        this.sb.append(node.getValue());
        this.sb.append(node.getSuffix());
        return true;
    }

    private void appendRefiner(CssRefinerNode node) {
        this.sb.append(node.getPrefix());
        this.sb.append(node.getRefinerName());
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (combinator != null) {
            this.sb.append(combinator.getCombinatorType().getCanonicalName());
        }
        return true;
    }

    @Override
    public void leaveCombinator(CssCombinatorNode combinator) {
        this.deleteLastCharIfCharIs(',');
    }

    @Override
    public void leaveSelectorBlock(CssSelectorListNode node) {
        this.deleteLastCharIfCharIs(',');
    }

    @Override
    public boolean enterDeclarationBlock(CssDeclarationBlockNode block) {
        this.sb.append('{');
        return true;
    }

    @Override
    public void leaveDeclarationBlock(CssDeclarationBlockNode block) {
        this.deleteLastCharIfCharIs(';');
        this.sb.append('}');
    }

    @Override
    public boolean enterBlock(CssBlockNode block) {
        if (block.getParent() instanceof CssUnknownAtRuleNode || block.getParent() instanceof CssMediaRuleNode) {
            this.sb.append("{");
        }
        return true;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        if (declaration.hasStarHack()) {
            this.sb.append('*');
        }
        this.sb.append(declaration.getPropertyName().getValue());
        this.sb.append(':');
        return true;
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode declaration) {
        this.deleteLastCharIfCharIs(' ');
        this.sb.append(';');
    }

    @Override
    public void leaveCompositeValueNode(CssCompositeValueNode node) {
        this.deleteLastCharIfCharIs(' ');
        if (node.getParent() instanceof CssPropertyValueNode) {
            this.sb.append(' ');
        }
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (node instanceof CssPriorityNode) {
            this.deleteLastCharIfCharIs(' ');
        }
        this.appendValueNode(node);
        return true;
    }

    @Override
    public void leaveValueNode(CssValueNode node) {
        if (node.getParent() instanceof CssPropertyValueNode) {
            this.sb.append(' ');
        }
    }

    @Override
    public boolean enterCompositeValueNodeOperator(CssCompositeValueNode parent) {
        this.deleteLastCharIfCharIs(' ');
        this.sb.append(parent.getOperator().getOperatorName());
        return true;
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode node) {
        this.sb.append(node.getFunctionName());
        this.sb.append('(');
        return true;
    }

    @Override
    public void leaveFunctionNode(CssFunctionNode node) {
        this.deleteLastCharIfCharIs(' ');
        this.sb.append(") ");
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        if (ARGUMENT_SEPARATORS.contains((Object)node.toString())) {
            this.deleteLastCharIfCharIs(' ');
        }
        this.appendValueNode(node);
        return true;
    }

    @Override
    public boolean enterConditionalBlock(CssConditionalBlockNode node) {
        this.visitController.stopVisit();
        logger.warning("Conditional block should not be present: " + node.toString() + (node.getSourceCodeLocation() != null ? "@" + node.getSourceCodeLocation().getLineNumber() : ""));
        return true;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        this.sb.append("@").append(node.getName().toString());
        if (node.getParameters().size() > 0) {
            this.sb.append(" ");
        }
        return true;
    }

    @Override
    public boolean enterMediaTypeListDelimiter(CssNodesListNode<? extends CssNode> node) {
        this.sb.append(' ');
        return true;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        if (node.getType().hasBlock()) {
            if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
                this.sb.append('}');
            }
        } else {
            this.sb.append(';');
        }
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode node) {
        this.sb.append('@').append(node.getName().toString());
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(' ');
            this.sb.append(param.getValue());
        }
        if (node.getType().hasBlock()) {
            this.sb.append('{');
        }
        return true;
    }

    @Override
    public void leaveKeyframesRule(CssKeyframesNode node) {
        if (node.getType().hasBlock()) {
            this.sb.append('}');
        } else {
            this.sb.append(';');
        }
    }

    @Override
    public boolean enterKey(CssKeyNode node) {
        String value = node.getKeyValue();
        if (value != null) {
            this.sb.append(value);
        }
        return true;
    }

    @Override
    public void leaveKey(CssKeyNode key) {
        this.sb.append(',');
    }

    @Override
    public void leaveKeyBlock(CssKeyListNode block) {
        this.deleteLastCharIfCharIs(',');
    }

    protected void deleteLastCharIfCharIs(char ch) {
        if (this.sb.length() == 0) {
            return;
        }
        if (this.sb.charAt(this.sb.length() - 1) == ch) {
            this.sb.deleteCharAt(this.sb.length() - 1);
        }
    }

    public String getCompactPrintedString() {
        return this.compactedPrintedString;
    }

    @Override
    public void runPass() {
        this.sb = new StringBuilder();
        this.visitController.startVisit(this);
        this.compactedPrintedString = this.sb.toString();
    }

    protected void appendValueNode(CssValueNode node) {
        if (node instanceof CssCompositeValueNode) {
            return;
        }
        if (node instanceof CssBooleanExpressionNode && node.getParent() instanceof CssMediaRuleNode) {
            this.appendMediaParameterWithParentheses(node);
            return;
        }
        if (node instanceof CssStringNode) {
            CssStringNode s = (CssStringNode)node;
            this.sb.append(s.toString(CssStringNode.HTML_ESCAPER));
            return;
        }
        if (node instanceof CssNumericNode) {
            CssNumericNode n = (CssNumericNode)node;
            this.sb.append(n.getNumericPart());
            this.sb.append(n.getUnit());
            return;
        }
        this.sb.append(node.toString());
    }

    public static String printCompactly(CssNode n) {
        CompactPrinter p = new CompactPrinter(n);
        p.runPass();
        return p.getCompactPrintedString().trim();
    }

    public static String printCompactly(CssTree t) {
        return CompactPrinter.printCompactly(t.getRoot());
    }
}

