/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.List;
import java.util.Stack;

public class CreateConditionalNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private Stack<CssConditionalBlockNode> stack = new Stack();
    private CssConditionalBlockNode activeBlockNode = null;
    private static final String ifName = CssAtRuleNode.Type.IF.getCanonicalName();
    private static final String elseifName = CssAtRuleNode.Type.ELSEIF.getCanonicalName();
    private static final String elseName = CssAtRuleNode.Type.ELSE.getCanonicalName();

    public CreateConditionalNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        String name = node.getName().getValue();
        if (name.equals(ifName)) {
            CssConditionalBlockNode condBlock = new CssConditionalBlockNode(node.getComments());
            condBlock.setSourceCodeLocation(node.getSourceCodeLocation());
            this.stack.push(condBlock);
        } else if (name.equals(elseifName) || name.equals(elseName)) {
            if (this.activeBlockNode == null) {
                this.errorManager.report(new GssError("@" + name + " without previous @" + ifName, node.getSourceCodeLocation()));
                this.visitController.removeCurrentNode();
                return false;
            }
            this.stack.push(this.activeBlockNode);
        }
        this.activeBlockNode = null;
        return true;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        String name = node.getName().getValue();
        if (name.equals(ifName) || name.equals(elseifName) || name.equals(elseName)) {
            this.activeBlockNode = this.stack.pop();
            CssConditionalRuleNode conditionalNode = this.createConditionalRuleNode(node, name);
            this.activeBlockNode.addChildToBack(conditionalNode);
            this.updateLocation(this.activeBlockNode);
            if (name.equals(ifName)) {
                this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssNode[]{this.activeBlockNode}), false);
            } else {
                this.visitController.removeCurrentNode();
                if (name.equals(elseName)) {
                    this.activeBlockNode = null;
                }
            }
        }
    }

    @Override
    public boolean enterRuleset(CssRulesetNode node) {
        this.activeBlockNode = null;
        return false;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        this.activeBlockNode = null;
        return true;
    }

    private CssConditionalRuleNode createConditionalRuleNode(CssUnknownAtRuleNode node, String name) {
        Preconditions.checkState((node.getBlock() == null || node.getBlock() instanceof CssBlockNode ? 1 : 0) != 0);
        CssBlockNode block = (CssBlockNode)node.getBlock();
        if (block == null) {
            this.errorManager.report(new GssError("@" + name + " without block", node.getSourceCodeLocation()));
        }
        List<CssValueNode> params = node.getParameters();
        CssBooleanExpressionNode condition = null;
        if (!name.equals(elseName)) {
            if (!params.isEmpty()) {
                CssValueNode param;
                if (params.size() > 1) {
                    this.errorManager.report(new GssError("@" + name + " with too many parameters", node.getSourceCodeLocation()));
                }
                condition = (param = params.get(0)) instanceof CssBooleanExpressionNode ? (CssBooleanExpressionNode)param : new CssBooleanExpressionNode(CssBooleanExpressionNode.Type.CONSTANT, param.getValue(), param.getSourceCodeLocation());
            } else {
                this.errorManager.report(new GssError("@" + name + " without condition", node.getSourceCodeLocation()));
            }
        } else if (!params.isEmpty()) {
            this.errorManager.report(new GssError("@" + elseName + " with too many parameters", node.getSourceCodeLocation()));
        }
        CssConditionalRuleNode rulenode = new CssConditionalRuleNode(CssAtRuleNode.Type.valueOf(name.toUpperCase()), node.getName(), condition, block);
        rulenode.setComments(node.getComments());
        rulenode.setSourceCodeLocation(node.getSourceCodeLocation());
        return rulenode;
    }

    private void updateLocation(CssConditionalBlockNode blockNode) {
        SourceCodeLocation firstLocation = blockNode.getSourceCodeLocation();
        SourceCodeLocation lastLocation = ((CssConditionalRuleNode)blockNode.getLastChild()).getSourceCodeLocation();
        SourceCodeLocation mergedLocation = new SourceCodeLocation(firstLocation.getSourceCode(), firstLocation.getBeginCharacterIndex(), firstLocation.getBeginLineNumber(), firstLocation.getBeginIndexInLine(), lastLocation.getEndCharacterIndex(), lastLocation.getEndLineNumber(), lastLocation.getEndIndexInLine());
        blockNode.setSourceCodeLocation(mergedLocation);
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

