/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRootNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;

public class CreateConstantReferences
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private CssNode globalScope;
    private CssNode currentScope;

    public CreateConstantReferences(MutatingVisitController visitController) {
        this.visitController = visitController;
    }

    @Override
    public void leaveValueNode(CssValueNode node) {
        if (!(node instanceof CssLiteralNode) || !CssConstantReferenceNode.isDefinitionReference(node.getValue())) {
            return;
        }
        CssConstantReferenceNode ref = new CssConstantReferenceNode(node.getValue(), node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)ref), false);
        CssNode scope = this.determineScope(ref);
        ref.setScope(scope);
    }

    @Override
    public void leaveArgumentNode(CssValueNode node) {
        this.leaveValueNode(node);
    }

    @Override
    public boolean enterTree(CssRootNode node) {
        this.globalScope = node;
        return true;
    }

    @Override
    public boolean enterMixinDefinition(CssMixinDefinitionNode node) {
        this.currentScope = node;
        return true;
    }

    @Override
    public void leaveMixinDefinition(CssMixinDefinitionNode node) {
        this.currentScope = this.globalScope;
    }

    private CssNode determineScope(CssConstantReferenceNode ref) {
        if (this.currentScope instanceof CssMixinDefinitionNode) {
            CssMixinDefinitionNode mixinDef = (CssMixinDefinitionNode)this.currentScope;
            for (CssValueNode arg : mixinDef.getArguments().getChildren()) {
                if (!arg.getValue().equals(ref.getValue())) continue;
                return this.currentScope;
            }
        }
        return this.globalScope;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

