/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.List;

public class CreateDefinitionNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String defName = CssAtRuleNode.Type.DEF.getCanonicalName();
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;

    public CreateDefinitionNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        if (node.getName().getValue().equals(defName)) {
            if (node.getType().hasBlock()) {
                this.reportError("@" + defName + " with block", node);
                return false;
            }
            List<CssValueNode> params = node.getParameters();
            if (params.isEmpty()) {
                this.reportError("@" + defName + " without name", node);
                return false;
            }
            CssNode nameNode = params.get(0);
            if (!(nameNode instanceof CssLiteralNode)) {
                this.reportError("@" + defName + " without a valid literal as name", node);
                return false;
            }
            CssLiteralNode defNameNode = (CssLiteralNode)nameNode;
            String defName = defNameNode.getValue();
            if (!CssConstantReferenceNode.isDefinitionReference(defName)) {
                this.errorManager.reportWarning(new GssError(String.format("WARNING for invalid @def name %s. We will ignore this.", defName), defNameNode.getSourceCodeLocation()));
            }
            CssDefinitionNode def = new CssDefinitionNode(params.subList(1, params.size()), (CssLiteralNode)nameNode, node.getComments(), node.getSourceCodeLocation());
            this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssNode[]{def}), false);
            return false;
        }
        return true;
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
        this.visitController.removeCurrentNode();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

