/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import java.util.logging.Logger;

public class EliminateUnitsFromZeroNumericValues
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final ImmutableSet<String> REMOVABLE_LENGTH_UNITS = ImmutableSet.of((Object)"em", (Object)"ex", (Object)"px", (Object)"gd", (Object)"rem", (Object)"vw", (Object[])new String[]{"vh", "vm", "ch", "in", "cm", "mm", "pt", "pc"});
    private static final Logger logger = Logger.getLogger(EliminateUnitsFromZeroNumericValues.class.getName());
    private final MutatingVisitController visitController;

    public EliminateUnitsFromZeroNumericValues(MutatingVisitController visitController) {
        this.visitController = visitController;
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (node instanceof CssNumericNode) {
            CssNumericNode numericNode = (CssNumericNode)node;
            String numericValue = numericNode.getNumericPart();
            try {
                float value = Float.parseFloat(numericValue);
                if ((double)value == 0.0) {
                    if (REMOVABLE_LENGTH_UNITS.contains((Object)numericNode.getUnit())) {
                        numericNode.setUnit("");
                    }
                    numericNode.setNumericPart("0");
                } else {
                    int stripFront = 0;
                    while (numericValue.charAt(stripFront) == '0') {
                        ++stripFront;
                    }
                    int stripBack = numericValue.length() - 1;
                    if (numericValue.indexOf(".") >= 0) {
                        while (numericValue.charAt(stripBack) == '0') {
                            --stripBack;
                        }
                        if (numericValue.charAt(stripBack) == '.') {
                            --stripBack;
                        }
                        numericValue = numericValue.substring(stripFront, stripBack + 1);
                    }
                    numericNode.setNumericPart(numericValue);
                }
            }
            catch (NumberFormatException e) {
                logger.warning("Numeric part of the numeric value node could not be parsed: " + node.toString() + (node.getSourceCodeLocation() != null ? "@" + node.getSourceCodeLocation().getLineNumber() : ""));
            }
        }
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

