/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;
import com.google.gwt.thirdparty.common.css.compiler.passes.ConstantDefinitions;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

public final class HandleMissingConstantDefinitions
extends DefaultTreeVisitor
implements CssCompilerPass {
    static final String ERROR_MESSAGE = "Unknown use of a @def constant. Make sure that the constant is included in the compilation unit.";
    private final VisitController visitController;
    private final ErrorManager errorManager;
    private final ConstantDefinitions definitions;

    public HandleMissingConstantDefinitions(VisitController visitController, ErrorManager errorManager, ConstantDefinitions definitions) {
        this.visitController = (VisitController)Preconditions.checkNotNull((Object)visitController);
        this.errorManager = (ErrorManager)Preconditions.checkNotNull((Object)errorManager);
        this.definitions = (ConstantDefinitions)Preconditions.checkNotNull((Object)definitions);
    }

    @Override
    public void leaveValueNode(CssValueNode node) {
        if (node instanceof CssConstantReferenceNode && !this.definitions.getConstants().keySet().contains(node.getValue())) {
            this.errorManager.report(new GssError(ERROR_MESSAGE, node.getSourceCodeLocation()));
        }
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

