/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCommentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMediaRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRefinerNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import java.util.logging.Logger;

public class MarkNonFlippableNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String INVALID_NOFLIP_ERROR_MESSAGE = "@noflip must be moved outside of selector sequence since it applies to entire block.";
    private final VisitController visitController;
    private final ErrorManager errorManager;
    private static final Logger logger = Logger.getLogger(MarkNonFlippableNodes.class.getName());
    private static final String NOFLIP = "/* @noflip */";

    public MarkNonFlippableNodes(VisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    private boolean hasNoFlip(CssNode node) {
        for (CssCommentNode comment : node.getComments()) {
            if (!comment.getValue().equals(NOFLIP)) continue;
            return true;
        }
        return false;
    }

    private boolean firstParentSelectorHasNoFlip(CssDeclarationBlockNode node) {
        CssNode parentNode = node.getParent();
        if (parentNode instanceof CssRulesetNode) {
            CssRulesetNode rulesetNode = (CssRulesetNode)parentNode;
            CssSelectorListNode selectors = rulesetNode.getSelectors();
            if (selectors.numChildren() == 0) {
                return false;
            }
            if (!((CssSelectorNode)selectors.getChildAt(0)).getShouldBeFlipped()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode node) {
        if (this.hasNoFlip(node)) {
            node.setShouldBeFlipped(false);
        }
        return true;
    }

    @Override
    public boolean enterSelector(CssSelectorNode node) {
        if (this.hasNoFlip(node)) {
            node.setShouldBeFlipped(false);
        }
        return true;
    }

    @Override
    public void leaveSelector(CssSelectorNode node) {
        for (CssRefinerNode refiner : node.getRefiners().getChildren()) {
            if (!this.hasNoFlip(refiner)) continue;
            node.setShouldBeFlipped(false);
            return;
        }
    }

    @Override
    public boolean enterRuleset(CssRulesetNode node) {
        boolean noFlip;
        boolean bl = noFlip = this.hasNoFlip(node) || !node.getParent().getShouldBeFlipped() || !node.getParent().getParent().getShouldBeFlipped();
        if (noFlip) {
            node.setShouldBeFlipped(false);
        }
        return true;
    }

    @Override
    public void leaveRuleset(CssRulesetNode node) {
        boolean firstSelector = true;
        CssSelectorListNode selectors = node.getSelectors();
        for (CssSelectorNode sel : selectors.childIterable()) {
            if (!sel.getShouldBeFlipped()) {
                if (!firstSelector) {
                    this.errorManager.report(new GssError(INVALID_NOFLIP_ERROR_MESSAGE, node.getSourceCodeLocation()));
                } else {
                    node.setShouldBeFlipped(false);
                    selectors.setShouldBeFlipped(false);
                }
                return;
            }
            firstSelector = false;
        }
    }

    @Override
    public boolean enterConditionalBlock(CssConditionalBlockNode node) {
        if (this.hasNoFlip(node) || !node.getParent().getShouldBeFlipped() || !node.getParent().getParent().getShouldBeFlipped()) {
            node.setShouldBeFlipped(false);
        }
        return true;
    }

    @Override
    public boolean enterConditionalRule(CssConditionalRuleNode node) {
        if (this.hasNoFlip(node) || !node.getParent().getShouldBeFlipped()) {
            node.setShouldBeFlipped(false);
        }
        return true;
    }

    @Override
    public boolean enterDeclarationBlock(CssDeclarationBlockNode node) {
        if (this.hasNoFlip(node) || !node.getParent().getShouldBeFlipped() || this.firstParentSelectorHasNoFlip(node)) {
            node.setShouldBeFlipped(false);
        }
        return true;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode node) {
        if (this.hasNoFlip(node) || !node.getParent().getShouldBeFlipped()) {
            node.setShouldBeFlipped(false);
        }
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

