/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCommentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRootNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.passes.CompactPrinter;
import com.google.gwt.thirdparty.common.css.compiler.passes.PrettyPrinter;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import java.util.List;

public class PassUtil {
    @VisibleForTesting
    public static final String ALTERNATE = "/* @alternate */";

    public static String printSelector(CssSelectorNode selector) {
        CssTree t = PassUtil.createTreeWithSelector(selector);
        String selectorString = PassUtil.compactPrintTree(t);
        return selectorString.substring(0, selectorString.length() - 2);
    }

    public static String printSelectorList(CssSelectorListNode selectorList) {
        CssTree t = PassUtil.createTreeWithSelectorList(selectorList);
        String selectorListString = PassUtil.compactPrintTree(t);
        return selectorListString.substring(0, selectorListString.length() - 2);
    }

    public static String prettyPrintSelector(CssSelectorNode selector) {
        CssTree t = PassUtil.createTreeWithSelector(selector);
        PrettyPrinter prettyPrinter = new PrettyPrinter(t.getVisitController());
        prettyPrinter.runPass();
        String selectorString = prettyPrinter.getPrettyPrintedString();
        int index = selectorString.indexOf(123);
        return selectorString.substring(0, index - 1);
    }

    private static CssTree createTreeWithSelector(CssSelectorNode selector) {
        CssDeclarationBlockNode declarations = new CssDeclarationBlockNode();
        CssRulesetNode rulesetNode = new CssRulesetNode(declarations);
        rulesetNode.addSelector(selector);
        return PassUtil.createTreeWithRuleset(rulesetNode);
    }

    private static CssTree createTreeWithSelectorList(CssSelectorListNode selectorList) {
        CssDeclarationBlockNode declarations = new CssDeclarationBlockNode();
        CssRulesetNode rulesetNode = new CssRulesetNode(declarations);
        rulesetNode.setSelectors(selectorList);
        return PassUtil.createTreeWithRuleset(rulesetNode);
    }

    private static CssTree createTreeWithRuleset(CssRulesetNode rulesetNode) {
        ImmutableList blockChildren = ImmutableList.of((Object)rulesetNode);
        CssBlockNode block = new CssBlockNode(false, (List<CssNode>)blockChildren);
        CssRootNode root = new CssRootNode(block);
        return new CssTree(null, root);
    }

    private static String compactPrintTree(CssTree tree) {
        CompactPrinter compactPrinter = new CompactPrinter(tree);
        compactPrinter.runPass();
        return compactPrinter.getCompactPrintedString();
    }

    public static boolean hasAlternateAnnotation(CssNode node) {
        for (CssCommentNode comment : node.getComments()) {
            if (!comment.getValue().equals(ALTERNATE)) continue;
            return true;
        }
        return false;
    }
}

