/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPriorityNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPropertyValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;

public class RemoveEmptyValues
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String EMPTY = "empty";
    private final MutatingVisitController visitController;

    public RemoveEmptyValues(MutatingVisitController visitController) {
        this.visitController = visitController;
    }

    private static boolean isEmpty(CssValueNode node) {
        return EMPTY.equals(node.getValue());
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        return false;
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (RemoveEmptyValues.isEmpty(node)) {
            this.visitController.removeCurrentNode();
        }
        return true;
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode node) {
        CssPropertyValueNode propertyValue = node.getPropertyValue();
        if (propertyValue.isEmpty() || propertyValue.numChildren() == 1 && propertyValue.getChildAt(0) instanceof CssPriorityNode) {
            this.visitController.removeCurrentNode();
        }
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

