/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.ast.Proxiable;
import com.google.gwt.thirdparty.common.css.compiler.passes.ConstantDefinitions;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ReplaceConstantReferences
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private final ConstantDefinitions constantDefinitions;
    private final boolean removeDefs;
    private final ErrorManager errorManager;
    private final boolean allowUndefinedConstants;

    public ReplaceConstantReferences(CssTree tree, @Nullable ConstantDefinitions constantDefinitions) {
        this(tree, constantDefinitions, true, null, true);
    }

    public ReplaceConstantReferences(CssTree tree, @Nullable ConstantDefinitions constantDefinitions, boolean removeDefs) {
        this(tree, constantDefinitions, removeDefs, null, true);
    }

    public ReplaceConstantReferences(CssTree tree, @Nullable ConstantDefinitions constantDefinitions, boolean removeDefs, ErrorManager errorManager, boolean allowUndefinedConstants) {
        Preconditions.checkArgument((allowUndefinedConstants || errorManager != null ? 1 : 0) != 0);
        this.visitController = tree.getMutatingVisitController();
        this.constantDefinitions = constantDefinitions;
        this.removeDefs = removeDefs;
        this.errorManager = errorManager;
        this.allowUndefinedConstants = allowUndefinedConstants;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        if (this.removeDefs) {
            this.visitController.removeCurrentNode();
        }
        return !this.removeDefs;
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (node instanceof CssConstantReferenceNode) {
            this.replaceConstantReference((CssConstantReferenceNode)node);
        }
        return true;
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        return this.enterValueNode(node);
    }

    @VisibleForTesting
    void replaceConstantReference(CssConstantReferenceNode node) {
        if (this.constantDefinitions == null) {
            return;
        }
        CssDefinitionNode constantNode = this.constantDefinitions.getConstantDefinition(node.getValue());
        if (constantNode == null) {
            if (!this.allowUndefinedConstants) {
                this.errorManager.report(new GssError("GSS constant not defined: " + node.getValue(), node.getSourceCodeLocation()));
            }
            return;
        }
        List<CssValueNode> params = constantNode.getParameters();
        ArrayList temp = Lists.newArrayListWithCapacity((int)params.size());
        boolean inFunArgs = node.inFunArgs();
        boolean intermediate = false;
        for (CssValueNode n : params) {
            if (inFunArgs && intermediate) {
                temp.add(new CssLiteralNode(" ", n.getSourceCodeLocation()));
            }
            if (n instanceof Proxiable) {
                Proxiable proxiable = (Proxiable)((Object)n);
                temp.add(proxiable.createProxy());
            } else {
                temp.add(n.deepCopy());
            }
            intermediate = true;
        }
        CssCompositeValueNode tempNode = new CssCompositeValueNode(temp, CssCompositeValueNode.Operator.SPACE, node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssCompositeValueNode[]{tempNode}), true);
    }

    @Override
    public void runPass() {
        if (this.constantDefinitions != null) {
            for (String constantName : this.constantDefinitions.getConstantsNames()) {
                CssDefinitionNode node = this.constantDefinitions.getConstantDefinition(constantName);
                List<CssValueNode> params = node.getParameters();
                for (int i = 0; i < params.size(); ++i) {
                    CssValueNode n = params.get(i);
                    if (!(n instanceof Proxiable)) continue;
                    Proxiable proxiable = (Proxiable)((Object)n);
                    node.replaceChildAt(i, ImmutableList.of(proxiable.createProxy()));
                }
            }
        }
        this.visitController.startVisit(this);
    }
}

