/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMixinNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ReplaceMixins
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String NO_MATCHING_MIXIN_DEFINITION_ERROR_MESSAGE = "The name of the mixin matches no mixin definition name";
    @VisibleForTesting
    static final String ARGUMENT_MISMATCH_ERROR_MESSAGE = "The number of arguments of the mixin and the corresponding definition are different";
    @VisibleForTesting
    static final String CYCLE_ERROR_MESSAGE = "A nested mixin call produces a cycle";
    @VisibleForTesting
    static final String NO_MATCHING_MIXIN_FOR_REF_ERROR_MESSAGE = "Internal compiler error: The current definition reference belongs to a mixin but does not match the mixin on top of the stack";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final Map<String, CssMixinDefinitionNode> definitions;
    private Stack<StackFrame> currentMixinStack;

    public ReplaceMixins(MutatingVisitController visitController, ErrorManager errorManager, Map<String, CssMixinDefinitionNode> definitions) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.definitions = definitions;
        this.currentMixinStack = new Stack();
    }

    @Override
    public void leaveMixin(CssMixinNode node) {
        if (!this.currentMixinStack.empty()) {
            this.currentMixinStack.peek().decreaseDeclarationCount();
        }
        this.replaceMixin(node);
        while (!this.currentMixinStack.empty() && this.currentMixinStack.peek().isDeclarationCountZero()) {
            this.currentMixinStack.pop();
        }
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode node) {
        if (this.currentMixinStack.empty()) {
            return;
        }
        this.currentMixinStack.peek().decreaseDeclarationCount();
        while (!this.currentMixinStack.empty() && this.currentMixinStack.peek().isDeclarationCountZero()) {
            this.currentMixinStack.pop();
        }
    }

    @Override
    public void leaveDeclarationBlock(CssDeclarationBlockNode node) {
        this.currentMixinStack.clear();
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        return this.replaceReference(node, false);
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        return this.replaceReference(node, true);
    }

    private boolean replaceReference(CssValueNode node, boolean isArgument) {
        if (!(node instanceof CssConstantReferenceNode)) {
            return true;
        }
        List<CssValueNode> values = this.getValuesForReference((CssConstantReferenceNode)node, isArgument);
        if (values == null) {
            return true;
        }
        this.visitController.replaceCurrentBlockChildWith(values, false);
        return true;
    }

    private void replaceMixin(CssMixinNode mixin) {
        if (this.containsCycle(mixin)) {
            return;
        }
        CssMixinDefinitionNode currentMixinDefinition = this.definitions.get(mixin.getDefinitionName());
        if (currentMixinDefinition == null) {
            this.errorManager.report(new GssError(NO_MATCHING_MIXIN_DEFINITION_ERROR_MESSAGE, mixin.getSourceCodeLocation()));
            return;
        }
        List mixinDecls = currentMixinDefinition.getBlock().deepCopy().getChildren();
        this.visitController.replaceCurrentBlockChildWith(mixinDecls, true);
        Map<String, List<CssValueNode>> refMap = this.createReferenceMapping(mixin, currentMixinDefinition);
        if (refMap == null) {
            this.visitController.stopVisit();
            return;
        }
        if (mixinDecls.size() == 0) {
            return;
        }
        this.currentMixinStack.push(new StackFrame(mixin, mixinDecls.size(), refMap));
    }

    private List<CssValueNode> getValuesForReference(CssConstantReferenceNode ref, boolean isArgument) {
        if (!(ref.getScope() instanceof CssMixinDefinitionNode)) {
            return null;
        }
        String defName = ref.getValue();
        CssMixinDefinitionNode currentMixinDefinition = (CssMixinDefinitionNode)ref.getScope();
        CssMixinNode currentMixin = this.currentMixinStack.peek().getMixin();
        if (!currentMixin.getDefinitionName().equals(currentMixinDefinition.getDefinitionName())) {
            this.errorManager.report(new GssError(NO_MATCHING_MIXIN_FOR_REF_ERROR_MESSAGE, ref.getSourceCodeLocation()));
            return null;
        }
        List<CssValueNode> values = this.currentMixinStack.peek().getValuesForReference(ref.getValue());
        Preconditions.checkNotNull(values);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (CssValueNode val : values) {
            if (!isArgument && " ".equals(val.getValue())) continue;
            builder.add((Object)val.deepCopy());
        }
        return builder.build();
    }

    private boolean containsCycle(CssMixinNode mixin) {
        for (StackFrame frame : this.currentMixinStack) {
            if (!mixin.getDefinitionName().equals(frame.getMixin().getDefinitionName())) continue;
            this.errorManager.report(new GssError(CYCLE_ERROR_MESSAGE, frame.getMixin().getSourceCodeLocation()));
            return true;
        }
        return false;
    }

    private Map<String, List<CssValueNode>> createReferenceMapping(CssMixinNode mixin, CssMixinDefinitionNode def) {
        HashMap refMap = Maps.newHashMap();
        ArrayList currentValues = Lists.newArrayList();
        Iterator<CssValueNode> definitionArgumentIterator = def.getArguments().getChildIterator();
        for (CssValueNode arg : mixin.getArguments().getChildren()) {
            if (",".equals(arg.getValue())) {
                if (!this.addValuesToMap(refMap, definitionArgumentIterator, currentValues, arg.getSourceCodeLocation())) {
                    return null;
                }
                currentValues.clear();
                continue;
            }
            currentValues.add(arg);
        }
        if (!currentValues.isEmpty() && !this.addValuesToMap(refMap, definitionArgumentIterator, currentValues, mixin.getSourceCodeLocation())) {
            return null;
        }
        if (definitionArgumentIterator.hasNext()) {
            this.errorManager.report(new GssError(ARGUMENT_MISMATCH_ERROR_MESSAGE, mixin.getSourceCodeLocation()));
            return null;
        }
        return refMap;
    }

    private boolean addValuesToMap(Map<String, List<CssValueNode>> refMap, Iterator<CssValueNode> definitionArgumentIterator, List<CssValueNode> values, SourceCodeLocation location) {
        if (values.isEmpty() || !definitionArgumentIterator.hasNext()) {
            this.errorManager.report(new GssError(ARGUMENT_MISMATCH_ERROR_MESSAGE, location));
            return false;
        }
        CssValueNode argument = definitionArgumentIterator.next();
        if (",".equals(argument.getValue())) {
            if (values.isEmpty() || !definitionArgumentIterator.hasNext()) {
                this.errorManager.report(new GssError(ARGUMENT_MISMATCH_ERROR_MESSAGE, location));
                return false;
            }
            argument = definitionArgumentIterator.next();
        }
        refMap.put(argument.getValue(), (List<CssValueNode>)ImmutableList.copyOf(values));
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private static class StackFrame {
        private CssMixinNode mixin;
        private int declarationCount;
        private final Map<String, List<CssValueNode>> valueMap;

        StackFrame(CssMixinNode mixin, int declarationCount, Map<String, List<CssValueNode>> valueMap) {
            Preconditions.checkNotNull((Object)mixin);
            Preconditions.checkArgument((declarationCount > 0 ? 1 : 0) != 0);
            Preconditions.checkNotNull(valueMap);
            this.mixin = mixin;
            this.declarationCount = declarationCount;
            this.valueMap = valueMap;
        }

        CssMixinNode getMixin() {
            return this.mixin;
        }

        void decreaseDeclarationCount() {
            if (this.declarationCount > 0) {
                --this.declarationCount;
            }
        }

        boolean isDeclarationCountZero() {
            return this.declarationCount == 0;
        }

        List<CssValueNode> getValuesForReference(String refName) {
            return this.valueMap.get(refName);
        }
    }
}

