/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNodesListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.passes.UniformVisitor;

public class SExprPrinter
extends UniformVisitor {
    public final StringBuilder sb;
    public final boolean includeHashCodes;

    public SExprPrinter(StringBuilder sb, boolean includeHashCodes) {
        this.sb = sb;
        this.includeHashCodes = includeHashCodes;
    }

    public SExprPrinter(StringBuilder sb) {
        this(sb, true);
    }

    public SExprPrinter() {
        this(new StringBuilder());
    }

    @Override
    public void enter(CssNode node) {
        if (this.includeHashCodes) {
            this.sb.append(String.format("(%s@%d ", node.getClass().getName(), node.hashCode()));
        } else {
            this.sb.append(String.format("(%s ", node.getClass().getName()));
        }
    }

    private void trim(StringBuilder sb, String waste) {
        if (sb.length() == 0) {
            return;
        }
        int expectedPosition = sb.length() - waste.length();
        if (sb.indexOf(waste, expectedPosition) != -1) {
            sb.delete(expectedPosition, sb.length());
        }
    }

    @Override
    public void leave(CssNode node) {
        this.trim(this.sb, " ");
        this.sb.append(")");
    }

    @Override
    public boolean enterMediaTypeListDelimiter(CssNodesListNode<? extends CssNode> node) {
        super.enterMediaTypeListDelimiter(node);
        this.sb.append("(MediaTypeListDelimiter");
        return true;
    }

    @Override
    public void leaveMediaTypeListDelimiter(CssNodesListNode<? extends CssNode> node) {
        this.sb.append(")");
        super.leaveMediaTypeListDelimiter(node);
    }

    @Override
    public boolean enterCompositeValueNodeOperator(CssCompositeValueNode parent) {
        super.enterCompositeValueNodeOperator(parent);
        this.sb.append("(CompositeValueNodeOperator ");
        this.sb.append(parent.getOperator().name());
        return true;
    }

    @Override
    public void leaveCompositeValueNodeOperator(CssCompositeValueNode parent) {
        this.sb.append(")");
        super.leaveCompositeValueNodeOperator(parent);
    }

    @Override
    public boolean enterValueNode(CssValueNode n) {
        super.enterValueNode(n);
        this.sb.append(n.toString() + " ");
        return true;
    }

    @Override
    public void leaveValueNode(CssValueNode n) {
        super.leaveValueNode(n);
    }

    public static String print(CssTree t) {
        StringBuilder sb = new StringBuilder();
        t.getVisitController().startVisit(new SExprPrinter(sb));
        return sb.toString();
    }

    public static String print(boolean includeHashCodes, CssTree t) {
        StringBuilder sb = new StringBuilder();
        t.getVisitController().startVisit(new SExprPrinter(sb, includeHashCodes));
        return sb.toString();
    }

    public static String print(CssNode n) {
        StringBuilder sb = new StringBuilder();
        n.getVisitController().startVisit(new SExprPrinter(sb));
        return sb.toString();
    }

    public static String print(boolean includeHashCodes, CssNode n) {
        StringBuilder sb = new StringBuilder();
        n.getVisitController().startVisit(new SExprPrinter(sb, includeHashCodes));
        return sb.toString();
    }
}

