/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.dev.protobuf.CodedOutputStream;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Charsets;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.base.Supplier;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.Files;
import com.google.gwt.thirdparty.javascript.jscomp.CheckLevel;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConventions;
import com.google.gwt.thirdparty.javascript.jscomp.Compiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerInput;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerOptions;
import com.google.gwt.thirdparty.javascript.jscomp.ControlFlowGraph;
import com.google.gwt.thirdparty.javascript.jscomp.DependencyOptions;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticGroups;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.DotFormatter;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.JSModuleGraph;
import com.google.gwt.thirdparty.javascript.jscomp.Result;
import com.google.gwt.thirdparty.javascript.jscomp.SourceFile;
import com.google.gwt.thirdparty.javascript.jscomp.SourceMap;
import com.google.gwt.thirdparty.javascript.jscomp.VariableMap;
import com.google.gwt.thirdparty.javascript.jscomp.WhitelistWarningsGuard;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.TokenStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

abstract class AbstractCommandLineRunner<A extends Compiler, B extends CompilerOptions> {
    static final DiagnosticType OUTPUT_SAME_AS_INPUT_ERROR = DiagnosticType.error("JSC_OUTPUT_SAME_AS_INPUT_ERROR", "Bad output file (already listed as input file): {0}");
    static final DiagnosticType NO_TREE_GENERATED_ERROR = DiagnosticType.error("JSC_NO_TREE_GENERATED_ERROR", "Code contains errors. No tree was generated.");
    private final CommandLineConfig config = new CommandLineConfig();
    private final PrintStream defaultJsOutput;
    private final PrintStream err;
    private A compiler;
    private Charset inputCharset;
    private Charset outputCharset2;
    private String legacyOutputCharset;
    private boolean testMode = false;
    private Supplier<List<SourceFile>> externsSupplierForTesting = null;
    private Supplier<List<SourceFile>> inputsSupplierForTesting = null;
    private Supplier<List<JSModule>> modulesSupplierForTesting = null;
    private Function<Integer, Boolean> exitCodeReceiverForTesting = null;
    private Map<String, String> rootRelativePathsMap = null;
    private Map<String, String> parsedModuleWrappers = null;
    private static final String OUTPUT_MARKER = "%output%";
    private static final String OUTPUT_MARKER_JS_STRING = "%output|jsstring%";

    AbstractCommandLineRunner() {
        this(System.out, System.err);
    }

    AbstractCommandLineRunner(PrintStream out, PrintStream err) {
        this.defaultJsOutput = (PrintStream)Preconditions.checkNotNull((Object)out);
        this.err = (PrintStream)Preconditions.checkNotNull((Object)err);
    }

    @VisibleForTesting
    void enableTestMode(Supplier<List<SourceFile>> externsSupplier, Supplier<List<SourceFile>> inputsSupplier, Supplier<List<JSModule>> modulesSupplier, Function<Integer, Boolean> exitCodeReceiver) {
        Preconditions.checkArgument((boolean)(inputsSupplier == null ^ modulesSupplier == null));
        this.testMode = true;
        this.externsSupplierForTesting = externsSupplier;
        this.inputsSupplierForTesting = inputsSupplier;
        this.modulesSupplierForTesting = modulesSupplier;
        this.exitCodeReceiverForTesting = exitCodeReceiver;
    }

    protected boolean isInTestMode() {
        return this.testMode;
    }

    protected CommandLineConfig getCommandLineConfig() {
        return this.config;
    }

    protected abstract A createCompiler();

    protected abstract B createOptions();

    protected DiagnosticGroups getDiagnosticGroups() {
        if (this.compiler == null) {
            return new DiagnosticGroups();
        }
        return ((Compiler)this.compiler).getDiagnosticGroups();
    }

    static DependencyOptions createDependencyOptions(boolean manageClosureDependencies, boolean onlyClosureDependencies, boolean processCommonJSModules, List<String> closureEntryPoints) throws FlagUsageException {
        if (onlyClosureDependencies) {
            if (closureEntryPoints.isEmpty()) {
                throw new FlagUsageException("When only_closure_dependencies is on, you must specify at least one closure_entry_point");
            }
            return new DependencyOptions().setDependencyPruning(true).setDependencySorting(true).setMoocherDropping(true).setEntryPoints(closureEntryPoints);
        }
        if (processCommonJSModules) {
            return new DependencyOptions().setDependencyPruning(false).setDependencySorting(true).setMoocherDropping(false).setEntryPoints(closureEntryPoints);
        }
        if (manageClosureDependencies || closureEntryPoints.size() > 0) {
            return new DependencyOptions().setDependencyPruning(true).setDependencySorting(true).setMoocherDropping(false).setEntryPoints(closureEntryPoints);
        }
        return null;
    }

    protected void setRunOptions(CompilerOptions options) throws FlagUsageException, IOException {
        HashSet uniqueNames;
        DiagnosticGroups diagnosticGroups = this.getDiagnosticGroups();
        if (this.config.warningGuards != null) {
            for (WarningGuardSpec.Entry entry : this.config.warningGuards.entries) {
                diagnosticGroups.setWarningLevel(options, entry.groupName, entry.level);
            }
        }
        if (!this.config.warningsWhitelistFile.isEmpty()) {
            options.addWarningsGuard(WhitelistWarningsGuard.fromFile(new File(this.config.warningsWhitelistFile)));
        }
        AbstractCommandLineRunner.createDefineOrTweakReplacements(this.config.define, options, false);
        options.setTweakProcessing(this.config.tweakProcessing);
        AbstractCommandLineRunner.createDefineOrTweakReplacements(this.config.tweak, options, true);
        DependencyOptions depOptions = AbstractCommandLineRunner.createDependencyOptions(this.config.manageClosureDependencies, this.config.onlyClosureDependencies, this.config.processCommonJSModules, this.config.closureEntryPoints);
        if (depOptions != null) {
            options.setDependencyOptions(depOptions);
        }
        options.devMode = this.config.jscompDevMode;
        options.setCodingConvention(this.config.codingConvention);
        options.setSummaryDetailLevel(this.config.summaryDetailLevel);
        options.setTrustedStrings(true);
        this.legacyOutputCharset = options.outputCharset = this.getLegacyOutputCharset();
        this.outputCharset2 = this.getOutputCharset2();
        this.inputCharset = this.getInputCharset();
        if (this.config.jsOutputFile.length() > 0 && this.config.skipNormalOutputs) {
            throw new FlagUsageException("skip_normal_outputs and js_output_file cannot be used together.");
        }
        if (this.config.skipNormalOutputs && this.config.printAst) {
            throw new FlagUsageException("skip_normal_outputs and print_ast cannot be used together.");
        }
        if (this.config.skipNormalOutputs && this.config.printTree) {
            throw new FlagUsageException("skip_normal_outputs and print_tree cannot be used together.");
        }
        if (this.config.createSourceMap.length() > 0) {
            options.sourceMapOutputPath = this.config.createSourceMap;
        }
        options.sourceMapDetailLevel = this.config.sourceMapDetailLevel;
        options.sourceMapFormat = this.config.sourceMapFormat;
        if (!this.config.variableMapInputFile.equals("")) {
            options.inputVariableMap = VariableMap.load(this.config.variableMapInputFile);
        }
        if (!this.config.propertyMapInputFile.equals("")) {
            options.inputPropertyMap = VariableMap.load(this.config.propertyMapInputFile);
        }
        if (this.config.languageIn.length() > 0) {
            CompilerOptions.LanguageMode languageMode = CompilerOptions.LanguageMode.fromString(this.config.languageIn);
            if (languageMode != null) {
                options.setLanguageIn(languageMode);
            } else {
                throw new FlagUsageException("Unknown language `" + this.config.languageIn + "' specified.");
            }
        }
        if (!this.config.outputManifests.isEmpty()) {
            uniqueNames = Sets.newHashSet();
            for (String filename : this.config.outputManifests) {
                if (uniqueNames.add(filename)) continue;
                throw new FlagUsageException("output_manifest flags specify duplicate file names: " + filename);
            }
        }
        if (!this.config.outputBundles.isEmpty()) {
            uniqueNames = Sets.newHashSet();
            for (String filename : this.config.outputBundles) {
                if (uniqueNames.add(filename)) continue;
                throw new FlagUsageException("output_bundle flags specify duplicate file names: " + filename);
            }
        }
        options.acceptConstKeyword = this.config.acceptConstKeyword;
        options.transformAMDToCJSModules = this.config.transformAMDToCJSModules;
        options.processCommonJSModules = this.config.processCommonJSModules;
        options.commonJSModulePathPrefix = this.config.commonJSModulePathPrefix;
        options.angularPass = this.config.angularPass;
        options.tracer = this.config.tracerMode;
    }

    protected final A getCompiler() {
        return this.compiler;
    }

    public final void run() {
        int result = 0;
        int runs = 1;
        try {
            for (int i = 0; i < runs && result == 0; ++i) {
                result = this.doRun();
            }
        }
        catch (FlagUsageException e) {
            System.err.println(e.getMessage());
            result = -1;
        }
        catch (Throwable t) {
            t.printStackTrace();
            result = -2;
        }
        if (this.testMode) {
            this.exitCodeReceiverForTesting.apply((Object)result);
        } else {
            System.exit(result);
        }
    }

    protected PrintStream getErrorPrintStream() {
        return this.err;
    }

    protected List<SourceFile> createInputs(List<String> files, boolean allowStdIn) throws FlagUsageException, IOException {
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>(files.size());
        boolean usingStdin = false;
        for (String filename : files) {
            if (!"-".equals(filename)) {
                SourceFile newFile = SourceFile.fromFile(filename, this.inputCharset);
                inputs.add(newFile);
                continue;
            }
            if (!allowStdIn) {
                throw new FlagUsageException("Can't specify stdin.");
            }
            if (usingStdin) {
                throw new FlagUsageException("Can't specify stdin twice.");
            }
            if (!this.config.outputManifests.isEmpty()) {
                throw new FlagUsageException("Manifest files cannot be generated when the input is from stdin.");
            }
            if (!this.config.outputBundles.isEmpty()) {
                throw new FlagUsageException("Bundle files cannot be generated when the input is from stdin.");
            }
            inputs.add(SourceFile.fromInputStream("stdin", System.in));
            usingStdin = true;
        }
        return inputs;
    }

    private List<SourceFile> createSourceInputs(List<String> files) throws FlagUsageException, IOException {
        if (this.isInTestMode()) {
            return (List)this.inputsSupplierForTesting.get();
        }
        if (files.isEmpty()) {
            files = Collections.singletonList("-");
        }
        try {
            return this.createInputs(files, true);
        }
        catch (FlagUsageException e) {
            throw new FlagUsageException("Bad --js flag. " + e.getMessage());
        }
    }

    private List<SourceFile> createExternInputs(List<String> files) throws FlagUsageException, IOException {
        if (files.isEmpty()) {
            return ImmutableList.of((Object)SourceFile.fromCode("/dev/null", ""));
        }
        try {
            return this.createInputs(files, false);
        }
        catch (FlagUsageException e) {
            throw new FlagUsageException("Bad --externs flag. " + e.getMessage());
        }
    }

    List<JSModule> createJsModules(List<String> specs, List<String> jsFiles) throws FlagUsageException, IOException {
        if (this.isInTestMode()) {
            return (List)this.modulesSupplierForTesting.get();
        }
        Preconditions.checkState((specs != null ? 1 : 0) != 0);
        Preconditions.checkState((!specs.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((jsFiles != null ? 1 : 0) != 0);
        int totalNumJsFiles = jsFiles.size();
        int nextJsFileIndex = 0;
        LinkedHashMap modulesByName = Maps.newLinkedHashMap();
        for (String spec : specs) {
            String depList;
            String[] parts = spec.split(":");
            if (parts.length < 2 || parts.length > 4) {
                throw new FlagUsageException("Expected 2-4 colon-delimited parts in module spec: " + spec);
            }
            String name = parts[0];
            this.checkModuleName(name);
            if (modulesByName.containsKey(name)) {
                throw new FlagUsageException("Duplicate module name: " + name);
            }
            JSModule module = new JSModule(name);
            int numJsFiles = -1;
            try {
                numJsFiles = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ignored) {
                numJsFiles = -1;
            }
            if (numJsFiles < 0) {
                throw new FlagUsageException("Invalid JS file count '" + parts[1] + "' for module: " + name);
            }
            if (nextJsFileIndex + numJsFiles > totalNumJsFiles) {
                throw new FlagUsageException("Not enough JS files specified. Expected " + (nextJsFileIndex + numJsFiles - totalNumJsFiles) + " more in module:" + name);
            }
            List<String> moduleJsFiles = jsFiles.subList(nextJsFileIndex, nextJsFileIndex + numJsFiles);
            for (SourceFile input : this.createInputs(moduleJsFiles, false)) {
                module.add(input);
            }
            nextJsFileIndex += numJsFiles;
            if (parts.length > 2 && (depList = parts[2]).length() > 0) {
                String[] deps;
                for (String dep : deps = depList.split(",")) {
                    JSModule other = (JSModule)modulesByName.get(dep);
                    if (other == null) {
                        throw new FlagUsageException("Module '" + name + "' depends on unknown module '" + dep + "'. Be sure to list modules in dependency order.");
                    }
                    module.addDependency(other);
                }
            }
            modulesByName.put(name, module);
        }
        if (nextJsFileIndex < totalNumJsFiles) {
            throw new FlagUsageException("Too many JS files specified. Expected " + nextJsFileIndex + " but found " + totalNumJsFiles);
        }
        return Lists.newArrayList(modulesByName.values());
    }

    protected void checkModuleName(String name) throws FlagUsageException {
        if (!TokenStream.isJSIdentifier(name)) {
            throw new FlagUsageException("Invalid module name: '" + name + "'");
        }
    }

    static Map<String, String> parseModuleWrappers(List<String> specs, List<JSModule> modules) throws FlagUsageException {
        Preconditions.checkState((specs != null ? 1 : 0) != 0);
        HashMap wrappers = Maps.newHashMapWithExpectedSize((int)modules.size());
        for (JSModule m : modules) {
            wrappers.put(m.getName(), "");
        }
        for (String spec : specs) {
            int pos = spec.indexOf(58);
            if (pos == -1) {
                throw new FlagUsageException("Expected module wrapper to have <name>:<wrapper> format: " + spec);
            }
            String name = spec.substring(0, pos);
            if (!wrappers.containsKey(name)) {
                throw new FlagUsageException("Unknown module: '" + name + "'");
            }
            String wrapper = spec.substring(pos + 1);
            if (!wrapper.contains("%s")) {
                throw new FlagUsageException("No %s placeholder in module wrapper: '" + wrapper + "'");
            }
            wrappers.put(name, wrapper);
        }
        return wrappers;
    }

    private String getModuleOutputFileName(JSModule m) {
        return this.config.moduleOutputPathPrefix + m.getName() + ".js";
    }

    @VisibleForTesting
    void writeModuleOutput(Appendable out, JSModule m) throws FlagUsageException, IOException {
        if (this.parsedModuleWrappers == null) {
            this.parsedModuleWrappers = AbstractCommandLineRunner.parseModuleWrappers(this.config.moduleWrapper, Lists.newArrayList(((Compiler)this.compiler).getDegenerateModuleGraph().getAllModules()));
        }
        String fileName = this.getModuleOutputFileName(m);
        String baseName = new File(fileName).getName();
        AbstractCommandLineRunner.writeOutput(out, this.compiler, ((Compiler)this.compiler).toSource(m), this.parsedModuleWrappers.get(m.getName()).replace("%basename%", baseName), "%s", null);
    }

    static void writeOutput(Appendable out, Compiler compiler, String code, String wrapper, String codePlaceholder, @Nullable Function<String, String> escaper) throws IOException {
        int pos = wrapper.indexOf(codePlaceholder);
        if (pos != -1) {
            String prefix = "";
            if (pos > 0) {
                prefix = wrapper.substring(0, pos);
                out.append(prefix);
            }
            out.append(escaper == null ? code : (String)escaper.apply((Object)code));
            int suffixStart = pos + codePlaceholder.length();
            if (suffixStart != wrapper.length()) {
                out.append(wrapper.substring(suffixStart));
            }
            out.append('\n');
            if (compiler != null && compiler.getSourceMap() != null) {
                compiler.getSourceMap().setWrapperPrefix(prefix);
            }
        } else {
            out.append(code);
            out.append('\n');
        }
    }

    private static void maybeCreateDirsForPath(String pathPrefix) {
        if (pathPrefix.length() > 0) {
            String dirName;
            String string = dirName = pathPrefix.charAt(pathPrefix.length() - 1) == File.separatorChar ? pathPrefix.substring(0, pathPrefix.length() - 1) : new File(pathPrefix).getParent();
            if (dirName != null) {
                new File(dirName).mkdirs();
            }
        }
    }

    private Appendable createDefaultOutput() throws IOException {
        boolean writeOutputToFile;
        boolean bl = writeOutputToFile = !this.config.jsOutputFile.isEmpty();
        if (writeOutputToFile) {
            return this.fileNameToLegacyOutputWriter(this.config.jsOutputFile);
        }
        return this.streamToLegacyOutputWriter(this.defaultJsOutput);
    }

    private static void closeAppendable(Appendable output) throws IOException {
        if (output instanceof Flushable) {
            ((Flushable)((Object)output)).flush();
        }
        if (output instanceof Closeable) {
            ((Closeable)((Object)output)).close();
        }
    }

    protected int doRun() throws FlagUsageException, IOException {
        Compiler.setLoggingLevel(Level.parse(this.config.loggingLevel));
        List<SourceFile> externs = this.createExterns();
        this.compiler = this.createCompiler();
        B options = this.createOptions();
        ArrayList modules = null;
        Result result = null;
        this.setRunOptions((CompilerOptions)options);
        boolean writeOutputToFile = !this.config.jsOutputFile.isEmpty();
        ArrayList outputFileNames = Lists.newArrayList();
        if (writeOutputToFile) {
            outputFileNames.add(this.config.jsOutputFile);
        }
        List jsFiles = this.config.js;
        List moduleSpecs = this.config.module;
        boolean createCommonJsModules = false;
        if (((CompilerOptions)options).processCommonJSModules && moduleSpecs.size() == 1 && "auto".equals(moduleSpecs.get(0))) {
            createCommonJsModules = true;
            moduleSpecs.remove(0);
        }
        if (!moduleSpecs.isEmpty()) {
            modules = this.createJsModules(moduleSpecs, jsFiles);
            for (JSModule m : modules) {
                outputFileNames.add(this.getModuleOutputFileName(m));
            }
            if (this.config.skipNormalOutputs) {
                ((Compiler)this.compiler).initModules(externs, modules, (CompilerOptions)options);
            } else {
                result = ((Compiler)this.compiler).compileModules(externs, modules, (CompilerOptions)options);
            }
        } else {
            List<SourceFile> inputs = this.createSourceInputs(jsFiles);
            if (this.config.skipNormalOutputs) {
                ((Compiler)this.compiler).init(externs, inputs, (CompilerOptions)options);
            } else {
                result = ((Compiler)this.compiler).compile(externs, inputs, (CompilerOptions)options);
            }
        }
        if (createCommonJsModules) {
            modules = Lists.newArrayList(((Compiler)this.compiler).getDegenerateModuleGraph().getAllModules());
            for (JSModule m : modules) {
                outputFileNames.add(this.getModuleOutputFileName(m));
            }
        }
        for (String outputFileName : outputFileNames) {
            if (((Compiler)this.compiler).getSourceFileByName(outputFileName) == null) continue;
            ((Compiler)this.compiler).report(JSError.make(OUTPUT_SAME_AS_INPUT_ERROR, outputFileName));
            return 1;
        }
        return this.processResults(result, modules, options);
    }

    int processResults(Result result, List<JSModule> modules, B options) throws FlagUsageException, IOException {
        if (this.config.printPassGraph) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            jsOutput.append(DotFormatter.toDot(((Compiler)this.compiler).getPassConfig().getPassGraph()));
            jsOutput.append('\n');
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.printAst) {
            if (((Compiler)this.compiler).getRoot() == null) {
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            ControlFlowGraph<Node> cfg = ((Compiler)this.compiler).computeCFG();
            DotFormatter.appendDot(((Compiler)this.compiler).getRoot().getLastChild(), cfg, jsOutput);
            jsOutput.append('\n');
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        if (this.config.printTree) {
            if (((Compiler)this.compiler).getRoot() == null) {
                ((Compiler)this.compiler).report(JSError.make(NO_TREE_GENERATED_ERROR, new String[0]));
                return 1;
            }
            Appendable jsOutput = this.createDefaultOutput();
            ((Compiler)this.compiler).getRoot().appendStringTree(jsOutput);
            jsOutput.append("\n");
            AbstractCommandLineRunner.closeAppendable(jsOutput);
            return 0;
        }
        this.rootRelativePathsMap = this.constructRootRelativePathsMap();
        if (this.config.skipNormalOutputs) {
            this.outputManifest();
            this.outputBundle();
            this.outputModuleGraphJson();
            return 0;
        }
        if (result.success) {
            this.outputModuleGraphJson();
            if (modules == null) {
                this.outputSingleBinary();
                this.outputSourceMap(options, this.config.jsOutputFile);
            } else {
                this.outputModuleBinaryAndSourceMaps(modules, options);
            }
            if (((CompilerOptions)options).externExportsPath != null) {
                Writer eeOut = this.openExternExportsStream(options, this.config.jsOutputFile);
                eeOut.append(result.externExport);
                eeOut.close();
            }
            this.outputNameMaps();
            this.outputManifest();
            this.outputBundle();
        }
        return Math.min(result.errors.length, 127);
    }

    Function<String, String> getJavascriptEscaper() {
        throw new UnsupportedOperationException("SourceCodeEscapers is not in the standard release of Guava yet :(");
    }

    void outputSingleBinary() throws IOException {
        Function<String, String> escaper = null;
        String marker = OUTPUT_MARKER;
        if (this.config.outputWrapper.contains(OUTPUT_MARKER_JS_STRING)) {
            marker = OUTPUT_MARKER_JS_STRING;
            escaper = this.getJavascriptEscaper();
        }
        Appendable jsOutput = this.createDefaultOutput();
        AbstractCommandLineRunner.writeOutput(jsOutput, this.compiler, ((Compiler)this.compiler).toSource(), this.config.outputWrapper, marker, escaper);
        AbstractCommandLineRunner.closeAppendable(jsOutput);
    }

    private void outputModuleBinaryAndSourceMaps(List<JSModule> modules, B options) throws FlagUsageException, IOException {
        this.parsedModuleWrappers = AbstractCommandLineRunner.parseModuleWrappers(this.config.moduleWrapper, modules);
        AbstractCommandLineRunner.maybeCreateDirsForPath(this.config.moduleOutputPathPrefix);
        Writer mapOut = null;
        if (!this.shouldGenerateMapPerModule(options)) {
            mapOut = this.fileNameToOutputWriter2(this.expandSourceMapPath(options, null));
        }
        for (JSModule m : modules) {
            if (this.shouldGenerateMapPerModule(options)) {
                mapOut = this.fileNameToOutputWriter2(this.expandSourceMapPath(options, m));
            }
            Writer writer = this.fileNameToLegacyOutputWriter(this.getModuleOutputFileName(m));
            if (((CompilerOptions)options).sourceMapOutputPath != null) {
                ((Compiler)this.compiler).getSourceMap().reset();
            }
            this.writeModuleOutput(writer, m);
            if (((CompilerOptions)options).sourceMapOutputPath != null) {
                ((Compiler)this.compiler).getSourceMap().appendTo(mapOut, m.getName());
            }
            writer.close();
            if (!this.shouldGenerateMapPerModule(options) || mapOut == null) continue;
            mapOut.close();
            mapOut = null;
        }
        if (mapOut != null) {
            mapOut.close();
        }
    }

    private Charset getInputCharset() throws FlagUsageException {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return Charsets.UTF_8;
    }

    private String getLegacyOutputCharset() throws FlagUsageException {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return this.config.charset;
        }
        return "US-ASCII";
    }

    private Charset getOutputCharset2() throws FlagUsageException {
        if (!this.config.charset.isEmpty()) {
            if (!Charset.isSupported(this.config.charset)) {
                throw new FlagUsageException(this.config.charset + " is not a valid charset name.");
            }
            return Charset.forName(this.config.charset);
        }
        return Charsets.UTF_8;
    }

    protected List<SourceFile> createExterns() throws FlagUsageException, IOException {
        return this.isInTestMode() ? (List<SourceFile>)this.externsSupplierForTesting.get() : this.createExternInputs(this.config.externs);
    }

    private boolean shouldGenerateMapPerModule(B options) {
        return ((CompilerOptions)options).sourceMapOutputPath != null && ((CompilerOptions)options).sourceMapOutputPath.contains("%outname%");
    }

    private Writer openExternExportsStream(B options, String path) throws IOException {
        if (((CompilerOptions)options).externExportsPath == null) {
            return null;
        }
        String exPath = ((CompilerOptions)options).externExportsPath;
        if (!exPath.contains(File.separator)) {
            File outputFile = new File(path);
            exPath = outputFile.getParent() + File.separatorChar + exPath;
        }
        return this.fileNameToOutputWriter2(exPath);
    }

    private String expandCommandLinePath(String path, JSModule forModule) {
        String sub = forModule != null ? this.config.moduleOutputPathPrefix + forModule.getName() + ".js" : (!this.config.module.isEmpty() ? this.config.moduleOutputPathPrefix : this.config.jsOutputFile);
        return path.replace("%outname%", sub);
    }

    @VisibleForTesting
    String expandSourceMapPath(B options, JSModule forModule) {
        if (Strings.isNullOrEmpty((String)((CompilerOptions)options).sourceMapOutputPath)) {
            return null;
        }
        return this.expandCommandLinePath(((CompilerOptions)options).sourceMapOutputPath, forModule);
    }

    private Writer fileNameToLegacyOutputWriter(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        if (this.testMode) {
            return new StringWriter();
        }
        return this.streamToLegacyOutputWriter(this.filenameToOutputStream(fileName));
    }

    private Writer fileNameToOutputWriter2(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        if (this.testMode) {
            return new StringWriter();
        }
        return this.streamToOutputWriter2(this.filenameToOutputStream(fileName));
    }

    protected OutputStream filenameToOutputStream(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        return new FileOutputStream(fileName);
    }

    private Writer streamToLegacyOutputWriter(OutputStream stream) throws IOException {
        if (this.legacyOutputCharset == null) {
            return new BufferedWriter(new OutputStreamWriter(stream));
        }
        return new BufferedWriter(new OutputStreamWriter(stream, this.legacyOutputCharset));
    }

    private Writer streamToOutputWriter2(OutputStream stream) {
        if (this.outputCharset2 == null) {
            return new BufferedWriter(new OutputStreamWriter(stream));
        }
        return new BufferedWriter(new OutputStreamWriter(stream, this.outputCharset2));
    }

    private void outputSourceMap(B options, String associatedName) throws IOException {
        if (Strings.isNullOrEmpty((String)((CompilerOptions)options).sourceMapOutputPath)) {
            return;
        }
        String outName = this.expandSourceMapPath(options, null);
        Writer out = this.fileNameToOutputWriter2(outName);
        ((Compiler)this.compiler).getSourceMap().appendTo(out, associatedName);
        out.close();
    }

    private String getMapPath(String outputFile) {
        String basePath = "";
        if (outputFile.equals("")) {
            basePath = !this.config.moduleOutputPathPrefix.equals("") ? this.config.moduleOutputPathPrefix : "jscompiler";
        } else {
            File file = new File(outputFile);
            String outputFileName = file.getName();
            if (outputFileName.endsWith(".js")) {
                outputFileName = outputFileName.substring(0, outputFileName.length() - 3);
            }
            basePath = file.getParent() + File.separatorChar + outputFileName;
        }
        return basePath;
    }

    private void outputNameMaps() throws FlagUsageException, IOException {
        String propertyMapOutputPath = null;
        String variableMapOutputPath = null;
        String functionInformationMapOutputPath = null;
        if (this.config.createNameMapFiles) {
            String basePath = this.getMapPath(this.config.jsOutputFile);
            propertyMapOutputPath = basePath + "_props_map.out";
            variableMapOutputPath = basePath + "_vars_map.out";
            functionInformationMapOutputPath = basePath + "_functions_map.out";
        }
        if (!this.config.variableMapOutputFile.equals("")) {
            if (variableMapOutputPath != null) {
                throw new FlagUsageException("The flags variable_map_output_file and create_name_map_files cannot both be used simultaniously.");
            }
            variableMapOutputPath = this.config.variableMapOutputFile;
        }
        if (!this.config.propertyMapOutputFile.equals("")) {
            if (propertyMapOutputPath != null) {
                throw new FlagUsageException("The flags property_map_output_file and create_name_map_files cannot both be used simultaniously.");
            }
            propertyMapOutputPath = this.config.propertyMapOutputFile;
        }
        if (variableMapOutputPath != null && ((Compiler)this.compiler).getVariableMap() != null) {
            ((Compiler)this.compiler).getVariableMap().save(variableMapOutputPath);
        }
        if (propertyMapOutputPath != null && ((Compiler)this.compiler).getPropertyMap() != null) {
            ((Compiler)this.compiler).getPropertyMap().save(propertyMapOutputPath);
        }
        if (functionInformationMapOutputPath != null && ((Compiler)this.compiler).getFunctionalInformationMap() != null) {
            OutputStream file = this.filenameToOutputStream(functionInformationMapOutputPath);
            CodedOutputStream outputStream = CodedOutputStream.newInstance(file);
            ((Compiler)this.compiler).getFunctionalInformationMap().writeTo(outputStream);
            outputStream.flush();
            file.flush();
            file.close();
        }
    }

    @VisibleForTesting
    static void createDefineOrTweakReplacements(List<String> definitions, CompilerOptions options, boolean tweaks) {
        for (String override : definitions) {
            String[] assignment = override.split("=", 2);
            String defName = assignment[0];
            if (defName.length() > 0) {
                String defValue = assignment.length == 1 ? "true" : assignment[1];
                boolean isTrue = defValue.equals("true");
                boolean isFalse = defValue.equals("false");
                if (isTrue || isFalse) {
                    if (tweaks) {
                        options.setTweakToBooleanLiteral(defName, isTrue);
                        continue;
                    }
                    options.setDefineToBooleanLiteral(defName, isTrue);
                    continue;
                }
                if (defValue.length() > 1 && (defValue.charAt(0) == '\'' && defValue.charAt(defValue.length() - 1) == '\'' || defValue.charAt(0) == '\"' && defValue.charAt(defValue.length() - 1) == '\"')) {
                    String maybeStringVal = defValue.substring(1, defValue.length() - 1);
                    if (maybeStringVal.indexOf(defValue.charAt(0)) == -1) {
                        if (tweaks) {
                            options.setTweakToStringLiteral(defName, maybeStringVal);
                            continue;
                        }
                        options.setDefineToStringLiteral(defName, maybeStringVal);
                        continue;
                    }
                } else {
                    try {
                        double value = Double.parseDouble(defValue);
                        if (tweaks) {
                            options.setTweakToDoubleLiteral(defName, value);
                            continue;
                        }
                        options.setDefineToDoubleLiteral(defName, value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (tweaks) {
                throw new RuntimeException("--tweak flag syntax invalid: " + override);
            }
            throw new RuntimeException("--define flag syntax invalid: " + override);
        }
    }

    private boolean shouldGenerateOutputPerModule(String output) {
        return !this.config.module.isEmpty() && output != null && output.contains("%outname%");
    }

    private void outputManifest() throws IOException {
        this.outputManifestOrBundle(this.config.outputManifests, true);
    }

    private void outputBundle() throws IOException {
        this.outputManifestOrBundle(this.config.outputBundles, false);
    }

    private void outputManifestOrBundle(List<String> outputFiles, boolean isManifest) throws IOException {
        if (outputFiles.isEmpty()) {
            return;
        }
        for (String output : outputFiles) {
            if (output.isEmpty()) continue;
            if (this.shouldGenerateOutputPerModule(output)) {
                JSModuleGraph graph = ((Compiler)this.compiler).getDegenerateModuleGraph();
                Iterable<JSModule> modules = graph.getAllModules();
                for (JSModule module : modules) {
                    Writer out = this.fileNameToOutputWriter2(this.expandCommandLinePath(output, module));
                    if (isManifest) {
                        this.printManifestTo(module.getInputs(), out);
                    } else {
                        this.printBundleTo(module.getInputs(), out);
                    }
                    out.close();
                }
                continue;
            }
            Writer out = this.fileNameToOutputWriter2(this.expandCommandLinePath(output, null));
            if (this.config.module.isEmpty()) {
                if (isManifest) {
                    this.printManifestTo(((Compiler)this.compiler).getInputsInOrder(), out);
                } else {
                    this.printBundleTo(((Compiler)this.compiler).getInputsInOrder(), out);
                }
            } else {
                this.printModuleGraphManifestOrBundleTo(((Compiler)this.compiler).getDegenerateModuleGraph(), out, isManifest);
            }
            out.close();
        }
    }

    private void outputModuleGraphJson() throws IOException {
        if (this.config.outputModuleDependencies != null && this.config.outputModuleDependencies.length() != 0) {
            Writer out = this.fileNameToOutputWriter2(this.config.outputModuleDependencies);
            this.printModuleGraphJsonTo(out);
            out.close();
        }
    }

    @VisibleForTesting
    void printModuleGraphJsonTo(Appendable out) throws IOException {
        out.append(((Compiler)this.compiler).getDegenerateModuleGraph().toJson().toString());
    }

    @VisibleForTesting
    void printModuleGraphManifestOrBundleTo(JSModuleGraph graph, Appendable out, boolean isManifest) throws IOException {
        Joiner commas = Joiner.on((String)",");
        boolean requiresNewline = false;
        for (JSModule module : graph.getAllModules()) {
            if (requiresNewline) {
                out.append("\n");
            }
            if (isManifest) {
                String dependencies = commas.join(module.getSortedDependencyNames());
                out.append(String.format("{%s%s}\n", module.getName(), dependencies.isEmpty() ? "" : ":" + dependencies));
                this.printManifestTo(module.getInputs(), out);
            } else {
                this.printBundleTo(module.getInputs(), out);
            }
            requiresNewline = true;
        }
    }

    private void printManifestTo(Iterable<CompilerInput> inputs, Appendable out) throws IOException {
        for (CompilerInput input : inputs) {
            String rootRelativePath = this.rootRelativePathsMap.get(input.getName());
            String displayName = rootRelativePath != null ? rootRelativePath : input.getName();
            out.append(displayName);
            out.append("\n");
        }
    }

    private void printBundleTo(Iterable<CompilerInput> inputs, Appendable out) throws IOException {
        for (CompilerInput input : inputs) {
            if (input.getName().equals(Compiler.createFillFileName("[singleton]"))) {
                Preconditions.checkState((1 == Iterables.size(inputs) ? 1 : 0) != 0);
                return;
            }
            String rootRelativePath = this.rootRelativePathsMap.get(input.getName());
            String displayName = rootRelativePath != null ? rootRelativePath : input.getName();
            File file = new File(input.getName());
            out.append("//");
            out.append(displayName);
            out.append("\n");
            Files.copy((File)file, (Charset)this.inputCharset, (Appendable)out);
            out.append("\n");
        }
    }

    private Map<String, String> constructRootRelativePathsMap() {
        LinkedHashMap rootRelativePathsMap = Maps.newLinkedHashMap();
        for (String mapString : this.config.manifestMaps) {
            int colonIndex = mapString.indexOf(58);
            Preconditions.checkState((colonIndex > 0 ? 1 : 0) != 0);
            String execPath = mapString.substring(0, colonIndex);
            String rootRelativePath = mapString.substring(colonIndex + 1);
            Preconditions.checkState((rootRelativePath.indexOf(58) == -1 ? 1 : 0) != 0);
            rootRelativePathsMap.put(execPath, rootRelativePath);
        }
        return rootRelativePathsMap;
    }

    protected static class WarningGuardSpec {
        private final List<Entry> entries = Lists.newArrayList();

        protected WarningGuardSpec() {
        }

        protected void add(CheckLevel level, String groupName) {
            this.entries.add(new Entry(level, groupName));
        }

        protected void clear() {
            this.entries.clear();
        }

        private static class Entry {
            private final CheckLevel level;
            private final String groupName;

            private Entry(CheckLevel level, String groupName) {
                this.level = level;
                this.groupName = groupName;
            }
        }
    }

    static class CommandLineConfig {
        private boolean printTree = false;
        private boolean printAst = false;
        private boolean printPassGraph = false;
        private CompilerOptions.DevMode jscompDevMode = CompilerOptions.DevMode.OFF;
        private String loggingLevel = Level.WARNING.getName();
        private final List<String> externs = Lists.newArrayList();
        private final List<String> js = Lists.newArrayList();
        private String jsOutputFile = "";
        private final List<String> module = Lists.newArrayList();
        private String variableMapInputFile = "";
        private String propertyMapInputFile = "";
        private String variableMapOutputFile = "";
        private boolean createNameMapFiles = false;
        private String propertyMapOutputFile = "";
        private CodingConvention codingConvention = CodingConventions.getDefault();
        private int summaryDetailLevel = 1;
        private String outputWrapper = "";
        private final List<String> moduleWrapper = Lists.newArrayList();
        private String moduleOutputPathPrefix = "";
        private String createSourceMap = "";
        private SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
        private SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
        private WarningGuardSpec warningGuards = null;
        private final List<String> define = Lists.newArrayList();
        private final List<String> tweak = Lists.newArrayList();
        private CompilerOptions.TweakProcessing tweakProcessing = CompilerOptions.TweakProcessing.OFF;
        private String charset = "";
        private boolean manageClosureDependencies = false;
        private boolean onlyClosureDependencies = false;
        private List<String> closureEntryPoints = ImmutableList.of();
        private List<String> outputManifests = ImmutableList.of();
        private String outputModuleDependencies = null;
        private List<String> outputBundles = ImmutableList.of();
        private boolean acceptConstKeyword = false;
        private String languageIn = "";
        private boolean skipNormalOutputs = false;
        private List<String> manifestMaps = ImmutableList.of();
        private boolean transformAMDToCJSModules = false;
        private boolean processCommonJSModules = false;
        private String commonJSModulePathPrefix = "./";
        private String warningsWhitelistFile = "";
        private boolean angularPass = false;
        private CompilerOptions.TracerMode tracerMode = CompilerOptions.TracerMode.OFF;

        CommandLineConfig() {
        }

        CommandLineConfig setPrintTree(boolean printTree) {
            this.printTree = printTree;
            return this;
        }

        CommandLineConfig setPrintAst(boolean printAst) {
            this.printAst = printAst;
            return this;
        }

        CommandLineConfig setPrintPassGraph(boolean printPassGraph) {
            this.printPassGraph = printPassGraph;
            return this;
        }

        CommandLineConfig setJscompDevMode(CompilerOptions.DevMode jscompDevMode) {
            this.jscompDevMode = jscompDevMode;
            return this;
        }

        CommandLineConfig setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        CommandLineConfig setExterns(List<String> externs) {
            this.externs.clear();
            this.externs.addAll(externs);
            return this;
        }

        CommandLineConfig setJs(List<String> js) {
            this.js.clear();
            this.js.addAll(js);
            return this;
        }

        CommandLineConfig setJsOutputFile(String jsOutputFile) {
            this.jsOutputFile = jsOutputFile;
            return this;
        }

        CommandLineConfig setModule(List<String> module) {
            this.module.clear();
            this.module.addAll(module);
            return this;
        }

        CommandLineConfig setVariableMapInputFile(String variableMapInputFile) {
            this.variableMapInputFile = variableMapInputFile;
            return this;
        }

        CommandLineConfig setPropertyMapInputFile(String propertyMapInputFile) {
            this.propertyMapInputFile = propertyMapInputFile;
            return this;
        }

        CommandLineConfig setVariableMapOutputFile(String variableMapOutputFile) {
            this.variableMapOutputFile = variableMapOutputFile;
            return this;
        }

        CommandLineConfig setCreateNameMapFiles(boolean createNameMapFiles) {
            this.createNameMapFiles = createNameMapFiles;
            return this;
        }

        CommandLineConfig setPropertyMapOutputFile(String propertyMapOutputFile) {
            this.propertyMapOutputFile = propertyMapOutputFile;
            return this;
        }

        CommandLineConfig setCodingConvention(CodingConvention codingConvention) {
            this.codingConvention = codingConvention;
            return this;
        }

        CommandLineConfig setSummaryDetailLevel(int summaryDetailLevel) {
            this.summaryDetailLevel = summaryDetailLevel;
            return this;
        }

        CommandLineConfig setOutputWrapper(String outputWrapper) {
            this.outputWrapper = outputWrapper;
            return this;
        }

        CommandLineConfig setModuleWrapper(List<String> moduleWrapper) {
            this.moduleWrapper.clear();
            this.moduleWrapper.addAll(moduleWrapper);
            return this;
        }

        CommandLineConfig setModuleOutputPathPrefix(String moduleOutputPathPrefix) {
            this.moduleOutputPathPrefix = moduleOutputPathPrefix;
            return this;
        }

        CommandLineConfig setCreateSourceMap(String createSourceMap) {
            this.createSourceMap = createSourceMap;
            return this;
        }

        CommandLineConfig setSourceMapDetailLevel(SourceMap.DetailLevel level) {
            this.sourceMapDetailLevel = level;
            return this;
        }

        CommandLineConfig setSourceMapFormat(SourceMap.Format format) {
            this.sourceMapFormat = format;
            return this;
        }

        CommandLineConfig setWarningGuardSpec(WarningGuardSpec spec) {
            this.warningGuards = spec;
            return this;
        }

        CommandLineConfig setDefine(List<String> define) {
            this.define.clear();
            this.define.addAll(define);
            return this;
        }

        CommandLineConfig setTweak(List<String> tweak) {
            this.tweak.clear();
            this.tweak.addAll(tweak);
            return this;
        }

        CommandLineConfig setTweakProcessing(CompilerOptions.TweakProcessing tweakProcessing) {
            this.tweakProcessing = tweakProcessing;
            return this;
        }

        CommandLineConfig setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        CommandLineConfig setManageClosureDependencies(boolean newVal) {
            this.manageClosureDependencies = newVal;
            return this;
        }

        CommandLineConfig setOnlyClosureDependencies(boolean newVal) {
            this.onlyClosureDependencies = newVal;
            return this;
        }

        CommandLineConfig setClosureEntryPoints(List<String> entryPoints) {
            Preconditions.checkNotNull(entryPoints);
            this.closureEntryPoints = entryPoints;
            return this;
        }

        CommandLineConfig setOutputManifest(List<String> outputManifests) {
            this.outputManifests = Lists.newArrayList();
            for (String manifestName : outputManifests) {
                if (manifestName.isEmpty()) continue;
                this.outputManifests.add(manifestName);
            }
            this.outputManifests = ImmutableList.copyOf(this.outputManifests);
            return this;
        }

        CommandLineConfig setOutputModuleDependencies(String outputModuleDependencies) {
            this.outputModuleDependencies = outputModuleDependencies;
            return this;
        }

        CommandLineConfig setOutputBundle(List<String> outputBundles) {
            this.outputBundles = outputBundles;
            return this;
        }

        CommandLineConfig setAcceptConstKeyword(boolean acceptConstKeyword) {
            this.acceptConstKeyword = acceptConstKeyword;
            return this;
        }

        CommandLineConfig setLanguageIn(String languageIn) {
            this.languageIn = languageIn;
            return this;
        }

        CommandLineConfig setSkipNormalOutputs(boolean skipNormalOutputs) {
            this.skipNormalOutputs = skipNormalOutputs;
            return this;
        }

        CommandLineConfig setManifestMaps(List<String> manifestMaps) {
            this.manifestMaps = manifestMaps;
            return this;
        }

        CommandLineConfig setTransformAMDToCJSModules(boolean transformAMDToCJSModules) {
            this.transformAMDToCJSModules = transformAMDToCJSModules;
            return this;
        }

        CommandLineConfig setProcessCommonJSModules(boolean processCommonJSModules) {
            this.processCommonJSModules = processCommonJSModules;
            return this;
        }

        CommandLineConfig setCommonJSModulePathPrefix(String commonJSModulePathPrefix) {
            this.commonJSModulePathPrefix = commonJSModulePathPrefix;
            return this;
        }

        CommandLineConfig setWarningsWhitelistFile(String fileName) {
            this.warningsWhitelistFile = fileName;
            return this;
        }

        CommandLineConfig setAngularPass(boolean angularPass) {
            this.angularPass = angularPass;
            return this;
        }

        CommandLineConfig setTracerMode(CompilerOptions.TracerMode tracerMode) {
            this.tracerMode = tracerMode;
            return this;
        }
    }

    public static class FlagUsageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FlagUsageException(String message) {
            super(message);
        }
    }
}

