/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Collection;

class DisambiguatePrivateProperties
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final ImmutableSet<String> blacklist;
    private String fileid;
    private int id = 0;

    DisambiguatePrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
        CodingConvention convention = this.compiler.getCodingConvention();
        Collection<String> indirect = convention.getIndirectlyDeclaredProperties();
        this.blacklist = ImmutableSet.copyOf(indirect);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.fileid = "$" + this.id++;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 33: {
                this.maybeRename(n.getLastChild());
                break;
            }
            case 147: 
            case 148: 
            case 154: {
                this.maybeRename(n);
            }
        }
    }

    private void maybeRename(Node n) {
        CodingConvention convention = this.compiler.getCodingConvention();
        String prop = n.getString();
        if (!n.getBooleanProp(36) && convention.isPrivate(prop) && !this.blacklist.contains((Object)prop)) {
            n.setString(prop + this.fileid);
            this.compiler.reportCodeChange();
        }
    }
}

